/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.search.JSClassSearch;
import com.intellij.lang.javascript.search.JSFunctionsSearch;
import com.intellij.lang.javascript.validation.FunctionCollector;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Function;
import com.intellij.util.PairFunction;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSInheritanceUtil {
    private static final ThreadLocal<GlobalSearchScope> ourEnforcedScope = new ThreadLocal();

    public static <T extends JSPsiElementBase> boolean iterateOverriddenMembersUp(@NotNull JSPsiElementBase method, boolean recursive, PairFunction<List<T>, String, Boolean> methodsProcessor, boolean onlyFunctions) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "iterateOverriddenMembersUp"));
        }
        return JSInheritanceUtil.iterateOverriddenMembersUp(method, recursive, methodsProcessor, (Set<String>)new THashSet(), onlyFunctions);
    }

    private static <T extends JSPsiElementBase> boolean iterateOverriddenMembersUp(@NotNull JSPsiElementBase method, final boolean recursive, final PairFunction<List<T>, String, Boolean> methodsProcessor, final Set<String> visitedTypes, final boolean onlyFunctions) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "iterateOverriddenMembersUp"));
        }
        String qName = JSResolveUtil.getQNameToStartHierarchySearch(method);
        String methodName = method.getName();
        if (qName != null && methodName != null) {
            boolean nodeIsMember;
            PsiElement parent = JSResolveUtil.findParent((PsiElement)method);
            boolean bl = nodeIsMember = !qName.endsWith(methodName);
            if (!nodeIsMember) {
                return true;
            }
            return JSResolveUtil.iterateType(method, (PsiElement)(parent instanceof JSClass ? parent : method.getContainingFile()), qName, new JSResolveUtil.OverrideHandler(){

                @Override
                public boolean process(@NotNull List<JSPsiElementBase> elements, PsiElement scope, String className) {
                    if (elements == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil$1", "process"));
                    }
                    if (!visitedTypes.add(className)) {
                        return true;
                    }
                    ArrayList<JSPsiElementBase> results = new ArrayList<JSPsiElementBase>(elements.size());
                    for (PsiElement psiElement : elements) {
                        results.add((JSPsiElementBase)psiElement);
                    }
                    if (!((Boolean)methodsProcessor.fun(results, (Object)className)).booleanValue()) {
                        return false;
                    }
                    if (recursive) {
                        for (PsiElement psiElement : elements) {
                            if (onlyFunctions && !(psiElement instanceof JSFunctionItem) || JSInheritanceUtil.iterateOverriddenMembersUp((JSPsiElementBase)psiElement, true, methodsProcessor, visitedTypes, onlyFunctions)) continue;
                            return false;
                        }
                    }
                    return true;
                }
            });
        }
        return true;
    }

    public static boolean iterateOverriddenMethodsUp(@NotNull JSFunction method, final Processor<JSFunction> methodsProcessor) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "iterateOverriddenMethodsUp"));
        }
        return JSInheritanceUtil.iterateOverriddenMembersUp((JSPsiElementBase)method, true, new PairFunction<List<JSPsiElementBase>, String, Boolean>(){

            public Boolean fun(List<JSPsiElementBase> jsNamedElements, String s) {
                if (jsNamedElements.isEmpty() || !(jsNamedElements.get(0) instanceof JSFunction)) {
                    return false;
                }
                if (!methodsProcessor.process((Object)((JSFunction)jsNamedElements.get(0)))) {
                    return false;
                }
                return true;
            }
        }, true);
    }

    public static Collection<JSFunction> findImplementedMethods(JSFunction implementingFunction) {
        if (!JSInheritanceUtil.canHaveSuperMethod(implementingFunction)) {
            return Collections.emptyList();
        }
        PsiElement clazz = JSResolveUtil.findParent((PsiElement)implementingFunction);
        if (!(clazz instanceof JSClass)) {
            return Collections.emptyList();
        }
        final HashSet results = new HashSet();
        JSResolveUtil.processInterfaceMethods((JSClass)clazz, new JSResolveUtil.CollectMethodsToImplementProcessor(implementingFunction.getName(), (PsiElement)implementingFunction, true){

            protected boolean process(SinkResolveProcessor processor) {
                results.addAll(processor.getResults());
                return true;
            }
        });
        ArrayList<JSFunction> functions = new ArrayList<JSFunction>(results.size());
        for (PsiElement element : results) {
            functions.add((JSFunction)element);
        }
        return functions;
    }

    @NotNull
    public static Collection<JSPsiElementBase> findNearestOverriddenMembers(JSPsiElementBase method, boolean onlyFunctions) {
        THashSet result = new THashSet();
        JSInheritanceUtil.iterateOverriddenMembersUp(method, false, new PairFunction<List<JSPsiElementBase>, String, Boolean>((Collection)result){
            final /* synthetic */ Collection val$result;
            {
                this.val$result = collection;
            }

            public Boolean fun(List<JSPsiElementBase> functions, String s) {
                this.val$result.addAll(functions);
                return true;
            }
        }, onlyFunctions);
        THashSet tHashSet = result;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "findNearestOverriddenMembers"));
        }
        return tHashSet;
    }

    public static boolean processNearestOverriddenMethods(JSFunctionItem method, final Processor<JSFunction> processor) {
        final Ref result = Ref.create((Object)Boolean.TRUE);
        JSInheritanceUtil.iterateOverriddenMembersUp((JSPsiElementBase)method, false, new PairFunction<List<JSPsiElementBase>, String, Boolean>(){

            public Boolean fun(List<JSPsiElementBase> functions, String s) {
                for (JSPsiElementBase function : functions) {
                    JSFunction overridden = JSPsiImplUtils.getPossibleFunction((PsiElement)function);
                    if (processor.process((Object)overridden)) continue;
                    result.set((Object)Boolean.FALSE);
                    return false;
                }
                return true;
            }
        }, true);
        return (Boolean)result.get();
    }

    @Nullable
    public static JSClass findSomeDeclaringClass(@NotNull JSFunction method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "findSomeDeclaringClass"));
        }
        return (JSClass)ContainerUtil.getFirstItem(JSInheritanceUtil.findDeclaringClasses(method), null);
    }

    public static Map<JSClass, JSFunction> findDeclaringClassesMap(@NotNull JSFunction method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "findDeclaringClassesMap"));
        }
        LinkedHashMap result = ContainerUtil.newLinkedHashMap();
        Collection<JSFunction> topMethods = JSInheritanceUtil.findTopMethods(method);
        for (JSFunction topMethod : topMethods) {
            PsiElement parent = JSResolveUtil.findParent((PsiElement)topMethod);
            if (!(parent instanceof JSClass)) continue;
            result.put((JSClass)parent, topMethod);
        }
        return result;
    }

    public static Collection<JSClass> findDeclaringClasses(@NotNull JSFunction method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "findDeclaringClasses"));
        }
        return JSInheritanceUtil.findDeclaringClassesMap(method).keySet();
    }

    public static Collection<JSFunction> findTopMethods(@NotNull JSFunction method) {
        Collection<JSFunction> implementedFunctions;
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "findTopMethods"));
        }
        JSFunction currentMethod = method;
        JSFunction topParent = JSInheritanceUtil.findTopOverriddenMethod(method);
        if (topParent != null) {
            currentMethod = topParent;
        }
        if (!(implementedFunctions = JSInheritanceUtil.findImplementedMethods(currentMethod)).isEmpty()) {
            return implementedFunctions;
        }
        return Collections.singletonList(currentMethod);
    }

    @Nullable
    public static JSFunction findTopOverriddenMethod(@NotNull JSFunction method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "findTopOverriddenMethod"));
        }
        final Ref result = new Ref();
        JSInheritanceUtil.iterateOverriddenMethodsUp(method, new Processor<JSFunction>(){

            public boolean process(JSFunction function) {
                result.set((Object)function);
                return true;
            }
        });
        return (JSFunction)result.get();
    }

    public static Collection<JSClass> findAllParentsForClass(@NotNull JSClass clazz, boolean includeNotProject) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "findAllParentsForClass"));
        }
        HashSet<JSClass> supers = new HashSet<JSClass>();
        JSInheritanceUtil.findAllParentsForClass(clazz, supers, includeNotProject);
        return supers;
    }

    public static void findAllParentsForClass(@NotNull JSClass clazz, @NotNull Collection<JSClass> result, boolean includeNotProject) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "findAllParentsForClass"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "findAllParentsForClass"));
        }
        for (JSClass superClass : clazz.getSupers()) {
            if (!includeNotProject && !clazz.getManager().isInProject((PsiElement)superClass) || superClass.isEquivalentTo((PsiElement)clazz) || JSPsiImplUtils.containsEquivalent(result, (PsiElement)superClass)) continue;
            if (!JSResolveUtil.isObjectClass(superClass)) {
                result.add(superClass);
                JSInheritanceUtil.findAllParentsForClass(superClass, result, includeNotProject);
                continue;
            }
            if (clazz.isInterface()) continue;
            result.add(superClass);
        }
    }

    public static boolean canBeSuperMethod(@NotNull JSFunction method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "canBeSuperMethod"));
        }
        return !method.isConstructor() && JSInheritanceUtil.canBeSuperMethod(method.getAttributeList());
    }

    public static boolean canBeSuperMethod(@Nullable JSAttributeList methodAttributeList) {
        return methodAttributeList == null || !methodAttributeList.hasModifier(JSAttributeList.ModifierType.STATIC) && !methodAttributeList.hasModifier(JSAttributeList.ModifierType.FINAL) && methodAttributeList.getAccessType() != JSAttributeList.AccessType.PRIVATE;
    }

    public static boolean canHaveSuperMethod(@NotNull JSFunction method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "canHaveSuperMethod"));
        }
        return !method.isConstructor() && JSInheritanceUtil.canHaveSuperMethod(method.getAttributeList());
    }

    public static boolean canHaveSuperMethod(@Nullable JSAttributeList methodAttributeList) {
        if (methodAttributeList != null) {
            return !methodAttributeList.hasModifier(JSAttributeList.ModifierType.STATIC);
        }
        return false;
    }

    @Nullable
    public static JSClass findNearestBaseClass(JSClass aClass, boolean includeNonProject) {
        JSClass[] supers = aClass.getSupers();
        if (supers.length > 0) {
            JSClass superClass = supers[0];
            if (JSResolveUtil.isObjectClass(superClass) && supers.length > 1) {
                superClass = supers[1];
            }
            if (includeNonProject || superClass.getManager().isInProject((PsiElement)superClass)) {
                return superClass;
            }
        }
        return null;
    }

    public static boolean isMemberOfSubclass(JSClass superClass, JSElement classMember, boolean allowSuperClass) {
        JSClass memberClass = JSUtils.getMemberContainingClass((PsiElement)classMember);
        if (memberClass == null) {
            return false;
        }
        if (superClass.isEquivalentTo((PsiElement)memberClass)) {
            return allowSuperClass;
        }
        return JSInheritanceUtil.isParentClass(memberClass, superClass);
    }

    public static Collection<JSClass> findDirectSubClasses(final JSClass jsClass, final boolean skipSubInterfaces) {
        final ArrayList<JSClass> result = new ArrayList<JSClass>();
        if (!jsClass.isInterface() || !skipSubInterfaces) {
            JSClassSearch.searchClassInheritors(jsClass, false).forEach((Processor)new Processor<JSClass>(){

                public boolean process(JSClass jsClass) {
                    if (!JSPsiImplUtils.containsEquivalent(result, (PsiElement)jsClass)) {
                        result.add(jsClass);
                    }
                    return true;
                }
            });
        }
        if (jsClass.isInterface()) {
            JSClassSearch.searchInterfaceImplementations(jsClass, false).forEach((Processor)new Processor<JSClass>(){

                public boolean process(JSClass candidate) {
                    if ((skipSubInterfaces || JSPsiImplUtils.containsEquivalent((PsiElement[])candidate.getSupers(), (PsiElement)jsClass)) && !JSPsiImplUtils.containsEquivalent(result, (PsiElement)candidate)) {
                        result.add(candidate);
                    }
                    return true;
                }
            });
        }
        return result;
    }

    public static boolean isParentClass(@NotNull JSClass clazz, @NotNull JSClass parentClass, boolean strict) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "isParentClass"));
        }
        if (parentClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentClass", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "isParentClass"));
        }
        return JSInheritanceUtil.isParentClass(clazz, parentClass, strict, JSResolveUtil.getResolveScope((PsiElement)clazz));
    }

    public static boolean isParentClass(@NotNull JSClass clazz, @NotNull JSClass parentClass, boolean strict, @Nullable PsiElement context) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "isParentClass"));
        }
        if (parentClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentClass", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "isParentClass"));
        }
        return JSInheritanceUtil.isParentClass(clazz, parentClass, strict, JSResolveUtil.getResolveScope((PsiElement)(context != null ? context : clazz)));
    }

    public static boolean isParentClass(final @NotNull JSClass clazz, final @NotNull JSClass parentClass, boolean strict, @NotNull GlobalSearchScope resolveScope) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "isParentClass"));
        }
        if (parentClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentClass", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "isParentClass"));
        }
        if (resolveScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveScope", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "isParentClass"));
        }
        if (!strict && clazz.isEquivalentTo((PsiElement)parentClass)) {
            return true;
        }
        return JSInheritanceUtil.withEnforcedScope(new Computable<Boolean>(){

            public Boolean compute() {
                return JSInheritanceUtil.checkClassHasParentOfAnotherOne(clazz, parentClass, (Set)new THashSet());
            }
        }, resolveScope);
    }

    public static boolean isParentClass(@NotNull JSClass clazz, @NotNull JSClass parentClass) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "isParentClass"));
        }
        if (parentClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentClass", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "isParentClass"));
        }
        return JSInheritanceUtil.isParentClass(clazz, parentClass, true);
    }

    @Nullable
    public static JSFunction findMethodInClass(JSFunction pattern, JSClass aClass, boolean lookInSupers) {
        if (pattern == null) {
            return null;
        }
        JSFunction method = aClass.findFunctionByNameAndKind(pattern.getName(), pattern.getKind());
        if (method != null) {
            return method;
        }
        if (lookInSupers && JSInheritanceUtil.canHaveSuperMethod(pattern)) {
            final Ref result = new Ref();
            JSResolveUtil.iterateType((JSPsiElementBase)pattern, (PsiElement)aClass, aClass.getQualifiedName(), new JSResolveUtil.OverrideHandler(){

                @Override
                public boolean process(@NotNull List<JSPsiElementBase> elements, PsiElement scope, String className) {
                    if (elements == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil$10", "process"));
                    }
                    result.set((Object)((JSFunction)elements.iterator().next()));
                    return false;
                }
            });
            return (JSFunction)result.get();
        }
        return null;
    }

    public static boolean participatesInHierarchy(JSFunction fun) {
        return !JSInheritanceUtil.processHierarchy(fun, new Processor<JSFunction>(){

            public boolean process(JSFunction jsFunction) {
                return false;
            }
        });
    }

    public static boolean processHierarchy(@NotNull JSFunction fun, Processor<JSFunction> processor) {
        if (fun == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fun", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "processHierarchy"));
        }
        if (JSUtils.getMemberContainingClass((PsiElement)fun) == null) {
            return true;
        }
        if (!ContainerUtil.process(JSInheritanceUtil.findImplementedMethods(fun), processor)) {
            return false;
        }
        if (!JSInheritanceUtil.iterateOverriddenMethodsUp(fun, processor)) {
            return false;
        }
        return JSInheritanceUtil.iterateMethodsDown(fun, processor);
    }

    public static boolean iterateMethodsDown(@NotNull JSFunction fun, Processor<JSFunction> processor) {
        if (fun == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fun", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "iterateMethodsDown"));
        }
        return JSInheritanceUtil.iterateMethodsDown(fun, processor, false);
    }

    public static boolean iterateMethodsDown(@NotNull JSFunction fun, final Processor<JSFunction> processor, boolean checkOverrideModifier) {
        if (fun == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fun", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "iterateMethodsDown"));
        }
        Processor<JSFunction> p = checkOverrideModifier ? new Processor<JSFunction>(){

            public boolean process(JSFunction jsFunction) {
                JSAttributeList attributeList = jsFunction.getAttributeList();
                if (attributeList == null || !attributeList.hasModifier(JSAttributeList.ModifierType.OVERRIDE)) {
                    return true;
                }
                return processor.process((Object)jsFunction);
            }
        } : processor;
        if (!JSFunctionsSearch.searchOverridingFunctions(fun, true).forEach((Processor)p)) {
            return false;
        }
        return JSFunctionsSearch.searchImplementingFunctions(fun, true).forEach((Processor)processor);
    }

    public static boolean hasSuperMethods(JSFunction method) {
        return !JSInheritanceUtil.iterateOverriddenMethodsUp(method, new Processor<JSFunction>(){

            public boolean process(JSFunction jsFunction) {
                return false;
            }
        });
    }

    public static Collection<JSFunction> collectFunctionsToOverride(final JSClass clazz) {
        if (clazz.isInterface()) {
            return Collections.emptyList();
        }
        FunctionCollector _functionsToOverride = null;
        Function<JSFunction, Boolean> functionFilter = new Function<JSFunction, Boolean>(){

            public Boolean fun(JSFunction function) {
                JSAttributeList attributeList = function.getAttributeList();
                if (attributeList != null && (attributeList.hasModifier(JSAttributeList.ModifierType.STATIC) || attributeList.hasModifier(JSAttributeList.ModifierType.FINAL) || attributeList.getAccessType() == JSAttributeList.AccessType.PRIVATE)) {
                    return Boolean.FALSE;
                }
                return JSResolveUtil.isAccessibleFromCurrentPackage((PsiElement)function, (PsiElement)clazz);
            }
        };
        for (JSClass superClazz : clazz.getSuperClasses()) {
            _functionsToOverride = FunctionCollector.collectAllVisibleClassFunctions(superClazz, _functionsToOverride, functionFilter);
        }
        final FunctionCollector functionsToOverride = _functionsToOverride;
        ResolveProcessor collectOwnFunctions = new ResolveProcessor(null, (PsiElement)clazz){
            {
                super(name, _place);
                this.setToProcessMembers(true);
                this.setToProcessHierarchy(false);
                this.setLocalResolve(true);
            }

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil$15", "execute"));
                }
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil$15", "execute"));
                }
                if (element instanceof JSFunction) {
                    JSFunction function = (JSFunction)element;
                    if (function.isConstructor() || functionsToOverride == null) {
                        return true;
                    }
                    functionsToOverride.removeFunctionByNameAndKind(function.getName(), function.getKind());
                }
                return true;
            }
        };
        clazz.processDeclarations((PsiScopeProcessor)collectOwnFunctions, ResolveState.initial(), (PsiElement)clazz, (PsiElement)clazz);
        return functionsToOverride != null ? functionsToOverride.getFunctions() : Collections.emptyList();
    }

    public static Collection<JSCallExpression> findSuperConstructorCalls(JSFunction constructor) {
        JSClass clazz = JSUtils.getMemberContainingClass((PsiElement)constructor);
        return clazz != null ? JSInheritanceUtil.findSuperConstructorCalls(clazz) : Collections.emptyList();
    }

    public static Collection<JSCallExpression> findSuperConstructorCalls(@NotNull JSClass clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "findSuperConstructorCalls"));
        }
        final ArrayList<JSCallExpression> result = new ArrayList<JSCallExpression>();
        Processor<JSCallExpression> p = new Processor<JSCallExpression>(){

            public boolean process(JSCallExpression jsCallExpression) {
                result.add(jsCallExpression);
                return true;
            }
        };
        Collection<JSClass> subClasses = JSInheritanceUtil.findDirectSubClasses(clazz, true);
        for (JSClass subClass : subClasses) {
            JSInheritanceUtil.processSuperCallsIn(subClass, p);
        }
        return result;
    }

    public static boolean processSuperCallsIn(JSClass subClass, Processor<JSCallExpression> processor) {
        JSFunction subClassConstructor = subClass.getConstructor();
        if (subClassConstructor != null) {
            SuperCallSearcher superCallSearcher = new SuperCallSearcher();
            subClassConstructor.accept((PsiElementVisitor)superCallSearcher);
            if (superCallSearcher.myResult != null && !processor.process((Object)superCallSearcher.myResult)) {
                return false;
            }
        }
        return true;
    }

    @Nullable
    public static JSQualifiedNamedElement findMember(String name, JSClass jsClass, SearchedMemberType searchedMemberType, @Nullable JSFunction.FunctionKind limitByFunctionKind, boolean lookInSupers) {
        return JSInheritanceUtil.findMember(name, jsClass, searchedMemberType, limitByFunctionKind, lookInSupers, (Set<JSClass>)(lookInSupers ? new THashSet() : Collections.emptySet()));
    }

    @Nullable
    private static JSQualifiedNamedElement findMember(String name, JSClass jsClass, SearchedMemberType memberType, @Nullable JSFunction.FunctionKind limitByFunctionKind, boolean lookInSupers, Set<JSClass> visited) {
        JSVariable field;
        if (visited.contains(jsClass)) {
            return null;
        }
        if ((memberType == SearchedMemberType.Fields || memberType == SearchedMemberType.FieldsAndMethods) && (field = jsClass.findFieldByName(name)) != null) {
            return field;
        }
        if (memberType == SearchedMemberType.Methods || memberType == SearchedMemberType.FieldsAndMethods) {
            JSFunction function;
            JSFunction jSFunction = function = limitByFunctionKind == null ? jsClass.findFunctionByName(name) : jsClass.findFunctionByNameAndKind(name, limitByFunctionKind);
            if (function != null) {
                return function;
            }
        }
        if (lookInSupers) {
            visited.add(jsClass);
            for (JSClass superClass : jsClass.getSuperClasses()) {
                JSQualifiedNamedElement inSuper = JSInheritanceUtil.findMember(name, superClass, memberType, limitByFunctionKind, lookInSupers, visited);
                if (inSuper == null) continue;
                return inSuper;
            }
        }
        return null;
    }

    private static boolean checkClassHasParentOfAnotherOne(JSClass aClass, JSClass parent, Set<JSClass> visited) {
        if (visited.contains(aClass)) {
            return false;
        }
        for (JSClass superClazz : aClass.getSupers()) {
            if (superClazz.isEquivalentTo((PsiElement)parent)) {
                return true;
            }
            visited.add(aClass);
            if (!JSInheritanceUtil.checkClassHasParentOfAnotherOne(superClazz, parent, visited)) continue;
            return true;
        }
        return false;
    }

    public static <T> T withEnforcedScope(Computable<T> r, GlobalSearchScope scope) {
        assert (JSInheritanceUtil.getEnforcedScope() == null);
        ourEnforcedScope.set(scope);
        try {
            Object object = r.compute();
            return (T)object;
        }
        finally {
            ourEnforcedScope.set(null);
        }
    }

    public static GlobalSearchScope getEnforcedScope() {
        return ourEnforcedScope.get();
    }

    @Nullable
    public static JSParameter findMatchedSuperParameter(JSParameter parameter, JSFunction function) {
        int _parameterIndex = Integer.MAX_VALUE;
        JSParameter[] parameters = function.getParameterVariables();
        for (int i = 0; i < parameters.length; ++i) {
            if (parameters[i] != parameter) continue;
            _parameterIndex = i;
            break;
        }
        final int parameterIndex = _parameterIndex;
        final Ref matchedSuperParameter = Ref.create(null);
        JSInheritanceUtil.processNearestOverriddenMethods((JSFunctionItem)function, new Processor<JSFunction>(){

            public boolean process(JSFunction overridden) {
                if (overridden == null) {
                    return true;
                }
                JSParameter[] overriddenParameters = overridden.getParameterVariables();
                if (parameterIndex < overriddenParameters.length) {
                    matchedSuperParameter.set((Object)overriddenParameters[parameterIndex]);
                    return false;
                }
                return true;
            }
        });
        return (JSParameter)matchedSuperParameter.get();
    }

    public static boolean iterateAllMethodsInHierarchy(JSFunction function, Processor<JSFunction> processor) {
        CommonProcessors.UniqueProcessor uniqueProcessor = new CommonProcessors.UniqueProcessor(processor);
        Collection<JSFunction> topMethods = JSInheritanceUtil.findTopMethods(function);
        for (JSFunction topMethod : topMethods) {
            if (uniqueProcessor.process((Object)topMethod) && JSInheritanceUtil.iterateMethodsDown(topMethod, (Processor<JSFunction>)uniqueProcessor)) continue;
            return false;
        }
        return true;
    }

    public static abstract class CacheByEnforcedResolveScope<T> {
        private static final GlobalSearchScope NO_ENFORCED_SCOPE_MARKER = new NoEnforcedScopeMarker();
        private final Map<GlobalSearchScope, T> myCache = ContainerUtil.newConcurrentMap();

        public T compute() {
            GlobalSearchScope enforcedScope = JSInheritanceUtil.getEnforcedScope();
            GlobalSearchScope key = enforcedScope != null ? enforcedScope : NO_ENFORCED_SCOPE_MARKER;
            T value = this.myCache.get(key);
            if (value == null) {
                value = this.computeForScope(enforcedScope);
                this.myCache.put(key, value);
            }
            return value;
        }

        protected abstract T computeForScope(@Nullable GlobalSearchScope var1);

        private static class NoEnforcedScopeMarker
        extends GlobalSearchScope {
            private NoEnforcedScopeMarker() {
            }

            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil$CacheByEnforcedResolveScope$NoEnforcedScopeMarker", "contains"));
                }
                return false;
            }

            public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
                if (file1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil$CacheByEnforcedResolveScope$NoEnforcedScopeMarker", "compare"));
                }
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil$CacheByEnforcedResolveScope$NoEnforcedScopeMarker", "compare"));
                }
                return 0;
            }

            public boolean isSearchInModuleContent(@NotNull Module aModule) {
                if (aModule == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil$CacheByEnforcedResolveScope$NoEnforcedScopeMarker", "isSearchInModuleContent"));
                }
                return false;
            }

            public boolean isSearchInLibraries() {
                return false;
            }
        }
    }

    private static class SuperCallSearcher
    extends JSRecursiveElementVisitor {
        private JSCallExpression myResult;

        private SuperCallSearcher() {
        }

        public void visitJSCallExpression(JSCallExpression node) {
            if (node.getMethodExpression() instanceof JSSuperExpression) {
                this.myResult = node;
            }
        }
    }

    public static enum SearchedMemberType {
        Fields,
        Methods,
        FieldsAndMethods;

    }
}

