/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.psi.ecmal4.JSImportStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class JSResolveResult
implements ResolveResult {
    @NonNls
    public static final String UNDEFINED_RESOLVE_PROBLEM = "*Undefined resolve problem!*";
    @NonNls
    public static final String QUALIFIED_NAME_IS_NOT_IMPORTED = "javascript.qualified.name.is.not.imported.message";
    @NonNls
    public static final String ELEMENT_IS_NOT_ACCESSIBLE = "javascript.element.is.not.accessible.message";
    @NonNls
    public static final String PROTECTED_MEMBER_IS_NOT_ACCESSIBLE = "javascript.protected.member.is.not.accessible.message";
    @NonNls
    public static final String MEMBER_FROM_UNOPENED_NAMESPACE = "javascript.member.from.unopened.namespace.message";
    @NonNls
    public static final String PROPERTY_IS_READ_ONLY = "javascript.property.is.read.only.message";
    @NonNls
    public static final String PROPERTY_IS_WRITE_ONLY = "javascript.property.is.write.only.message";
    @NonNls
    public static final String PRIVATE_MEMBER_IS_NOT_ACCESSIBLE = "javascript.private.member.is.not.accessible.message";
    @NonNls
    public static final String JS_PRIVATE_MEMBER_IS_NOT_ACCESSIBLE = "javascript.jsdoc.private.member.is.not.accessible.message";
    @NonNls
    public static final String JS_PROTECTED_MEMBER_IS_NOT_ACCESSIBLE = "javascript.jsdoc.protected.member.is.not.accessible.message";
    @NonNls
    public static final String JS_NEED_TO_BE_EXPORTED = "javascript.element.need.to.be.exported";
    @NonNls
    public static final String TS_NEED_TO_BE_INCLUDED_TO_CONFIG = "javascript.element.need.to.be.included.to.config";
    @NonNls
    public static final String EXPORT_ONLY_VALUE = "javascript.element.is.export.only";
    public static final String[] INSUFFICIENT_VISIBILITY_PROBLEM_KEYS = new String[]{"javascript.element.is.not.accessible.message", "javascript.private.member.is.not.accessible.message", "javascript.protected.member.is.not.accessible.message", "javascript.jsdoc.private.member.is.not.accessible.message", "javascript.jsdoc.protected.member.is.not.accessible.message"};
    @NonNls
    public static final String STATIC_MEMBER_INACCESSIBLE = "javascript.static.member.is.not.accessible.message";
    @NonNls
    public static final String INSTANCE_MEMBER_INACCESSIBLE = "javascript.instance.member.is.not.accessible.message";
    @NonNls
    public static final String ARGUMENT_TYPES_MISMATCH = "javascript.argument.types.mismatch";
    private final PsiElement myFunction;
    private final JSImportStatement myImportUsed;
    private String myResolveProblemKey;
    private final boolean myES6ImportWasUsed;

    public JSResolveResult(PsiElement function) {
        this(function, true);
    }

    @Deprecated
    public JSResolveResult(PsiElement function, boolean validResult) {
        this(function, null, validResult);
    }

    @Deprecated
    public JSResolveResult(PsiElement function, JSImportStatement importUsed, boolean validResult) {
        this(function, importUsed, validResult ? null : UNDEFINED_RESOLVE_PROBLEM);
    }

    public JSResolveResult(PsiElement function, JSImportStatement importUsed, @PropertyKey(resourceBundle="com.intellij.lang.javascript.JavaScriptBundle") String resolveProblemKey) {
        this(function, importUsed, resolveProblemKey, false);
    }

    public JSResolveResult(PsiElement function, JSImportStatement importUsed, @PropertyKey(resourceBundle="com.intellij.lang.javascript.JavaScriptBundle") String resolveProblemKey, boolean es6ImportWasUsed) {
        this.myFunction = function;
        this.myResolveProblemKey = resolveProblemKey;
        this.myImportUsed = importUsed;
        this.myES6ImportWasUsed = es6ImportWasUsed;
    }

    public PsiElement getElement() {
        return this.myFunction;
    }

    public boolean isValidResult() {
        return this.myResolveProblemKey == null;
    }

    public void setValid(boolean b) {
        this.myResolveProblemKey = b ? null : UNDEFINED_RESOLVE_PROBLEM;
    }

    public JSImportStatement getImportUsed() {
        return this.myImportUsed;
    }

    @Nullable
    public String getResolveProblemKey() {
        return this.myResolveProblemKey != UNDEFINED_RESOLVE_PROBLEM ? this.myResolveProblemKey : null;
    }

    public boolean wasES6ImportUsed() {
        return this.myES6ImportWasUsed;
    }

    @NotNull
    public static Collection<PsiElement> toElements(@NotNull ResolveResult[] results) {
        if (results == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "com/intellij/lang/javascript/psi/resolve/JSResolveResult", "toElements"));
        }
        if (results.length == 0) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSResolveResult", "toElements"));
            }
            return list;
        }
        ArrayList psiElements = ContainerUtil.newArrayList();
        for (ResolveResult result : results) {
            PsiElement element;
            if (!result.isValidResult() || (element = result.getElement()) == null) continue;
            psiElements.add(element);
        }
        ArrayList arrayList = psiElements;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSResolveResult", "toElements"));
        }
        return arrayList;
    }
}

