/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.index.flags.BooleanStructureElement;
import com.intellij.lang.javascript.index.flags.FlagsStructure;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.impl.JSCallExpressionImpl;
import com.intellij.lang.javascript.psi.stubs.JSCallExpressionStub;
import com.intellij.lang.javascript.psi.stubs.impl.JSPossiblyStoredStubImpl;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class JSCallExpressionStubImpl
extends JSPossiblyStoredStubImpl<JSCallExpression>
implements JSCallExpressionStub {
    private static final BooleanStructureElement IS_REQUIRE_CALL_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement IS_DEFINE_CALL_FLAG = new BooleanStructureElement();
    private static final FlagsStructure FLAGS_STRUCTURE = new FlagsStructure(JSPossiblyStoredStubImpl.FLAGS_STRUCTURE, IS_REQUIRE_CALL_FLAG, IS_DEFINE_CALL_FLAG);

    public JSCallExpressionStubImpl(JSCallExpression element, StubElement parent) {
        super(element, parent, JSStubElementTypes.CALL_EXPRESSION);
        this.writeFlag(IS_REQUIRE_CALL_FLAG, element.isRequireCall());
        this.writeFlag(IS_DEFINE_CALL_FLAG, element.isDefineCall());
    }

    public JSCallExpressionStubImpl(StubInputStream dataStream, StubElement parentStub) throws IOException {
        super(dataStream, parentStub, JSStubElementTypes.CALL_EXPRESSION);
    }

    public JSCallExpression createPsi() {
        return new JSCallExpressionImpl(this);
    }

    @Override
    @NotNull
    protected FlagsStructure getFlagsStructure() {
        FlagsStructure flagsStructure = FLAGS_STRUCTURE;
        if (flagsStructure == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSCallExpressionStubImpl", "getFlagsStructure"));
        }
        return flagsStructure;
    }

    public boolean isRequireCall() {
        return this.readFlag(IS_REQUIRE_CALL_FLAG);
    }

    public boolean isDefineCall() {
        return this.readFlag(IS_DEFINE_CALL_FLAG);
    }
}

