/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSFileCachedDataEvaluator;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.stubs.impl.JSFileCachedData;
import com.intellij.lang.javascript.psi.stubs.impl.JSFileStubImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.stubs.DefaultStubBuilder;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.Stack;
import org.jetbrains.annotations.NotNull;

public class JSFileStubBuilder
extends DefaultStubBuilder {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.javascript.psi.stubs.impl.JSFileStubBuilder");

    public StubElement buildStubTree(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/psi/stubs/impl/JSFileStubBuilder", "buildStubTree"));
        }
        StubElement parentStub = this.createStubForFile(file);
        if (!(parentStub instanceof JSFileStubImpl) || !(file instanceof JSFile) || ((JSFileStubImpl)parentStub).getCachedData() != null) {
            return this.buildStubTreeFor((ASTNode)file.getNode(), parentStub);
        }
        JSFileCachedData cachedData = new JSFileCachedData();
        for (FrameworkIndexingHandler handler : (FrameworkIndexingHandler[])FrameworkIndexingHandler.EP_NAME.getExtensions()) {
            handler.processFile((JSFile)file, cachedData);
        }
        JSFileCachedDataEvaluator evaluator = JSDialectSpecificHandlersFactory.forLanguage(DialectDetector.languageOfElement((PsiElement)file)).newFileCachedDataEvaluator(cachedData);
        Stack parentStubs = new Stack();
        Stack parentNodes = new Stack();
        parentNodes.push((Object)file.getNode());
        parentStubs.push((Object)parentStub);
        while (!parentStubs.isEmpty()) {
            ASTNode lastChildNode;
            IStubElementType type;
            StubElement stub = (StubElement)parentStubs.pop();
            ASTNode node = (ASTNode)parentNodes.pop();
            IElementType nodeType = node.getElementType();
            PsiElement element = node.getPsi();
            evaluator.startElement(element);
            if (nodeType instanceof IStubElementType && (type = (IStubElementType)nodeType).shouldCreateStub(node)) {
                StubElement s;
                if (!(element instanceof StubBasedPsiElement)) {
                    LOG.error("Non-StubBasedPsiElement requests stub creation. Stub type: " + type + ", PSI: " + element);
                }
                LOG.assertTrue((stub = (s = type.createStub(element, stub))) != null, (Object)element);
            }
            for (ASTNode childNode = lastChildNode = node.getLastChildNode(); childNode != null; childNode = childNode.getTreePrev()) {
                parentNodes.push((Object)childNode);
                parentStubs.push((Object)stub);
            }
            if (lastChildNode != null) continue;
            evaluator.finishElement(element);
            ASTNode nextNode = parentNodes.isEmpty() ? null : (ASTNode)parentNodes.peek();
            if (nextNode == null) continue;
            ASTNode nextNodeParent = nextNode.getTreeParent();
            for (ASTNode currentParent = node.getTreeParent(); currentParent != null && currentParent != nextNodeParent; currentParent = currentParent.getTreeParent()) {
                evaluator.finishElement(currentParent.getPsi());
            }
        }
        ((JSFileStubImpl)parentStub).setCachedData(cachedData);
        return parentStub;
    }

    @NotNull
    protected StubElement createStubForFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/psi/stubs/impl/JSFileStubBuilder", "createStubForFile"));
        }
        if (file instanceof JSFile) {
            JSFileStubImpl jSFileStubImpl = new JSFileStubImpl((JSFile)file);
            if (jSFileStubImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSFileStubBuilder", "createStubForFile"));
            }
            return jSFileStubImpl;
        }
        StubElement stubElement = super.createStubForFile(file);
        if (stubElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSFileStubBuilder", "createStubForFile"));
        }
        return stubElement;
    }
}

