/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.javascript.index.flags.BooleanStructureElement;
import com.intellij.lang.javascript.index.flags.ByteFlagsSerializer;
import com.intellij.lang.javascript.index.flags.FlagsStructure;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.impl.JSFunctionImpl;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSParameterTypeDecoratorImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.SmartList;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.IOUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSImplicitFunctionImpl
extends JSImplicitElementImpl
implements JSFunctionItem {
    @NotNull
    private final JSParameterItem[] myParameters;
    @Nullable
    private String myCachedFunctionTypeString;

    public JSImplicitFunctionImpl(@NotNull Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitFunctionImpl", "<init>"));
        }
        super(builder.setType(JSImplicitElement.Type.Function));
        List<Pair<String, JSParameterTypeDecorator>> parameters = builder.myParameters;
        JSParameterItem[] jSParameterItemArray = this.myParameters = parameters != null ? new JSParameterItem[parameters.size()] : JSParameterItem.EMPTY_ARRAY;
        if (parameters != null) {
            for (int i = 0; i < parameters.size(); ++i) {
                Pair<String, JSParameterTypeDecorator> pair = parameters.get(i);
                this.myParameters[i] = new JSImplicitParameterImpl((String)pair.first, (JSParameterTypeDecorator)pair.second, builder.myProvider);
            }
        }
    }

    @Nullable
    public JSType getReturnType() {
        return this.myTypeString != null ? JSTypeUtils.createType(this.myTypeString, JSTypeSource.EXPLICITLY_DECLARED) : null;
    }

    @NotNull
    public JSParameterItem[] getParameters() {
        if (this.myParameters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitFunctionImpl", "getParameters"));
        }
        return this.myParameters;
    }

    public boolean isGetProperty() {
        return ((EnumSet)this.readFlag(PROPERTIES_FLAG)).contains(JSImplicitElement.Property.GetFunction);
    }

    public boolean isSetProperty() {
        return ((EnumSet)this.readFlag(PROPERTIES_FLAG)).contains(JSImplicitElement.Property.SetFunction);
    }

    public boolean isReferencesArguments() {
        return false;
    }

    @Override
    @NotNull
    public String getTypeString() {
        if (this.myCachedFunctionTypeString == null) {
            SmartList parameters = new SmartList();
            for (JSParameterItem parameter : this.myParameters) {
                parameters.add(new JSParameterTypeDecoratorImpl(parameter.getType(), parameter.isOptional(), parameter.isRest(), true));
            }
            this.myCachedFunctionTypeString = new JSFunctionTypeImpl(JSTypeSource.EXPLICITLY_DECLARED, (List<JSParameterTypeDecorator>)parameters, this.getReturnType()).getTypeText(JSType.TypeTextFormat.SERIALIZED);
        }
        String string = this.myCachedFunctionTypeString;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitFunctionImpl", "getTypeString"));
        }
        return string;
    }

    @Override
    public void serialize(DataOutput dataStream) throws IOException {
        super.serialize(dataStream);
        DataInputOutputUtil.writeINT((DataOutput)dataStream, (int)this.myParameters.length);
        for (JSParameterItem parameter : this.myParameters) {
            ((JSImplicitParameterImpl)parameter).serialize(dataStream);
        }
    }

    static void deserializeParameters(DataInput dataStream, Builder builder) throws IOException {
        int b = DataInputOutputUtil.readINT((DataInput)dataStream);
        if (b > 0) {
            ArrayList<Pair<String, JSParameterTypeDecorator>> parameters = new ArrayList<Pair<String, JSParameterTypeDecorator>>();
            while (b-- > 0) {
                JSImplicitParameterImpl p = JSImplicitParameterImpl.deserialize(dataStream, builder.myProvider);
                parameters.add((Pair<String, JSParameterTypeDecorator>)Pair.create((Object)p.getName(), (Object)p.getTypeDecorator()));
            }
            builder.setParameters(parameters);
        }
    }

    @Override
    @Nullable
    public Icon getIcon(boolean open) {
        return JSFunctionImpl.getFunctionIcon(this, 0);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        JSImplicitFunctionImpl other = (JSImplicitFunctionImpl)((Object)obj);
        return this.structureEquals(other) && Arrays.equals(this.myParameters, other.myParameters);
    }

    @Override
    @NotNull
    protected Builder toBuilder() {
        Builder builder = new Builder(this.myName, this.myProvider);
        this.fillBuilder(builder);
        Builder builder2 = builder;
        if (builder2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitFunctionImpl", "toBuilder"));
        }
        return builder2;
    }

    @Override
    protected void fillBuilder(@NotNull JSImplicitElementImpl.Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitFunctionImpl", "fillBuilder"));
        }
        super.fillBuilder(builder);
        if (builder instanceof Builder) {
            ArrayList<Pair<String, JSParameterTypeDecorator>> parameters = new ArrayList<Pair<String, JSParameterTypeDecorator>>();
            for (JSParameterItem parameter : this.myParameters) {
                parameters.add((Pair<String, JSParameterTypeDecorator>)Pair.create((Object)parameter.getName(), (Object)parameter.getTypeDecorator()));
            }
            ((Builder)builder).setParameters(parameters);
        }
    }

    public boolean isOverride() {
        return false;
    }

    public static class Builder
    extends JSImplicitElementImpl.Builder {
        List<Pair<String, JSParameterTypeDecorator>> myParameters;

        public Builder(@NotNull String name, @Nullable PsiElement provider) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitFunctionImpl$Builder", "<init>"));
            }
            super(name, provider);
        }

        public Builder setReturnType(String returnType) {
            super.setTypeString(returnType);
            return this;
        }

        public Builder setParameters(List<Pair<String, JSParameterTypeDecorator>> parameters) {
            this.myParameters = parameters;
            return this;
        }

        @Override
        public JSImplicitElementImpl.Builder setTypeString(String typeString) {
            throw new UnsupportedOperationException("Use setReturnType instead.");
        }

        @Override
        public JSImplicitElementImpl toImplicitElement() {
            return new JSImplicitFunctionImpl(this);
        }
    }

    private static class JSImplicitParameterImpl
    implements JSParameterItem {
        @Nullable
        private final String myName;
        @Nullable
        private final String myTypeString;
        private final byte myFlags;
        @Nullable
        private final PsiElement myProvider;
        private static final BooleanStructureElement OPTIONAL_FLAG = new BooleanStructureElement();
        private static final BooleanStructureElement EXPLICITLY_DECLARED_FLAG = new BooleanStructureElement();
        private static final BooleanStructureElement REST_FLAG = new BooleanStructureElement();
        private static final BooleanStructureElement HAS_TYPE_FLAG = new BooleanStructureElement();
        private static final FlagsStructure FLAGS_STRUCTURE = new FlagsStructure(OPTIONAL_FLAG, EXPLICITLY_DECLARED_FLAG, REST_FLAG, HAS_TYPE_FLAG);
        private static final String NULL_SERIALIZED_NAME = "^null";

        public JSImplicitParameterImpl(@Nullable String name, @NotNull JSParameterTypeDecorator decorator, @Nullable PsiElement provider) {
            if (decorator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "decorator", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitFunctionImpl$JSImplicitParameterImpl", "<init>"));
            }
            this.myName = name;
            JSType type = decorator.getType();
            this.myTypeString = type != null ? type.getTypeText(JSType.TypeTextFormat.SERIALIZED) : null;
            byte flags = 0;
            flags = ByteFlagsSerializer.INSTANCE.writeValue(FLAGS_STRUCTURE, OPTIONAL_FLAG, decorator.isOptional(), flags);
            flags = ByteFlagsSerializer.INSTANCE.writeValue(FLAGS_STRUCTURE, EXPLICITLY_DECLARED_FLAG, decorator.isExplicitlyDeclared(), flags);
            flags = ByteFlagsSerializer.INSTANCE.writeValue(FLAGS_STRUCTURE, REST_FLAG, decorator.isRest(), flags);
            this.myFlags = flags = ByteFlagsSerializer.INSTANCE.writeValue(FLAGS_STRUCTURE, HAS_TYPE_FLAG, type != null, flags);
            this.myProvider = provider;
        }

        private JSImplicitParameterImpl(@Nullable String name, @Nullable String typeString, byte flags, @Nullable PsiElement provider) {
            this.myName = name;
            this.myTypeString = typeString;
            this.myFlags = flags;
            this.myProvider = provider;
        }

        @Nullable
        public JSType getType() {
            boolean isExplicitlyDeclared = ByteFlagsSerializer.INSTANCE.readValue(FLAGS_STRUCTURE, EXPLICITLY_DECLARED_FLAG, this.myFlags);
            return JSTypeUtils.createType(this.myTypeString, JSTypeSourceFactory.createTypeSource(this.myProvider, isExplicitlyDeclared));
        }

        @Nullable
        public JSType getTypeIncludingOverridden() {
            return this.getType();
        }

        public boolean isOptional() {
            return ByteFlagsSerializer.INSTANCE.readValue(FLAGS_STRUCTURE, OPTIONAL_FLAG, this.myFlags);
        }

        public boolean isRest() {
            return ByteFlagsSerializer.INSTANCE.readValue(FLAGS_STRUCTURE, REST_FLAG, this.myFlags);
        }

        @NotNull
        public JSParameterTypeDecorator getTypeDecorator() {
            boolean isExplicitlyDeclared = ByteFlagsSerializer.INSTANCE.readValue(FLAGS_STRUCTURE, EXPLICITLY_DECLARED_FLAG, this.myFlags);
            JSParameterTypeDecoratorImpl jSParameterTypeDecoratorImpl = new JSParameterTypeDecoratorImpl(this.getType(), this.isOptional(), this.isRest(), isExplicitlyDeclared);
            if (jSParameterTypeDecoratorImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitFunctionImpl$JSImplicitParameterImpl", "getTypeDecorator"));
            }
            return jSParameterTypeDecoratorImpl;
        }

        @Nullable
        public String getName() {
            return this.myName;
        }

        void serialize(@NotNull DataOutput dataStream) throws IOException {
            if (dataStream == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitFunctionImpl$JSImplicitParameterImpl", "serialize"));
            }
            IOUtil.writeUTF((DataOutput)dataStream, (String)(this.myName != null ? this.myName : NULL_SERIALIZED_NAME));
            dataStream.writeByte(this.myFlags);
            if (this.myTypeString != null) {
                IOUtil.writeUTF((DataOutput)dataStream, (String)this.myTypeString);
            }
        }

        @NotNull
        static JSImplicitParameterImpl deserialize(@NotNull DataInput dataStream, @Nullable PsiElement provider) throws IOException {
            if (dataStream == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitFunctionImpl$JSImplicitParameterImpl", "deserialize"));
            }
            String name = IOUtil.readUTF((DataInput)dataStream);
            if (NULL_SERIALIZED_NAME.equals(name)) {
                name = null;
            }
            byte flags = dataStream.readByte();
            boolean notNullType = ByteFlagsSerializer.INSTANCE.readValue(FLAGS_STRUCTURE, HAS_TYPE_FLAG, flags);
            String typeString = null;
            if (notNullType) {
                typeString = IOUtil.readUTF((DataInput)dataStream);
            }
            JSImplicitParameterImpl jSImplicitParameterImpl = new JSImplicitParameterImpl(name, typeString, flags, provider);
            if (jSImplicitParameterImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitFunctionImpl$JSImplicitParameterImpl", "deserialize"));
            }
            return jSImplicitParameterImpl;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            JSImplicitParameterImpl other = (JSImplicitParameterImpl)obj;
            return StringUtil.equals((CharSequence)this.myName, (CharSequence)other.myName) && this.myFlags == ((JSImplicitParameterImpl)obj).myFlags;
        }

        public int hashCode() {
            return this.myName != null ? this.myName.hashCode() : 0;
        }
    }
}

