/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.javascript.index.JSNamespaceEvaluationResult;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiQualifiedReference;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSStubIndexingUtils {
    public static void addImplicitNamespaces(@NotNull JSQualifiedName elementQualifiedName, @NotNull Collection<JSImplicitElement> outElements, @Nullable PsiElement element) {
        if (elementQualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementQualifiedName", "com/intellij/lang/javascript/psi/stubs/impl/JSStubIndexingUtils", "addImplicitNamespaces"));
        }
        if (outElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outElements", "com/intellij/lang/javascript/psi/stubs/impl/JSStubIndexingUtils", "addImplicitNamespaces"));
        }
        for (JSQualifiedName parent = elementQualifiedName.getParent(); parent != null; parent = parent.getParent()) {
            JSImplicitElementImpl.Builder builder = new JSImplicitElementImpl.Builder(parent.getName(), element).setNamespace(parent.getParent()).setProperties(JSImplicitElement.Property.MinorImportance).setType(JSImplicitElement.Type.Namespace);
            outElements.add(new JSImplicitElementImpl(builder));
        }
    }

    public static void processExtendCall(@NotNull JSReferenceExpression _typeExpression, @NotNull JSReferenceExpression _baseTypeExpression, @NotNull JSContext extensionContext, @NotNull JSElementIndexingData outIndexingData) {
        JSExpression typeQualifier;
        if (_typeExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_typeExpression", "com/intellij/lang/javascript/psi/stubs/impl/JSStubIndexingUtils", "processExtendCall"));
        }
        if (_baseTypeExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_baseTypeExpression", "com/intellij/lang/javascript/psi/stubs/impl/JSStubIndexingUtils", "processExtendCall"));
        }
        if (extensionContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensionContext", "com/intellij/lang/javascript/psi/stubs/impl/JSStubIndexingUtils", "processExtendCall"));
        }
        if (outIndexingData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outIndexingData", "com/intellij/lang/javascript/psi/stubs/impl/JSStubIndexingUtils", "processExtendCall"));
        }
        JSNamespaceEvaluationResult ns = JSSymbolUtil.evaluateNamespaceLocally(_typeExpression);
        if (ns == null) {
            ns = JSSymbolUtil.createNamespaceFromReferenceExpression(_typeExpression, extensionContext, true);
        }
        JSContext typeExpressionContext = extensionContext;
        JSContext baseTypeExpressionContext = extensionContext;
        JSReferenceExpression typeExpression = _typeExpression;
        JSReferenceExpression baseTypeExpression = _baseTypeExpression;
        if ("prototype".equals(typeExpression.getReferenceName())) {
            typeQualifier = typeExpression.getQualifier();
            typeExpression = typeQualifier instanceof JSReferenceExpression ? (JSReferenceExpression)typeQualifier : null;
            typeExpressionContext = JSContext.INSTANCE;
        }
        if ("prototype".equals(baseTypeExpression.getReferenceName())) {
            typeQualifier = baseTypeExpression.getQualifier();
            baseTypeExpression = typeQualifier instanceof JSReferenceExpression ? (JSReferenceExpression)typeQualifier : null;
            baseTypeExpressionContext = JSContext.INSTANCE;
        }
        if (typeExpression != null && baseTypeExpression != null) {
            String typeString;
            JSQualifiedName qualifiedName;
            String baseTypeString = null;
            JSNamespaceEvaluationResult baseTypeNs = JSSymbolUtil.evaluateNamespaceLocally(baseTypeExpression);
            if (baseTypeNs != null) {
                if (baseTypeNs.getQualifiedName() != null) {
                    baseTypeString = baseTypeNs.getQualifiedName().getQualifiedName();
                }
                if (baseTypeNs.getJSContext() != JSContext.UNKNOWN) {
                    baseTypeExpressionContext = JSTypeUtils.combineJSContexts(baseTypeExpressionContext, baseTypeNs.getJSContext());
                }
            }
            if (baseTypeString == null && (qualifiedName = JSSymbolUtil.getReferencedNamespace((JSExpression)baseTypeExpression)) != null) {
                baseTypeString = qualifiedName.getQualifiedName();
            }
            String string = typeString = ns != null && ns.getQualifiedName() != null ? ns.getQualifiedName().getQualifiedName() : JSQualifiedNameImpl.toString(JSSymbolUtil.getAccurateReferenceName((PsiQualifiedReference)typeExpression));
            if (typeString != null && baseTypeString != null) {
                if (typeExpressionContext != JSContext.STATIC && baseTypeExpressionContext != JSContext.STATIC) {
                    outIndexingData.addBaseType(typeString, baseTypeString);
                }
                if (typeExpressionContext != JSContext.INSTANCE && baseTypeExpressionContext != JSContext.INSTANCE) {
                    outIndexingData.addBaseType(JSNamedType.appendStaticSuffix(typeString), JSNamedType.appendStaticSuffix(baseTypeString));
                }
                if (typeExpressionContext != JSContext.INSTANCE && baseTypeExpressionContext != JSContext.STATIC) {
                    outIndexingData.addBaseType(JSNamedType.appendStaticSuffix(typeString), baseTypeString);
                }
                if (typeExpressionContext != JSContext.STATIC && baseTypeExpressionContext != JSContext.INSTANCE) {
                    outIndexingData.addBaseType(typeString, JSNamedType.appendStaticSuffix(baseTypeString));
                }
            }
        }
    }

    @Nullable
    public static String evaluateTypeString(@NotNull JSReferenceExpression typeExpression) {
        if (typeExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeExpression", "com/intellij/lang/javascript/psi/stubs/impl/JSStubIndexingUtils", "evaluateTypeString"));
        }
        JSNamespaceEvaluationResult ns = JSSymbolUtil.evaluateNamespaceLocally(typeExpression);
        if (ns != null && ns.getQualifiedName() != null) {
            return ns.getQualifiedName().getQualifiedName();
        }
        JSQualifiedName qualifiedName = JSSymbolUtil.getReferencedNamespace((JSExpression)typeExpression);
        return qualifiedName != null ? qualifiedName.getQualifiedName() : null;
    }
}

