/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSSimpleTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSAnyType
extends JSSimpleTypeBaseImpl {
    private final JSTypeSource.SourceLanguage myLanguage;
    private static final JSAnyType ourTSDeclared = new JSAnyType(JSTypeSource.SourceLanguage.TS, true);
    private static final JSAnyType ourTSEvaluated = new JSAnyType(JSTypeSource.SourceLanguage.TS, false);
    private static final JSAnyType ourJSDeclared = new JSAnyType(JSTypeSource.SourceLanguage.JS, true);
    private static final JSAnyType ourJSEvaluated = new JSAnyType(JSTypeSource.SourceLanguage.JS, false);
    private static final JSAnyType ourASDeclared = new JSAnyType(JSTypeSource.SourceLanguage.AS, true);
    private static final JSAnyType ourASEvaluated = new JSAnyType(JSTypeSource.SourceLanguage.AS, false);

    private JSAnyType(JSTypeSource.SourceLanguage language, boolean explicitlyDeclared) {
        super(new JSTypeSource(null, null, language, explicitlyDeclared));
        this.myLanguage = language;
    }

    @NotNull
    public static JSAnyType get(@Nullable PsiElement context, boolean isExplicitlyDeclared) {
        if (context != null && DialectDetector.isTypeScript(context)) {
            JSAnyType jSAnyType = isExplicitlyDeclared ? ourTSDeclared : ourTSEvaluated;
            if (jSAnyType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSAnyType", "get"));
            }
            return jSAnyType;
        }
        if (context != null && DialectDetector.isActionScript(context)) {
            JSAnyType jSAnyType = isExplicitlyDeclared ? ourASDeclared : ourASEvaluated;
            if (jSAnyType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSAnyType", "get"));
            }
            return jSAnyType;
        }
        JSAnyType jSAnyType = isExplicitlyDeclared ? ourJSDeclared : ourJSEvaluated;
        if (jSAnyType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSAnyType", "get"));
        }
        return jSAnyType;
    }

    @NotNull
    public String getTypeText(JSType.TypeTextFormat format) {
        String string = this.myLanguage == JSTypeSource.SourceLanguage.TS ? "any" : "*";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSAnyType", "getTypeText"));
        }
        return string;
    }

    @Override
    public void accept(JSRecursiveTypeVisitor visitor) {
    }

    @Override
    public void setSourceIfEmpty(JSTypeSource source) {
    }

    public boolean isDirectlyAssignableType(@Nullable JSType elementType, @Nullable ProcessingContext processingContext) {
        return true;
    }

    public boolean isEquivalentTo(@Nullable JSType type, @Nullable ProcessingContext processingContext) {
        return type == this;
    }

    @NotNull
    public JSAnyType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/JSAnyType", "copyWithNewSource"));
        }
        JSAnyType jSAnyType = JSAnyType.get((PsiElement)source.getScope(), source.isExplicitlyDeclared());
        if (jSAnyType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSAnyType", "copyWithNewSource"));
        }
        return jSAnyType;
    }
}

