/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.QualifiedItemProcessor;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSRecordTypeImpl
extends JSTypeBaseImpl
implements JSRecordType,
JSType.CompositeStructure {
    @NotNull
    private final List<JSRecordType.TypeMember> myTypeMembers;

    public JSRecordTypeImpl(@NotNull JSTypeSource source, @NotNull List<JSRecordType.TypeMember> typeMembers) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl", "<init>"));
        }
        if (typeMembers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeMembers", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl", "<init>"));
        }
        super(source);
        THashMap overloads = new THashMap();
        boolean hasOverloads = false;
        for (JSRecordType.TypeMember member : typeMembers) {
            if (!(member instanceof JSRecordType.PropertySignature)) continue;
            String name = ((JSRecordType.PropertySignature)member).getName();
            List addedWithSameName = (List)overloads.get(name);
            if (addedWithSameName == null) {
                overloads.put(name, new SmartList((Object)((JSRecordType.PropertySignature)member)));
                continue;
            }
            hasOverloads = true;
            addedWithSameName.add((JSRecordType.PropertySignature)member);
        }
        if (hasOverloads) {
            ArrayList<Object> newTypeMembers = new ArrayList<Object>(typeMembers.size());
            block1: for (JSRecordType.TypeMember member : typeMembers) {
                if (!(member instanceof JSRecordType.PropertySignature)) {
                    newTypeMembers.add(member);
                    continue;
                }
                String name = ((JSRecordType.PropertySignature)member).getName();
                List signaturesToMerge = (List)overloads.get(name);
                if (signaturesToMerge == null) continue;
                if (signaturesToMerge.size() == 1) {
                    newTypeMembers.add(signaturesToMerge.get(0));
                    continue;
                }
                ArrayList<JSRecordType.TypeMember> toMerge = new ArrayList<JSRecordType.TypeMember>(signaturesToMerge.size());
                boolean isAllMergedSignatureOptional = true;
                for (JSRecordType.PropertySignature signature : signaturesToMerge) {
                    JSType type;
                    if (!signature.isOptional()) {
                        isAllMergedSignatureOptional = false;
                    }
                    if (!((type = signature.getType()) instanceof JSFunctionTypeImpl)) {
                        newTypeMembers.add(signature);
                        continue block1;
                    }
                    toMerge.add((JSRecordType.TypeMember)new CallSignatureImpl(false, (JSFunctionTypeImpl)type));
                }
                newTypeMembers.add(new PropertySignatureImpl(name, new JSRecordTypeImpl(source, toMerge), isAllMergedSignatureOptional));
                overloads.remove(name);
            }
            this.myTypeMembers = Collections.unmodifiableList(newTypeMembers);
        } else {
            this.myTypeMembers = Collections.unmodifiableList(typeMembers);
        }
    }

    @NotNull
    public String getTypeText(JSType.TypeTextFormat format) {
        StringBuilder builder = new StringBuilder("{");
        String prefix = "";
        boolean useTypeScriptRecordTypeFormat = format == JSType.TypeTextFormat.CODE && this.isTypeScript();
        for (JSRecordType.TypeMember typeMember : this.myTypeMembers) {
            builder.append(prefix);
            if (typeMember instanceof JSRecordType.PropertySignature) {
                JSType propertyType;
                JSRecordType.PropertySignature property = (JSRecordType.PropertySignature)typeMember;
                String name = property.getName();
                boolean hasDot = name.contains(".");
                builder.append(format == JSType.TypeTextFormat.SERIALIZED || !hasDot ? name : "[" + name + "]");
                if (property.isOptional()) {
                    builder.append('?');
                }
                if ((propertyType = property.getType()) != null) {
                    builder.append(": ");
                    boolean appendBrackets = JSTypeUtils.isNeedWrapTypeForSerialization(propertyType);
                    if (appendBrackets) {
                        builder.append("(");
                    }
                    builder.append(propertyType.getTypeText(format));
                    if (appendBrackets) {
                        builder.append(")");
                    }
                }
            } else if (typeMember instanceof JSRecordType.CallSignature) {
                JSRecordType.CallSignature call = (JSRecordType.CallSignature)typeMember;
                if (call.hasNew()) {
                    builder.append("new");
                }
                builder.append(((JSFunctionTypeImpl)call.getFunctionType()).getTypeText(format, false));
            }
            prefix = useTypeScriptRecordTypeFormat ? "; " : ", ";
        }
        builder.append("}");
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl", "getTypeText"));
        }
        return string;
    }

    @Override
    public JSClass resolveClass() {
        return null;
    }

    public boolean isDirectlyAssignableType(@Nullable JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType instanceof JSFunctionTypeImpl || elementType instanceof JSTypeBaseImpl && ((JSTypeBaseImpl)elementType).isTypeScript() && (elementType instanceof JSNamedType || elementType instanceof JSGenericTypeImpl)) {
            JSType substitute = elementType.substitute();
            if (elementType != substitute) {
                return this.isDirectlyAssignableType(substitute, processingContext);
            }
            elementType = elementType.asRecordType();
        }
        if (elementType instanceof JSArrayType && elementType.getSource().isTypeScript()) {
            elementType = ((JSArrayType)elementType).asGenericType().asRecordType();
        }
        if (elementType instanceof JSRecordType) {
            return this.isDirectlyAssignableRecordType((JSRecordType)elementType, processingContext);
        }
        if (elementType instanceof JSObjectType) {
            return true;
        }
        return JSTypeCastUtil.isDirectlyAssignableTypeCommon(this, elementType, processingContext).isAssignable();
    }

    private boolean isDirectlyAssignableRecordType(@NotNull JSRecordType recordType, @Nullable ProcessingContext processingContext) {
        if (recordType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "recordType", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl", "isDirectlyAssignableRecordType"));
        }
        THashMap recTypeProperties = new THashMap(recordType.getTypeMembers().size());
        ArrayList callSignatures = null;
        for (JSRecordType.TypeMember typeMember : recordType.getTypeMembers()) {
            if (typeMember instanceof JSRecordType.CallSignature) {
                if (callSignatures == null) {
                    callSignatures = ContainerUtil.newArrayList();
                }
                callSignatures.add((JSRecordType.CallSignature)typeMember);
                continue;
            }
            if (!(typeMember instanceof JSRecordType.PropertySignature)) continue;
            JSRecordTypeImpl.addPropertyToMap((Map<String, List<JSType>>)recTypeProperties, (JSRecordType.PropertySignature)typeMember);
        }
        JSTypeSource source = recordType.getSource();
        JSUndefinedType undefinedType = null;
        Collection<JSRecordType.TypeMember> functionMembers = null;
        for (JSRecordType.TypeMember typeMember : this.getTypeMembers()) {
            if (typeMember instanceof JSRecordType.PropertySignature) {
                String propName = ((JSRecordType.PropertySignature)typeMember).getName();
                List recordPropertyTypes = (List)recTypeProperties.get(propName);
                if (recordPropertyTypes == null && !((JSRecordType.PropertySignature)typeMember).isOptional()) {
                    if (source.getLanguage() == JSTypeSource.SourceLanguage.JS) {
                        JSType propertyType;
                        if (undefinedType == null) {
                            undefinedType = new JSUndefinedType(source);
                        }
                        if ((propertyType = ((JSRecordType.PropertySignature)typeMember).getType()) == null || undefinedType.isDirectlyAssignableType(propertyType, processingContext)) continue;
                    }
                    if (callSignatures != null) {
                        if (functionMembers == null) {
                            functionMembers = QualifiedItemProcessor.getFunctionTypeMembers(this.getSource().getSourceElement());
                        }
                        if (functionMembers.contains(typeMember)) continue;
                        boolean exists = false;
                        for (JSRecordType.TypeMember member : functionMembers) {
                            if (!member.isEquivalentTo(typeMember)) continue;
                            exists = true;
                            break;
                        }
                        if (exists) continue;
                    }
                    return false;
                }
                if (recordPropertyTypes == null) continue;
                boolean hasAssignable = false;
                for (JSType recordPropertyType : recordPropertyTypes) {
                    JSType propertyType = ((JSRecordType.PropertySignature)typeMember).getType();
                    if (!JSRecordTypeImpl.skipTypeChecking(propertyType) && !JSRecordTypeImpl.skipTypeChecking(recordPropertyType) && !propertyType.isDirectlyAssignableType(recordPropertyType, processingContext)) continue;
                    hasAssignable = true;
                    break;
                }
                if (hasAssignable) continue;
                return false;
            }
            if (!(typeMember instanceof JSRecordType.CallSignature)) continue;
            boolean matchedCallSignatureFound = false;
            if (callSignatures != null) {
                for (JSRecordType.TypeMember callSignature : callSignatures) {
                    if (((JSRecordType.CallSignature)typeMember).hasNew() != ((JSRecordType.CallSignature)callSignature).hasNew()) continue;
                    JSFunctionTypeImpl functionType = (JSFunctionTypeImpl)((JSRecordType.CallSignature)typeMember).getFunctionType();
                    JSType returnType = functionType.getReturnType();
                    JSFunctionTypeImpl otherFunctionType = (JSFunctionTypeImpl)((JSRecordType.CallSignature)callSignature).getFunctionType();
                    JSType otherReturnType = otherFunctionType.getReturnType();
                    if (!JSTypeUtils.areArgumentsAssignable(functionType.getParameters(), otherFunctionType.getParameters(), processingContext, true, !this.isTypeScript(), this.isTypeScript()) || returnType != null && !(returnType instanceof JSVoidType) && !returnType.isDirectlyAssignableType(otherReturnType, processingContext)) continue;
                    matchedCallSignatureFound = true;
                    break;
                }
            }
            if (matchedCallSignatureFound) continue;
            return false;
        }
        return true;
    }

    private static void addPropertyToMap(Map<String, List<JSType>> recTypeProperties, JSRecordType.PropertySignature typeMember) {
        String name = typeMember.getName();
        List<JSType> types = recTypeProperties.get(name);
        if (types != null) {
            if (types.size() == 1) {
                ArrayList<JSType> arrayList = new ArrayList<JSType>();
                arrayList.add(types.get(0));
                recTypeProperties.put(name, arrayList);
                types = arrayList;
            }
            types.add(typeMember.getType());
        } else {
            recTypeProperties.put(name, Collections.singletonList(typeMember.getType()));
        }
    }

    public boolean isEquivalentTo(JSType type, ProcessingContext processingContext) {
        return type instanceof JSRecordType && this.getResolvedTypeText().equals(type.getResolvedTypeText());
    }

    @NotNull
    public List<JSRecordType.TypeMember> getTypeMembers() {
        List<JSRecordType.TypeMember> list = this.myTypeMembers;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl", "getTypeMembers"));
        }
        return list;
    }

    public boolean hasProperty(String name) {
        for (JSRecordType.TypeMember typeMember : this.myTypeMembers) {
            if (!(typeMember instanceof JSRecordType.PropertySignature) || !name.equals(((JSRecordType.PropertySignature)typeMember).getName())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public JSRecordType.PropertySignature findPropertySignature(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl", "findPropertySignature"));
        }
        for (JSRecordType.TypeMember typeMember : this.myTypeMembers) {
            if (!(typeMember instanceof JSRecordType.PropertySignature) || !name.equals(((JSRecordType.PropertySignature)typeMember).getName())) continue;
            return (JSRecordType.PropertySignature)typeMember;
        }
        return null;
    }

    @Override
    public void accept(JSRecursiveTypeVisitor visitor) {
        visitor.visitJSRecordType((JSType)this);
    }

    private static boolean skipTypeChecking(JSType type) {
        return type == null || type.getSource().getLanguage() == JSTypeSource.SourceLanguage.TS && !type.getSource().isExplicitlyDeclared();
    }

    @Override
    public void acceptChildren(JSRecursiveTypeVisitor visitor) {
        for (JSRecordType.TypeMember typeMember : this.myTypeMembers) {
            JSType type;
            JSType type2;
            if (typeMember instanceof JSRecordType.PropertySignature) {
                type2 = ((JSRecordType.PropertySignature)typeMember).getType();
                if (type2 == null) continue;
                type2.accept(visitor);
                continue;
            }
            if (typeMember instanceof JSRecordType.CallSignature) {
                type2 = ((JSRecordType.CallSignature)typeMember).getFunctionType();
                type2.accept(visitor);
                continue;
            }
            if (!(typeMember instanceof JSRecordType.IndexSignature)) continue;
            JSType parameterType = ((JSRecordType.IndexSignature)typeMember).getParameterType();
            if (parameterType != null) {
                parameterType.accept(visitor);
            }
            if ((type = ((JSRecordType.IndexSignature)typeMember).getType()) == null) continue;
            type.accept(visitor);
        }
    }

    @Override
    protected JSType copyTypeHierarchy(@NotNull Function<JSType, JSType> childTransform, @Nullable JSTypeSource newSource) {
        if (childTransform == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childTransform", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl", "copyTypeHierarchy"));
        }
        ArrayList<JSRecordType.TypeMember> typeMembers = new ArrayList<JSRecordType.TypeMember>();
        JSTypeSource appliedTypeSource = this.getSourceForCopy(newSource);
        boolean shouldCleanSource = appliedTypeSource.getSourceElement() == null;
        for (JSRecordType.TypeMember member : this.getTypeMembers()) {
            if (member instanceof JSRecordType.CallSignature) {
                JSRecordType.CallSignature callSignature = (JSRecordType.CallSignature)member;
                JSType newFunctionType = JSTypeUtils.transformTypeHierarchySafe(callSignature.getFunctionType(), childTransform, newSource);
                CallSignatureImpl newCallSignature = new CallSignatureImpl(callSignature.hasNew(), (JSFunctionTypeImpl)newFunctionType);
                typeMembers.add((JSRecordType.TypeMember)newCallSignature);
                continue;
            }
            if (member instanceof JSRecordType.IndexSignature) {
                JSRecordType.IndexSignature indexSignature = (JSRecordType.IndexSignature)member;
                typeMembers.add((JSRecordType.TypeMember)new IndexSignatureImpl(JSTypeUtils.transformTypeHierarchySafe(indexSignature.getParameterType(), childTransform, newSource), JSTypeUtils.transformTypeHierarchySafe(indexSignature.getType(), childTransform, newSource), shouldCleanSource ? null : member.getSource()));
                continue;
            }
            if (!(member instanceof JSRecordType.PropertySignature)) continue;
            JSRecordType.PropertySignature propertySignature = (JSRecordType.PropertySignature)member;
            PropertySignatureImpl newPropertySignature = new PropertySignatureImpl(propertySignature.getName(), JSTypeUtils.transformTypeHierarchySafe(propertySignature.getType(), childTransform, newSource), propertySignature.isOptional(), shouldCleanSource ? null : member.getSource());
            typeMembers.add((JSRecordType.TypeMember)newPropertySignature);
        }
        return new JSRecordTypeImpl(this.getSourceForCopy(newSource), typeMembers);
    }

    @NotNull
    public JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl", "copyWithNewSource"));
        }
        JSRecordTypeImpl jSRecordTypeImpl = new JSRecordTypeImpl(source, this.getTypeMembers());
        if (jSRecordTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl", "copyWithNewSource"));
        }
        return jSRecordTypeImpl;
    }

    @Override
    @NotNull
    public JSRecordType asRecordType() {
        JSRecordTypeImpl jSRecordTypeImpl = this;
        if (jSRecordTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl", "asRecordType"));
        }
        return jSRecordTypeImpl;
    }

    public static class PropertySignatureImpl
    implements JSRecordType.PropertySignature {
        @NotNull
        public final String name;
        @Nullable
        public final JSType type;
        private final boolean optional;
        @Nullable
        private PsiElement mySource;

        public PropertySignatureImpl(@NotNull String name, @Nullable JSType type, boolean optional, @Nullable PsiElement source) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl$PropertySignatureImpl", "<init>"));
            }
            this(name, type, optional);
            this.mySource = source;
        }

        public PropertySignatureImpl(@NotNull String name, @Nullable JSType type, boolean optional) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl$PropertySignatureImpl", "<init>"));
            }
            this.name = name;
            this.type = type;
            this.optional = optional;
        }

        @NotNull
        public String getName() {
            String string = this.name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl$PropertySignatureImpl", "getName"));
            }
            return string;
        }

        @Nullable
        public JSType getType() {
            return this.type;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public boolean isEquivalentTo(JSRecordType.TypeMember other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof JSRecordType.PropertySignature)) {
                return false;
            }
            return this.name.equals(((JSRecordType.PropertySignature)other).getName()) && (this.type != null ? this.type.isEquivalentTo(((JSRecordType.PropertySignature)other).getType(), null) : ((JSRecordType.PropertySignature)other).getType() == null) && this.optional == ((JSRecordType.PropertySignature)other).isOptional();
        }

        @Nullable
        public PsiElement getSource() {
            return this.mySource;
        }
    }

    public static class IndexSignatureImpl
    implements JSRecordType.IndexSignature {
        final JSType parameterType;
        final JSType type;
        private final PsiElement mySource;

        public IndexSignatureImpl(JSType parameterType, JSType type, PsiElement source) {
            this.mySource = source;
            this.parameterType = parameterType;
            this.type = type;
        }

        @NotNull
        public JSType getParameterType() {
            Object object = this.parameterType != null ? this.parameterType : JSAnyType.get(null, false);
            if (object == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl$IndexSignatureImpl", "getParameterType"));
            }
            return object;
        }

        @NotNull
        public JSType getType() {
            Object object = this.type != null ? this.type : JSAnyType.get(null, false);
            if (object == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl$IndexSignatureImpl", "getType"));
            }
            return object;
        }

        public boolean isEquivalentTo(JSRecordType.TypeMember other) {
            if (!(other instanceof JSRecordType.IndexSignature)) {
                return false;
            }
            return this.getParameterType().isEquivalentTo(((JSRecordType.IndexSignature)other).getParameterType(), null) && this.getType().isEquivalentTo(((JSRecordType.IndexSignature)other).getType(), null);
        }

        @Nullable
        public PsiElement getSource() {
            return this.mySource;
        }
    }

    public static class CallSignatureImpl
    implements JSRecordType.CallSignature {
        final boolean hasNew;
        @NotNull
        final JSFunctionTypeImpl functionType;

        public CallSignatureImpl(boolean hasNew, @NotNull JSFunctionTypeImpl functionType) {
            if (functionType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionType", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl$CallSignatureImpl", "<init>"));
            }
            this.hasNew = hasNew;
            this.functionType = functionType;
        }

        public boolean hasNew() {
            return this.hasNew;
        }

        @NotNull
        public JSFunctionTypeImpl getFunctionType() {
            JSFunctionTypeImpl jSFunctionTypeImpl = this.functionType;
            if (jSFunctionTypeImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl$CallSignatureImpl", "getFunctionType"));
            }
            return jSFunctionTypeImpl;
        }

        public boolean isEquivalentTo(JSRecordType.TypeMember other) {
            if (!(other instanceof JSRecordType.CallSignature)) {
                return false;
            }
            return ((JSRecordType.CallSignature)other).hasNew() == this.hasNew() && ((JSRecordType.CallSignature)other).getFunctionType().isEquivalentTo((JSType)this.getFunctionType(), null);
        }

        @Nullable
        public PsiElement getSource() {
            return this.functionType.getSource().getSourceElement();
        }
    }
}

