/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.ecmascript6.psi.JSClassExpression;
import com.intellij.lang.javascript.ecmascript6.TypeScriptImportHandler;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.index.JavaScriptIndex;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameterItemWithSource;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.JSComputedPropertyNameOwner;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptArrayType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCallSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunctionSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunctionType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptIndexSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptSingleType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptStringLiteralType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptThisType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeArgumentList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypePredicate;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeofType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.resolve.QualifiedItemProcessor;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSIntersectionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.JSTypeofTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptGenericThisTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptJSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypePredicateTypeImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptTypeParser {
    public static final ParameterizedCachedValueProvider<JSRecordType, JSClass> BUILD_CLASS_PROVIDER = new ParameterizedCachedValueProvider<JSRecordType, JSClass>(){

        @Nullable
        public CachedValueProvider.Result<JSRecordType> compute(JSClass currentClass) {
            return CachedValueProvider.Result.create((Object)TypeScriptTypeParser.buildTypeFromClass(currentClass, false, true), (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()});
        }
    };
    public static final Key<ParameterizedCachedValue<JSRecordType, JSClass>> BUILD_CLASS_CACHE_KEY = Key.create((String)"typescript.create.record.for.class");
    public static Function<JSType, AssertionError> CHECK_TYPE_FUNCTION = null;
    public static final Function<JSTypeDeclaration, JSType> MAP_DECLARATION_TO_TYPE = new Function<JSTypeDeclaration, JSType>(){

        public JSType fun(JSTypeDeclaration declaration) {
            return TypeScriptTypeParser.buildTypeFromTypeScript(declaration);
        }
    };
    private static final ArrayList<String> CORE_LIBS = ContainerUtil.newArrayList((Object[])new String[]{"lib.core.d.ts", "lib.core.es6.d.ts"});

    @NotNull
    public static JSType buildTypeFromTypeScript(@NotNull JSTypeDeclaration type) {
        AssertionError message;
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/types/TypeScriptTypeParser", "buildTypeFromTypeScript"));
        }
        JSType resultType = TypeScriptTypeParser.buildTypeFromTypeScriptImpl(type);
        if (CHECK_TYPE_FUNCTION != null && (message = (AssertionError)CHECK_TYPE_FUNCTION.fun((Object)resultType)) != null) {
            throw message;
        }
        JSType jSType = resultType;
        if (jSType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptTypeParser", "buildTypeFromTypeScript"));
        }
        return jSType;
    }

    @NotNull
    private static JSType buildTypeFromTypeScriptImpl(@NotNull JSTypeDeclaration type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/types/TypeScriptTypeParser", "buildTypeFromTypeScriptImpl"));
        }
        JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)type, true);
        if (type instanceof TypeScriptObjectType) {
            ArrayList<JSRecordType.TypeMember> typeMembers = new ArrayList<JSRecordType.TypeMember>();
            TypeScriptTypeParser.addObjectTypeProperties(typeMembers, (TypeScriptObjectType)type, source, JSTypeSubstitutor.EMPTY);
            JSRecordTypeImpl jSRecordTypeImpl = new JSRecordTypeImpl(source, typeMembers);
            if (jSRecordTypeImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptTypeParser", "buildTypeFromTypeScriptImpl"));
            }
            return jSRecordTypeImpl;
        }
        if (type instanceof TypeScriptFunctionType) {
            TypeScriptJSFunctionTypeImpl jsType = TypeScriptTypeParser.buildTypeScriptFunctionTypeImpl((JSFunction)((TypeScriptFunctionType)type));
            if (((TypeScriptFunctionType)type).isConstructor()) {
                SmartList typeMembers = new SmartList((Object)new JSRecordTypeImpl.CallSignatureImpl(true, jsType));
                JSRecordTypeImpl jSRecordTypeImpl = new JSRecordTypeImpl(source, (List<JSRecordType.TypeMember>)typeMembers);
                if (jSRecordTypeImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptTypeParser", "buildTypeFromTypeScriptImpl"));
                }
                return jSRecordTypeImpl;
            }
            TypeScriptJSFunctionTypeImpl typeScriptJSFunctionTypeImpl = jsType;
            if (typeScriptJSFunctionTypeImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptTypeParser", "buildTypeFromTypeScriptImpl"));
            }
            return typeScriptJSFunctionTypeImpl;
        }
        if (type instanceof TypeScriptArrayType) {
            TypeScriptType arrayBaseType = ((TypeScriptArrayType)type).getType();
            JSType baseType = arrayBaseType != null ? TypeScriptTypeParser.buildTypeFromTypeScript((JSTypeDeclaration)arrayBaseType) : JSAnyType.get((PsiElement)type, false);
            JSArrayTypeImpl jSArrayTypeImpl = new JSArrayTypeImpl(baseType, source);
            if (jSArrayTypeImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptTypeParser", "buildTypeFromTypeScriptImpl"));
            }
            return jSArrayTypeImpl;
        }
        if (type instanceof TypeScriptSingleType) {
            String typeName = ((TypeScriptSingleType)type).getQualifiedTypeName();
            if (typeName != null) {
                TypeScriptTypeArgumentList typeArguments;
                TypeScriptTypeParameterListOwner parameterListOwner = (TypeScriptTypeParameterListOwner)PsiTreeUtil.getParentOfType((PsiElement)type, TypeScriptTypeParameterListOwner.class);
                TypeScriptTypeParameterList partOfList = (TypeScriptTypeParameterList)PsiTreeUtil.getParentOfType((PsiElement)type, TypeScriptTypeParameterList.class);
                JSType baseType = null;
                while (parameterListOwner != null) {
                    TypeScriptTypeParameterList typeParameterList = parameterListOwner.getTypeParameterList();
                    if (typeParameterList != null) {
                        TypeScriptTypeParameter[] parameters;
                        for (TypeScriptTypeParameter parameter : parameters = typeParameterList.getTypeParameters()) {
                            if (!StringUtil.equals((CharSequence)typeName, (CharSequence)parameter.getName())) continue;
                            TypeScriptType constraint = parameter.getTypeConstraint();
                            JSType constraintType = null;
                            if (constraint != null && partOfList == null) {
                                constraintType = TypeScriptTypeParser.buildTypeFromTypeScript((JSTypeDeclaration)constraint);
                            }
                            baseType = new JSGenericParameterImpl(typeName, source, constraintType);
                        }
                    }
                    parameterListOwner = (TypeScriptTypeParameterListOwner)PsiTreeUtil.getParentOfType((PsiElement)parameterListOwner, TypeScriptTypeParameterListOwner.class);
                }
                if (baseType == null) {
                    baseType = JSNamedType.createType(typeName, source, JSContext.INSTANCE);
                }
                if ((typeArguments = ((TypeScriptSingleType)type).getTypeArguments()) != null) {
                    JSGenericTypeImpl jSGenericTypeImpl = new JSGenericTypeImpl(source, baseType, ContainerUtil.map((Object[])typeArguments.getTypeArguments(), MAP_DECLARATION_TO_TYPE));
                    if (jSGenericTypeImpl == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptTypeParser", "buildTypeFromTypeScriptImpl"));
                    }
                    return jSGenericTypeImpl;
                }
                JSType jSType = baseType;
                if (jSType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptTypeParser", "buildTypeFromTypeScriptImpl"));
                }
                return jSType;
            }
        } else if (type instanceof TypeScriptStringLiteralType) {
            String literal = ((TypeScriptStringLiteralType)type).getInnerText();
            if (literal != null) {
                JSStringLiteralTypeImpl jSStringLiteralTypeImpl = new JSStringLiteralTypeImpl(literal, true, source);
                if (jSStringLiteralTypeImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptTypeParser", "buildTypeFromTypeScriptImpl"));
                }
                return jSStringLiteralTypeImpl;
            }
        } else if (type instanceof TypeScriptTypeofType) {
            JSExpression expression = ((TypeScriptTypeofType)type).getExpression();
            if (expression != null) {
                JSTypeofTypeImpl jSTypeofTypeImpl = new JSTypeofTypeImpl(expression, source);
                if (jSTypeofTypeImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptTypeParser", "buildTypeFromTypeScriptImpl"));
                }
                return jSTypeofTypeImpl;
            }
        } else if (type instanceof TypeScriptUnionOrIntersectionType) {
            ArrayList types = ContainerUtil.newArrayList();
            TypeScriptUnionOrIntersectionType unionOrIntersectionType = (TypeScriptUnionOrIntersectionType)type;
            for (TypeScriptType scriptType : unionOrIntersectionType.getTypes()) {
                types.add(TypeScriptTypeParser.buildTypeFromTypeScript((JSTypeDeclaration)scriptType));
            }
            if (unionOrIntersectionType.isUnionType()) {
                ContainerUtil.sort((List)types, JSCompositeTypeImpl.GENERIC_PARAMETER_LAST);
                JSCompositeTypeImpl jSCompositeTypeImpl = new JSCompositeTypeImpl(source, types);
                if (jSCompositeTypeImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptTypeParser", "buildTypeFromTypeScriptImpl"));
                }
                return jSCompositeTypeImpl;
            }
            if (unionOrIntersectionType.isIntersectionType()) {
                JSType jSType = JSIntersectionTypeImpl.getIntersectionType(types, source);
                if (jSType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptTypeParser", "buildTypeFromTypeScriptImpl"));
                }
                return jSType;
            }
        } else {
            JSClass parentClass;
            if (type instanceof TypeScriptTypePredicate) {
                TypeScriptTypePredicate typePredicate = (TypeScriptTypePredicate)type;
                JSType guardType = typePredicate.getGuardType();
                TypeScriptTypePredicateTypeImpl typeScriptTypePredicateTypeImpl = new TypeScriptTypePredicateTypeImpl(guardType, source, typePredicate.getParameterName(), typePredicate.getParameterIndex());
                if (typeScriptTypePredicateTypeImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptTypeParser", "buildTypeFromTypeScriptImpl"));
                }
                return typeScriptTypePredicateTypeImpl;
            }
            if (type instanceof TypeScriptThisType && (parentClass = (JSClass)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)type, JSClass.class)) != null) {
                String name = parentClass.getQualifiedName();
                JSType parentType = name == null ? null : JSNamedType.createType(name, source, JSContext.INSTANCE);
                TypeScriptGenericThisTypeImpl typeScriptGenericThisTypeImpl = new TypeScriptGenericThisTypeImpl(JSTypeSourceFactory.createTypeSource((PsiElement)parentClass, true), parentType);
                if (typeScriptGenericThisTypeImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptTypeParser", "buildTypeFromTypeScriptImpl"));
                }
                return typeScriptGenericThisTypeImpl;
            }
        }
        JSAnyType jSAnyType = JSAnyType.get((PsiElement)type, false);
        if (jSAnyType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptTypeParser", "buildTypeFromTypeScriptImpl"));
        }
        return jSAnyType;
    }

    @NotNull
    public static TypeScriptJSFunctionTypeImpl buildTypeScriptFunctionTypeImpl(@NotNull JSFunction type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/types/TypeScriptTypeParser", "buildTypeScriptFunctionTypeImpl"));
        }
        TypeScriptJSFunctionTypeImpl typeScriptJSFunctionTypeImpl = TypeScriptTypeParser.buildTypeScriptFunctionTypeImpl(type, type.getReturnType());
        if (typeScriptJSFunctionTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptTypeParser", "buildTypeScriptFunctionTypeImpl"));
        }
        return typeScriptJSFunctionTypeImpl;
    }

    private static TypeScriptJSFunctionTypeImpl buildTypeScriptFunctionTypeImpl(@NotNull JSFunction type, @Nullable JSType returnType) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/types/TypeScriptTypeParser", "buildTypeScriptFunctionTypeImpl"));
        }
        SmartList decorators = new SmartList();
        JSParameterItemWithSource[] parameters = type.getParameters();
        String[] parameterNames = ArrayUtil.EMPTY_STRING_ARRAY;
        if (parameters.length > 0) {
            parameterNames = new String[parameters.length];
        }
        int index = 0;
        for (JSParameterItemWithSource p : parameters) {
            decorators.add(p.getTypeDecorator());
            parameterNames[index++] = p.getName();
        }
        return new TypeScriptJSFunctionTypeImpl(JSTypeSourceFactory.createTypeSource((PsiElement)type, true), (List<JSParameterTypeDecorator>)decorators, parameterNames, returnType);
    }

    private static void addObjectTypeProperties(List<JSRecordType.TypeMember> typeMembers, @Nullable TypeScriptObjectType type, JSTypeSource source, JSTypeSubstitutor typeSubstitutor) {
        TypeScriptTypeMember[] members;
        if (type == null) {
            return;
        }
        for (TypeScriptTypeMember member : members = type.getTypeMembers()) {
            JSRecordType.TypeMember typeMember = TypeScriptTypeParser.buildTypeMember(member, source, typeSubstitutor);
            if (typeMember == null) continue;
            typeMembers.add(typeMember);
        }
    }

    public static JSRecordType.TypeMember buildTypeMember(@NotNull TypeScriptTypeMember member, JSTypeSource source) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/lang/javascript/psi/types/TypeScriptTypeParser", "buildTypeMember"));
        }
        return TypeScriptTypeParser.buildTypeMember(member, source, JSTypeSubstitutor.EMPTY);
    }

    @Nullable
    public static JSRecordType.TypeMember buildTypeMember(@NotNull TypeScriptTypeMember member, JSTypeSource source, @Nullable JSTypeSubstitutor typeSubstitutor) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/lang/javascript/psi/types/TypeScriptTypeParser", "buildTypeMember"));
        }
        Object typeMember = null;
        if (member instanceof TypeScriptPropertySignature) {
            JSTypeDeclaration propertyType = ((TypeScriptPropertySignature)member).getTypeDeclaration();
            String name = member.getName();
            if (name == null) {
                name = JSPsiImplUtils.getComputedPropertyNameWithoutBrackets((JSComputedPropertyNameOwner)((TypeScriptPropertySignature)member));
            }
            if (name != null) {
                JSType type = propertyType != null ? TypeScriptTypeParser.buildTypeFromTypeScript(propertyType) : null;
                typeMember = new JSRecordTypeImpl.PropertySignatureImpl(name, JSTypeUtils.applyGenericArguments(type, (Map<String, JSType>)typeSubstitutor), ((TypeScriptPropertySignature)member).isOptional(), (PsiElement)member);
            }
        } else if (member instanceof TypeScriptFunctionSignature) {
            TypeScriptFunctionSignature functionSignature = (TypeScriptFunctionSignature)member;
            String name = functionSignature.getName();
            if (name == null) {
                name = JSPsiImplUtils.getComputedPropertyNameWithoutBrackets((JSComputedPropertyNameOwner)functionSignature);
            }
            if (name != null) {
                JSType type = JSTypeUtils.applyGenericArguments(TypeScriptTypeParser.buildTypeFromClassMember((PsiElement)functionSignature, source), (Map<String, JSType>)typeSubstitutor);
                typeMember = new JSRecordTypeImpl.PropertySignatureImpl(name, type, functionSignature.isOptional(), (PsiElement)member);
            }
        } else if (member instanceof TypeScriptCallSignature) {
            TypeScriptCallSignature callSignature = (TypeScriptCallSignature)member;
            JSFunctionTypeImpl functionType = (JSFunctionTypeImpl)JSTypeUtils.applyGenericArguments(TypeScriptTypeParser.buildTypeScriptFunctionTypeImpl((JSFunction)callSignature), (Map<String, JSType>)typeSubstitutor);
            typeMember = new JSRecordTypeImpl.CallSignatureImpl(callSignature.isConstructor(), functionType);
        } else if (member instanceof TypeScriptIndexSignature) {
            TypeScriptType typePsi = ((TypeScriptIndexSignature)member).getType();
            JSType signatureType = typePsi != null ? TypeScriptTypeParser.buildTypeFromTypeScript((JSTypeDeclaration)typePsi) : null;
            TypeScriptType parameterTypePsi = ((TypeScriptIndexSignature)member).getParameterType();
            JSType parameterType = parameterTypePsi != null ? TypeScriptTypeParser.buildTypeFromTypeScript((JSTypeDeclaration)parameterTypePsi) : null;
            typeMember = new JSRecordTypeImpl.IndexSignatureImpl(JSTypeUtils.applyGenericArguments(parameterType, (Map<String, JSType>)typeSubstitutor), JSTypeUtils.applyGenericArguments(signatureType, (Map<String, JSType>)typeSubstitutor), (PsiElement)member);
        }
        return typeMember;
    }

    @NotNull
    public static JSRecordType buildTypeFromClass(@NotNull JSClass clazz, boolean isStatic) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/lang/javascript/psi/types/TypeScriptTypeParser", "buildTypeFromClass"));
        }
        if (!isStatic) {
            JSRecordType jSRecordType = (JSRecordType)CachedValuesManager.getManager((Project)clazz.getProject()).getParameterizedCachedValue((UserDataHolder)clazz, BUILD_CLASS_CACHE_KEY, BUILD_CLASS_PROVIDER, false, (Object)clazz);
            if (jSRecordType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptTypeParser", "buildTypeFromClass"));
            }
            return jSRecordType;
        }
        JSRecordType jSRecordType = TypeScriptTypeParser.buildTypeFromClass(clazz, true, true);
        if (jSRecordType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptTypeParser", "buildTypeFromClass"));
        }
        return jSRecordType;
    }

    public static JSRecordType buildTypeFromClass(@NotNull JSClass clazz, boolean isStatic, boolean includeSupers) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/lang/javascript/psi/types/TypeScriptTypeParser", "buildTypeFromClass"));
        }
        return TypeScriptTypeParser.buildTypeFromClass(clazz, isStatic, includeSupers, true);
    }

    @NotNull
    public static JSRecordType buildTypeFromClass(final @NotNull JSClass clazz, final boolean isStatic, boolean includeSupers, final boolean includeAbstractMembers) {
        JSType declaration;
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/lang/javascript/psi/types/TypeScriptTypeParser", "buildTypeFromClass"));
        }
        if (clazz instanceof TypeScriptTypeAlias && (declaration = ((TypeScriptTypeAlias)clazz).getParsedTypeDeclaration()) != null) {
            JSRecordType jSRecordType = declaration.asRecordType();
            if (jSRecordType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptTypeParser", "buildTypeFromClass"));
            }
            return jSRecordType;
        }
        final JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)clazz, true);
        final ArrayList<JSRecordType.TypeMember> typeMembers = new ArrayList<JSRecordType.TypeMember>();
        TypeScriptUtil.JSClassHierarchyProcessor processor = new TypeScriptUtil.JSClassHierarchyProcessor(){
            private boolean isFunctionProcessed = false;

            @Override
            public boolean process(JSClass<?> currentClass, JSTypeSubstitutor typeSubstitutor, boolean fromImplements) {
                if (currentClass != clazz && TypeScriptTypeParser.isFunctionClass(currentClass)) {
                    if (this.isFunctionProcessed) {
                        return true;
                    }
                    typeMembers.addAll(QualifiedItemProcessor.getFunctionTypeMembers((PsiElement)clazz));
                    this.isFunctionProcessed = true;
                    return true;
                }
                if (currentClass instanceof TypeScriptInterface) {
                    TypeScriptObjectType body = ((TypeScriptInterface)currentClass).getBody();
                    TypeScriptTypeParser.addObjectTypeProperties(typeMembers, body, source, typeSubstitutor);
                } else {
                    for (JSElement element : currentClass.getMembers()) {
                        JSRecordType.TypeMember typeMember;
                        JSFunction function;
                        JSAttributeList list;
                        if (element instanceof JSFunction && !includeAbstractMembers && (list = (function = (JSFunction)element).getAttributeList()) != null && list.hasModifier(JSAttributeList.ModifierType.ABSTRACT) || (typeMember = TypeScriptTypeParser.buildTypeMemberFromClassMember(clazz, isStatic, source, element, typeSubstitutor)) == null) continue;
                        typeMembers.add(typeMember);
                    }
                }
                return true;
            }
        };
        if (includeSupers) {
            TypeScriptUtil.processClassesInHierarchy(clazz, includeAbstractMembers, processor);
        } else {
            processor.process(clazz, JSTypeSubstitutor.EMPTY, false);
        }
        if (clazz instanceof TypeScriptClass && isStatic) {
            ArrayList constructorTypes = ContainerUtil.newArrayList();
            for (JSRecordType.TypeMember member : typeMembers) {
                if (!(member instanceof JSRecordType.CallSignature) || !((JSRecordType.CallSignature)member).hasNew()) continue;
                constructorTypes.add(member);
                break;
            }
            if (constructorTypes.isEmpty()) {
                JSType returnType = TypeScriptTypeParser.createConstructorReturnType(clazz, source);
                JSFunctionTypeImpl functionType = new JSFunctionTypeImpl(source, ContainerUtil.emptyList(), returnType);
                typeMembers.add((JSRecordType.TypeMember)new JSRecordTypeImpl.CallSignatureImpl(true, functionType));
            }
        }
        JSRecordTypeImpl jSRecordTypeImpl = new JSRecordTypeImpl(source, typeMembers);
        if (jSRecordTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptTypeParser", "buildTypeFromClass"));
        }
        return jSRecordTypeImpl;
    }

    private static JSType createConstructorReturnType(@NotNull JSClass clazz, JSTypeSource source) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/lang/javascript/psi/types/TypeScriptTypeParser", "createConstructorReturnType"));
        }
        String name = clazz.getQualifiedName();
        if (StringUtil.isEmpty((String)name)) {
            if (clazz instanceof JSExpression) {
                return TypeScriptTypeParser.buildTypeFromClass(clazz, false);
            }
            return JSAnyType.get(source.getSourceElement(), false);
        }
        return JSNamedType.createType(name, source, JSContext.INSTANCE);
    }

    private static boolean isFunctionClass(JSClass<?> currentClass) {
        String fileName = currentClass.getContainingFile().getName();
        return "Function".equals(currentClass.getName()) && (JavaScriptIndex.LIBS_D_TS.contains(fileName) || CORE_LIBS.contains(fileName));
    }

    @Nullable
    public static JSRecordType.TypeMember buildTypeMemberFromClassMember(JSClass ownerClass, boolean isStatic, JSTypeSource source, JSElement element, @Nullable JSTypeSubstitutor typeSubstitutor) {
        JSAttributeList attributeList;
        if (element instanceof JSFunction && ((JSFunction)element).isConstructor()) {
            if (isStatic) {
                TypeScriptJSFunctionTypeImpl functionType = TypeScriptTypeParser.buildTypeScriptFunctionTypeImpl((JSFunction)element, TypeScriptTypeParser.createConstructorReturnType(ownerClass, source));
                TypeScriptJSFunctionTypeImpl type = (TypeScriptJSFunctionTypeImpl)JSTypeUtils.applyGenericArguments(functionType, (Map<String, JSType>)typeSubstitutor);
                return new JSRecordTypeImpl.CallSignatureImpl(true, type);
            }
            return null;
        }
        if (element instanceof JSAttributeListOwner && ((attributeList = ((JSAttributeListOwner)element).getAttributeList()) != null && attributeList.hasModifier(JSAttributeList.ModifierType.STATIC)) != isStatic) {
            return null;
        }
        if (element instanceof TypeScriptTypeMember) {
            return TypeScriptTypeParser.buildTypeMember((TypeScriptTypeMember)element, source, typeSubstitutor);
        }
        String name = element.getName();
        if (name == null && element instanceof JSComputedPropertyNameOwner) {
            name = JSPsiImplUtils.getComputedPropertyNameWithoutBrackets((JSComputedPropertyNameOwner)element);
        }
        if (name == null) {
            return null;
        }
        JSType type = JSTypeUtils.applyGenericArguments(TypeScriptTypeParser.buildTypeFromClassMember((PsiElement)element, source), (Map<String, JSType>)typeSubstitutor);
        return new JSRecordTypeImpl.PropertySignatureImpl(name, type, false, (PsiElement)element);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static JSType buildTypeFromClassMember(PsiElement element, JSTypeSource source) {
        if (element instanceof JSFunction) {
            if (((JSFunction)element).isGetProperty()) {
                return ((JSFunction)element).getReturnType();
            }
            if (!((JSFunction)element).isSetProperty()) return TypeScriptTypeParser.buildTypeScriptFunctionTypeImpl((JSFunction)element);
            JSParameterItemWithSource[] parameters = ((JSFunction)element).getParameters();
            if (parameters.length != 1) return null;
            return parameters[0].getType();
        }
        if (element instanceof JSVariable) {
            return ((JSVariable)element).getType();
        }
        if (!(element instanceof TypeScriptPropertySignature)) return null;
        return ((TypeScriptPropertySignature)element).getType();
    }

    public static JSRecordType buildResolvedType(Collection<? extends PsiElement> elements, JSType type, @Nullable JSEvaluateContext evaluateContext) {
        boolean isStatic = type instanceof JSNamedType && ((JSNamedType)type).isStaticOrInstance() == JSContext.STATIC;
        ArrayList<JSRecordType.TypeMember> members = new ArrayList<JSRecordType.TypeMember>();
        for (PsiElement psiElement : elements) {
            TypeScriptTypeParser.addTypeMembersFromClass(type, isStatic, members, psiElement, evaluateContext);
        }
        return new JSRecordTypeImpl(type.getSource(), members);
    }

    public static JSRecordType buildResolvedType(Collection<? extends PsiElement> elements, JSType type) {
        return TypeScriptTypeParser.buildResolvedType(elements, type, null);
    }

    @NotNull
    public static JSRecordType buildResolvedType(JSType type) {
        Collection<? extends PsiElement> elements = TypeScriptTypeParser.resolveElementsByType(type);
        JSRecordType jSRecordType = TypeScriptTypeParser.buildResolvedType(elements, type);
        if (jSRecordType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptTypeParser", "buildResolvedType"));
        }
        return jSRecordType;
    }

    @NotNull
    public static Collection<? extends PsiElement> resolveElementsByType(@Nullable JSType type) {
        if (type == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptTypeParser", "resolveElementsByType"));
            }
            return list;
        }
        PsiElement sourceElement = type.getSource().getSourceElement();
        if (sourceElement == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptTypeParser", "resolveElementsByType"));
            }
            return list;
        }
        String qName = JSTypeUtils.getQualifiedNameMatchingType(type, false);
        if (qName == null) {
            if (type instanceof JSRecordType && sourceElement instanceof JSClassExpression) {
                List list = ContainerUtil.createMaybeSingletonList((Object)sourceElement);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptTypeParser", "resolveElementsByType"));
                }
                return list;
            }
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptTypeParser", "resolveElementsByType"));
            }
            return list;
        }
        JSTypeResolveResult result = TypeScriptImportHandler.getInstance().resolveTypeName(qName, sourceElement);
        Collection<? extends PsiElement> collection = result.getElements();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptTypeParser", "resolveElementsByType"));
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static void addTypeMembersFromClass(JSType type, boolean isStatic, List<JSRecordType.TypeMember> members, PsiElement element, @Nullable JSEvaluateContext evaluateContext) {
        if (element instanceof JSClass) {
            if (type instanceof JSArrayTypeImpl) {
                type = ((JSArrayTypeImpl)type).asGenericType();
            }
            classType = null;
            if (type instanceof JSGenericTypeImpl) {
                classType = JSTypeCastUtil.buildWithAppliedGenericArguments((JSClass)element, (JSGenericTypeImpl)type);
            } else if (element instanceof TypeScriptTypeAlias) {
                if (evaluateContext == null) {
                    evaluateContext = new JSEvaluateContext(element.getContainingFile());
                }
                if (evaluateContext.isAlreadyProcessingItem(element)) {
                    return;
                }
                evaluateContext.addProcessingItem(element);
                try {
                    declaration = ((TypeScriptTypeAlias)element).getParsedTypeDeclaration();
                    if (declaration instanceof JSRecordType) {
                        classType = (JSRecordType)declaration;
                    }
                    if (declaration instanceof JSFunctionTypeImpl) {
                        classType = JSTypeUtils.buildRecordType((JSFunctionTypeImpl)declaration);
                    }
                    if (declaration == null) ** GOTO lbl29
                    classType = TypeScriptTypeParser.buildResolvedType(TypeScriptTypeParser.resolveElementsByType(declaration), declaration, evaluateContext);
                }
                finally {
                    evaluateContext.removeProcessingItem(element);
                }
            } else {
                classType = TypeScriptTypeParser.buildTypeFromClass((JSClass)element, isStatic);
            }
lbl29:
            // 6 sources

            if (classType != null) {
                members.addAll(classType.getTypeMembers());
            }
        } else if (element instanceof TypeScriptModule && isStatic && (moduleType = TypeScriptTypeParser.buildTypeForModule((TypeScriptModule)element)) != null) {
            members.addAll(moduleType.getTypeMembers());
        }
    }

    @Nullable
    public static JSRecordType buildTypeForModule(@NotNull TypeScriptModule element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/types/TypeScriptTypeParser", "buildTypeForModule"));
        }
        if (element.isInstantiated()) {
            JSSourceElement[] elements = JSResolveUtil.getSourceElements((PsiElement)element);
            ArrayList<JSRecordType.TypeMember> typeMembers = new ArrayList<JSRecordType.TypeMember>();
            for (JSSourceElement sourceElement : elements) {
                if (!(sourceElement instanceof JSVarStatement) && (!(sourceElement instanceof JSElementBase) || ((JSElementBase)sourceElement).getAccessType() != JSAttributeList.AccessType.PUBLIC)) continue;
                if (sourceElement instanceof JSVarStatement) {
                    for (JSVariable variable : ((JSVarStatement)sourceElement).getVariables()) {
                        String name;
                        if (variable.getAccessType() != JSAttributeList.AccessType.PUBLIC || (name = variable.getName()) == null) continue;
                        typeMembers.add((JSRecordType.TypeMember)new JSRecordTypeImpl.PropertySignatureImpl(name, variable.getType(), false, (PsiElement)variable));
                    }
                    continue;
                }
                if (sourceElement instanceof JSFunction) {
                    JSFunction function = (JSFunction)sourceElement;
                    String name = function.getName();
                    if (name == null) continue;
                    typeMembers.add((JSRecordType.TypeMember)new JSRecordTypeImpl.PropertySignatureImpl(name, TypeScriptTypeParser.buildTypeScriptFunctionTypeImpl(function), false, (PsiElement)function));
                    continue;
                }
                if (!(sourceElement instanceof JSClass)) continue;
                JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)sourceElement, true);
                String name = sourceElement.getName();
                if (name == null) continue;
                JSType type = JSNamedType.createType(name, source, JSContext.STATIC);
                typeMembers.add((JSRecordType.TypeMember)new JSRecordTypeImpl.PropertySignatureImpl(name, type, false, (PsiElement)sourceElement));
            }
            JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)element, true);
            return new JSRecordTypeImpl(source, typeMembers);
        }
        return null;
    }
}

