/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.primitives;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSDecoratedTypeImpl;
import com.intellij.lang.javascript.psi.types.JSSimpleTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSNullType
extends JSSimpleTypeBaseImpl {
    public JSNullType(JSTypeSource source) {
        super(source);
    }

    @NotNull
    public String getTypeText(JSType.TypeTextFormat format) {
        if (format == JSType.TypeTextFormat.CODE && this.isTypeScript()) {
            if ("any" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/primitives/JSNullType", "getTypeText"));
            }
            return "any";
        }
        if ("null" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/primitives/JSNullType", "getTypeText"));
        }
        return "null";
    }

    public boolean isDirectlyAssignableType(@Nullable JSType elementType, @Nullable ProcessingContext processingContext) {
        JSDecoratedTypeImpl decoratedType;
        if (elementType instanceof JSDecoratedTypeImpl && (decoratedType = (JSDecoratedTypeImpl)elementType).getDecorations().contains((Object)JSDecoratedTypeImpl.TypeDecoration.NULLABLE)) {
            return true;
        }
        if (this.getSource().getLanguage() == JSTypeSource.SourceLanguage.TS) {
            return true;
        }
        return JSTypeCastUtil.isDirectlyAssignableTypeCommon(this, elementType, processingContext).isAssignable();
    }

    public boolean isEquivalentTo(@Nullable JSType type, @Nullable ProcessingContext processingContext) {
        return type instanceof JSNullType || JSTypeCastUtil.isEquivalentCommon(this, type, processingContext);
    }

    @NotNull
    public JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/primitives/JSNullType", "copyWithNewSource"));
        }
        JSNullType jSNullType = new JSNullType(source);
        if (jSNullType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/primitives/JSNullType", "copyWithNewSource"));
        }
        return jSNullType;
    }
}

