/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptSingleType;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSRenameWrongRefHandler
implements RenameHandler {
    @NonNls
    private static final String INPUT_VARIABLE_NAME = "INPUTVAR";
    @NonNls
    private static final String OTHER_VARIABLE_NAME = "OTHERVAR";

    public final boolean isAvailableOnDataContext(DataContext dataContext) {
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (editor == null || file == null || project == null) {
            return false;
        }
        return JSRenameWrongRefHandler.isAvailable(editor);
    }

    public static boolean isAvailable(Editor editor) {
        ResolveResult[] results;
        PsiReference reference = TargetElementUtil.findReference((Editor)editor);
        if (!(reference instanceof JSReferenceExpression)) {
            return false;
        }
        for (ResolveResult result : results = ((JSReferenceExpression)reference).multiResolve(true)) {
            if (!result.isValidResult()) continue;
            return false;
        }
        return true;
    }

    public final boolean isRenaming(DataContext dataContext) {
        return this.isAvailableOnDataContext(dataContext);
    }

    public void invoke(final @NotNull Project project, final Editor editor, final PsiFile file, @Nullable DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/refactoring/JSRenameWrongRefHandler", "invoke"));
        }
        PsiReference reference = TargetElementUtil.findReference((Editor)editor);
        final JSReferenceExpression refExpr = JSPsiImplUtils.findReferenceOfClass(reference, JSReferenceExpression.class);
        if (refExpr == null) {
            Logger.getInstance(JSRenameWrongRefHandler.class).error("JSReferenceExpression was not found");
            return;
        }
        new WriteCommandAction(project, new PsiFile[0]){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/refactoring/JSRenameWrongRefHandler$1", "run"));
                }
                if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
                    return;
                }
                PsiElement scope = PsiTreeUtil.getParentOfType((PsiElement)refExpr, (Class[])new Class[]{JSFunction.class, JSFile.class, JSEmbeddedContent.class});
                if (scope == null) {
                    return;
                }
                ArrayList declarations = new ArrayList();
                JSReferenceExpression[] refs = JSRenameWrongRefHandler.collectSimilarReferencesAndDeclarations(refExpr, scope, declarations);
                Expression expression = JSRenameWrongRefHandler.createExpression(refExpr.getReferenceName(), JSRenameWrongRefHandler.filterDeclarations(refExpr, declarations));
                TemplateBuilderImpl builder = new TemplateBuilderImpl(scope);
                for (JSReferenceExpression expr : refs) {
                    if (!expr.equals(refExpr)) {
                        builder.replaceElement(expr.getReferenceNameElement(), JSRenameWrongRefHandler.OTHER_VARIABLE_NAME, JSRenameWrongRefHandler.INPUT_VARIABLE_NAME, false);
                        continue;
                    }
                    builder.replaceElement(expr.getReferenceNameElement(), JSRenameWrongRefHandler.INPUT_VARIABLE_NAME, expression, true);
                }
                float proportion = EditorUtil.calcVerticalScrollProportion((Editor)editor);
                editor.getCaretModel().moveToOffset(scope.getTextRange().getStartOffset());
                Template template = builder.buildInlineTemplate();
                editor.getCaretModel().moveToOffset(scope.getTextRange().getStartOffset());
                TemplateManager.getInstance((Project)project).startTemplate(editor, template);
                EditorUtil.setVerticalScrollProportion((Editor)editor, (float)proportion);
            }
        }.execute();
    }

    @NotNull
    private static List<JSNamedElement> filterDeclarations(@NotNull JSReferenceExpression expr, @NotNull List<JSNamedElement> declarations) {
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/intellij/lang/javascript/refactoring/JSRenameWrongRefHandler", "filterDeclarations"));
        }
        if (declarations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarations", "com/intellij/lang/javascript/refactoring/JSRenameWrongRefHandler", "filterDeclarations"));
        }
        final PsiElement parent = JSResolveUtil.getTopReferenceParent((PsiElement)expr);
        final boolean isTypeContext = parent instanceof JSReferenceListMember || parent instanceof TypeScriptSingleType;
        final JSClass contextClass = parent instanceof JSReferenceListMember ? (JSClass)PsiTreeUtil.getParentOfType((PsiElement)parent, JSClass.class) : null;
        List list = ContainerUtil.filter(declarations, (Condition)new Condition<JSNamedElement>(){

            public boolean value(JSNamedElement element) {
                if (isTypeContext) {
                    if (element instanceof JSClass && element.getName() != null) {
                        boolean expectInterfaces;
                        boolean bl = expectInterfaces = contextClass != null && contextClass.isInterface();
                        if (contextClass != null && !expectInterfaces) {
                            JSReferenceList referenceList = (JSReferenceList)PsiTreeUtil.getParentOfType((PsiElement)parent, JSReferenceList.class);
                            assert (referenceList != null);
                            expectInterfaces = JSStubElementTypes.IMPLEMENTS_LIST.equals((Object)referenceList.getNode().getElementType());
                        }
                        return contextClass == null || contextClass != element && expectInterfaces == ((JSClass)element).isInterface();
                    }
                    return false;
                }
                return !(element instanceof JSClass);
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/JSRenameWrongRefHandler", "filterDeclarations"));
        }
        return list;
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/refactoring/JSRenameWrongRefHandler", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/lang/javascript/refactoring/JSRenameWrongRefHandler", "invoke"));
        }
    }

    private static JSReferenceExpression[] collectSimilarReferencesAndDeclarations(final JSReferenceExpression ref, PsiElement scope, final List<JSNamedElement> declarations) {
        boolean isQualified;
        final String refName = ref.getReferenceName();
        final ArrayList<JSReferenceExpression> similarRefs = new ArrayList<JSReferenceExpression>();
        similarRefs.add(ref);
        boolean bl = isQualified = ref.getQualifier() != null;
        if (refName != null) {
            JSRecursiveElementVisitor visitor = new JSRecursiveElementVisitor(){

                public void visitJSReferenceExpression(JSReferenceExpression node) {
                    if (node == ref || !isQualified && node.getQualifier() == null && refName.equals(node.getReferenceName())) {
                        similarRefs.add(node);
                    }
                    if (node.getFirstChild() instanceof JSReferenceExpression) {
                        this.visitJSReferenceExpression((JSReferenceExpression)node.getFirstChild());
                    }
                }

                public void visitJSFunctionDeclaration(JSFunction node) {
                    declarations.add(node);
                    PsiElement identifier = node.getNameIdentifier();
                    if (identifier instanceof JSReferenceExpression) {
                        this.visitJSReferenceExpression((JSReferenceExpression)identifier);
                    }
                }

                public void visitJSFunctionExpression(JSFunctionExpression node) {
                    declarations.add(node);
                }

                public void visitJSVariable(JSVariable node) {
                    declarations.add(node);
                    super.visitJSVariable(node);
                }

                public void visitJSClass(JSClass aClass) {
                    declarations.add(aClass);
                    super.visitJSClass(aClass);
                }

                public void visitJSDefinitionExpression(JSDefinitionExpression node) {
                    declarations.add(node);
                    super.visitJSDefinitionExpression(node);
                }
            };
            visitor.visitElement(scope);
        }
        return similarRefs.toArray(new JSReferenceExpression[similarRefs.size()]);
    }

    private static Expression createExpression(final String oldRefName, List<JSNamedElement> declarations) {
        ArrayList<LookupElementBuilder> itemsList = new ArrayList<LookupElementBuilder>(declarations.size());
        for (JSNamedElement declaration : declarations) {
            String name = declaration.getName();
            if (name == null) continue;
            itemsList.add(LookupElementBuilder.create((String)name));
        }
        final LookupElement[] myItems = new LookupElement[itemsList.size()];
        itemsList.toArray(myItems);
        return new Expression(){

            public com.intellij.codeInsight.template.Result calculateResult(ExpressionContext context) {
                if (myItems.length == 0) {
                    return new TextResult(oldRefName);
                }
                return new TextResult(myItems[0].getLookupString());
            }

            public com.intellij.codeInsight.template.Result calculateQuickResult(ExpressionContext context) {
                return null;
            }

            public LookupElement[] calculateLookupItems(ExpressionContext context) {
                return myItems;
            }
        };
    }
}

