/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.changeSignature;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSDocTokenTypes;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTag;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.refactoring.changeSignature.JSChangeSignatureDialog;
import com.intellij.lang.javascript.refactoring.changeSignature.JSChangeSignatureProcessor;
import com.intellij.lang.javascript.refactoring.changeSignature.JSParameterInfo;
import com.intellij.lang.javascript.refactoring.introduceParameter.JSIntroduceParameterHandler;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.MultiMap;
import gnu.trove.TIntHashSet;
import gnu.trove.decorator.TIntHashSetDecorator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JSChangeSignatureUtil {
    public static void setParameters(JSFunction function, MultiMap<JSParameter, UsageInfo> paramsUsages, Collection<PsiFile> filesToOptimizeImports, JSLanguageDialect lang, JSParameterInfo ... parameters) {
        PsiComment docComment;
        PsiElement prev;
        List<Object> newParameters;
        boolean isArrowFunction;
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        JSParameterList oldParamList = function.getParameterList();
        String currentPackage = JSResolveUtil.getPackageNameFromPlace((PsiElement)function);
        HashSet imports = new HashSet();
        for (JSParameterInfo p : parameters) {
            String type;
            if (p.getOldIndex() != -1) {
                JSChangeSignatureProcessor.LOG.assertTrue(oldParamList.getParameters().length > p.getOldIndex());
                JSChangeSignatureUtil.rename(oldParamList.getParameters()[p.getOldIndex()], p.getName(), paramsUsages);
            }
            if ((type = p.getTypeText()) != null && !JSRefactoringUtil.isEllipsisType(type) && type.contains(".") && JSPsiImplUtils.differentPackageName(StringUtil.getPackageName((String)type), currentPackage)) {
                imports.add(type);
            }
            if (!StringUtil.isNotEmpty((String)p.getInitializer())) continue;
            JSChangeSignatureProcessor.computeRequiredImportStatements(p.getInitializer(), (PsiElement)function, (Collection<String>)imports);
        }
        DialectOptionHolder holder = lang != null ? lang.getOptionHolder() : null;
        boolean bl = isArrowFunction = JSPsiImplUtils.isArrowFunction(function) != null;
        if (parameters.length > 0) {
            StringBuilder b = new StringBuilder("function dummy");
            JSChangeSignatureDialog.buildParameterListText(Arrays.asList(parameters), b, !isArrowFunction, holder);
            b.append(";");
            JSFunction dummy = (JSFunction)JSChangeUtil.createJSTreeFromText(function.getProject(), b.toString(), lang).getPsi();
            newParameters = Arrays.asList(dummy.getParameterList().getParameters());
        } else {
            newParameters = Collections.emptyList();
        }
        for (int i = 0; i < newParameters.size(); ++i) {
            if (i < oldParamList.getParameters().length) {
                oldParamList.getParameters()[i].replace((PsiElement)newParameters.get(i));
                continue;
            }
            if (i > 0) {
                if (isArrowFunction) {
                    oldParamList = JSChangeSignatureUtil.addParenthesisIfNeeded(oldParamList);
                }
                JSChangeSignatureUtil.addComma((PsiElement)oldParamList);
            }
            oldParamList.addBefore((PsiElement)newParameters.get(i), oldParamList.getLastChild());
        }
        while (oldParamList.getParameters().length > newParameters.size()) {
            PsiElement prev2;
            JSParameter parameter;
            JSParameter removeFrom = parameter = oldParamList.getParameters()[newParameters.size()];
            while (removeFrom.getNode().getElementType() != JSTokenTypes.COMMA && (prev2 = removeFrom.getPrevSibling()) != null && prev2.getNode().getElementType() != JSTokenTypes.LPAR) {
                removeFrom = prev2;
            }
            oldParamList.deleteChildRange((PsiElement)removeFrom, (PsiElement)parameter);
        }
        if (isArrowFunction) {
            if (oldParamList.getParameters().length == 1) {
                oldParamList = oldParamList.getParameters()[0].getInitializer() == null ? JSChangeSignatureUtil.removeParenthesis(oldParamList) : JSChangeSignatureUtil.addParenthesisIfNeeded(oldParamList);
            } else if (oldParamList.getParameters().length == 0) {
                oldParamList = JSChangeSignatureUtil.addParenthesisIfNeeded(oldParamList);
            }
        }
        int startOffset = (prev = oldParamList.getPrevSibling()) != null ? prev.getTextRange().getStartOffset() : oldParamList.getTextRange().getStartOffset();
        int endOffset = oldParamList.getTextRange().getEndOffset();
        CodeStyleManager.getInstance((Project)function.getProject()).reformatText(function.getContainingFile(), startOffset, endOffset);
        JSLanguageDialect dialect = DialectDetector.getLanguageDialect((PsiElement)function);
        for (int i = parameters.length - 1; i >= 0; --i) {
            if (!parameters[i].isOptional() || holder != null && holder.isTypeScript) continue;
            JSIntroduceParameterHandler.addOptionalParameterInitializer(function, dialect, ((JSParameter)newParameters.get(i)).getName(), parameters[i].getDefaultValue(), null);
        }
        if (!imports.isEmpty()) {
            PsiFile file = function.getContainingFile();
            FormatFixer formatFixer = ImportUtils.insertImportStatements((PsiElement)function, (Collection<String>)imports);
            if (formatFixer != null) {
                formatFixer.fixFormat();
            }
            filesToOptimizeImports.add(file);
        }
        if ((docComment = JSDocumentationUtils.findDocComment((PsiElement)function)) instanceof JSDocComment) {
            JSChangeSignatureUtil.updateJSDocParameters(function, (JSDocComment)docComment);
        }
    }

    private static void updateJSDocParameters(JSFunction newFunction, JSDocComment docComment) {
        final Map<Integer, Integer> map = JSDocumentationUtils.getTagToParameterMap(docComment, newFunction, null);
        ArrayList<Integer> currentTagOrder = new ArrayList<Integer>(map.size());
        ArrayList<Integer> requiredTagOrder = new ArrayList<Integer>(map.size());
        for (Map.Entry<Integer, Integer> entry : map.entrySet()) {
            currentTagOrder.add(entry.getKey());
            if (entry.getValue() == -1 || entry.getValue() == Integer.MAX_VALUE) continue;
            requiredTagOrder.add(entry.getKey());
        }
        ContainerUtil.sort(currentTagOrder);
        ContainerUtil.sort(requiredTagOrder, (Comparator)new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return ((Integer)map.get(o1)).compareTo((Integer)map.get(o2));
            }
        });
        ArrayList<Pair<Integer, String>> tagsToCreate = new ArrayList<Pair<Integer, String>>();
        TIntHashSetDecorator tagsToRemove = new TIntHashSetDecorator(new TIntHashSet());
        int requiredTagOrderIndex = 0;
        JSDocTag[] tags = docComment.getTags();
        for (int currentTagOrderIndex = 0; currentTagOrderIndex < currentTagOrder.size(); ++currentTagOrderIndex) {
            if (requiredTagOrderIndex < requiredTagOrder.size() && ((Integer)currentTagOrder.get(currentTagOrderIndex)).equals(requiredTagOrder.get(requiredTagOrderIndex))) {
                ++requiredTagOrderIndex;
                continue;
            }
            tagsToRemove.add(currentTagOrder.get(currentTagOrderIndex));
            for (int associatedTag = currentTagOrderIndex + 1; !map.containsKey(associatedTag) && associatedTag < tags.length && "param".equals(tags[associatedTag].getName()); ++associatedTag) {
                tagsToRemove.add(associatedTag);
            }
        }
        int insertionIndex = (Integer)currentTagOrder.get(currentTagOrder.size() - 1) + 1;
        while (requiredTagOrderIndex < requiredTagOrder.size()) {
            int requiredTagIndex = (Integer)requiredTagOrder.get(requiredTagOrderIndex);
            JSDocTag requiredTag = tags[requiredTagIndex];
            tagsToCreate.add((Pair<Integer, String>)Pair.create((Object)insertionIndex, (Object)JSChangeSignatureUtil.getTagTextWithComment(requiredTag)));
            for (int associatedTag = requiredTagIndex + 1; !map.containsKey(associatedTag) && associatedTag < tags.length && "param".equals(tags[associatedTag].getName()); ++associatedTag) {
                JSChangeSignatureUtil.getTagTextWithComment(tags[associatedTag]);
                tagsToCreate.add((Pair<Integer, String>)Pair.create((Object)insertionIndex, (Object)JSChangeSignatureUtil.getTagTextWithComment(tags[associatedTag])));
            }
            ++requiredTagOrderIndex;
        }
        if (!tagsToRemove.isEmpty() || !tagsToCreate.isEmpty()) {
            PsiFile file = docComment.getContainingFile();
            JSDocumentationUtils.createOrUpdateTagsWithInsertionIndexes((PsiElement)docComment, tagsToCreate, null, (Set<Integer>)tagsToRemove);
            Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
            if (document != null) {
                PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(document);
            }
        }
    }

    private static String getTagTextWithComment(JSDocTag requiredTag) {
        StringBuilder tagText = new StringBuilder(requiredTag.getText().substring(1));
        for (ASTNode node = requiredTag.getNode().getTreeNext(); node != null && (node.getElementType() == JSDocTokenTypes.DOC_COMMENT_DATA || node.getElementType() == JSTokenTypes.WHITE_SPACE && node.getTreeNext() != null && node.getTreeNext().getElementType() == JSDocTokenTypes.DOC_COMMENT_DATA); node = node.getTreeNext()) {
            tagText.append(node.getText());
        }
        return tagText.toString();
    }

    private static void rename(@NotNull JSParameter parameter, @NotNull String newName, @NotNull MultiMap<JSParameter, UsageInfo> paramsUsages) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/lang/javascript/refactoring/changeSignature/JSChangeSignatureUtil", "rename"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/lang/javascript/refactoring/changeSignature/JSChangeSignatureUtil", "rename"));
        }
        if (paramsUsages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paramsUsages", "com/intellij/lang/javascript/refactoring/changeSignature/JSChangeSignatureUtil", "rename"));
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (newName.equals(parameter.getName())) {
            return;
        }
        parameter.setName(newName);
        for (UsageInfo parameterUsage : paramsUsages.get((Object)parameter)) {
            if (parameterUsage.getElement() instanceof JSReferenceExpression) {
                ((JSReferenceExpression)parameterUsage.getElement()).bindToElement((PsiElement)parameter);
                continue;
            }
            if (parameterUsage.getReference() == null) continue;
            parameterUsage.getReference().handleElementRename(newName);
        }
    }

    private static JSParameterList addParenthesisIfNeeded(@NotNull JSParameterList paramList) {
        if (paramList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paramList", "com/intellij/lang/javascript/refactoring/changeSignature/JSChangeSignatureUtil", "addParenthesisIfNeeded"));
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        PsiElement lastChild = paramList.getLastChild();
        if (lastChild != null && lastChild.getNode().getElementType() == JSTokenTypes.RPAR) {
            return paramList;
        }
        String text = "function dummy(" + paramList.getText() + "){}";
        PsiElement root = JSChangeUtil.createJSTreeFromText(paramList.getProject(), text).getPsi();
        return (JSParameterList)paramList.replace((PsiElement)((JSFunction)root).getParameterList());
    }

    public static JSParameterList removeParenthesis(@NotNull JSParameterList paramList) {
        if (paramList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paramList", "com/intellij/lang/javascript/refactoring/changeSignature/JSChangeSignatureUtil", "removeParenthesis"));
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        String text = paramList.getText();
        text = StringUtil.trimStart((String)text, (String)"(");
        text = StringUtil.trimEnd((String)text, (String)")");
        text = "let dummy = " + text + " -> x";
        PsiElement root = JSChangeUtil.createJSTreeFromText(paramList.getProject(), text, JavaScriptSupportLoader.ECMA_SCRIPT_6).getPsi();
        JSExpression initializer = ((JSVarStatement)root).getVariables()[0].getInitializer();
        return (JSParameterList)paramList.replace((PsiElement)((JSFunction)initializer).getParameterList());
    }

    public static void addComma(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/refactoring/changeSignature/JSChangeSignatureUtil", "addComma"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        element.addBefore(JSChangeUtil.createCommaPsiElement(element.getProject()), element.getLastChild());
    }
}

