/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.inline;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSNamedElementKind;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.refactoring.HighlightingUtils;
import com.intellij.lang.javascript.refactoring.inline.FunctionInliner;
import com.intellij.lang.javascript.refactoring.inline.VarOrFieldInliner;
import com.intellij.lang.refactoring.InlineHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.inline.InlineOptionsDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringMessageDialog;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSInlineHandler
implements InlineHandler {
    public InlineHandler.Settings prepareInlineElement(@NotNull PsiElement element, Editor editor, boolean invokedOnReference) {
        JSFunction function;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/refactoring/inline/JSInlineHandler", "prepareInlineElement"));
        }
        InlineHandler.Settings settings = null;
        final PsiElement elementFinal = element;
        NotNullLazyValue<Collection<PsiReference>> deferredUsages = new NotNullLazyValue<Collection<PsiReference>>(){

            @NotNull
            protected Collection<PsiReference> compute() {
                final ArrayList<PsiReference> referenceCollection = new ArrayList<PsiReference>();
                ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

                    @Override
                    public void run() {
                        SearchScope useScope = (SearchScope)ApplicationManager.getApplication().runReadAction((Computable)new Computable<SearchScope>(){

                            public SearchScope compute() {
                                return elementFinal.getUseScope();
                            }
                        });
                        ReferencesSearch.search((PsiElement)elementFinal, (SearchScope)useScope).forEach((Processor)new Processor<PsiReference>(){

                            public boolean process(PsiReference psiReference) {
                                if (psiReference.getElement().getParent() != elementFinal) {
                                    referenceCollection.add(psiReference);
                                }
                                return true;
                            }
                        });
                    }
                }, JSBundle.message((String)"javascript.refactoring.searching.usages", (Object[])new Object[0]), false, elementFinal.getProject());
                ArrayList<PsiReference> arrayList = referenceCollection;
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/inline/JSInlineHandler$1", "compute"));
                }
                return arrayList;
            }
        };
        if (!(element instanceof JSVariable) && (function = JSPsiImplUtils.getPossibleFunction(element)) != null) {
            element = function;
        }
        boolean isSelfReference = false;
        if (editor != null) {
            PsiReference ref = TargetElementUtil.findReference((Editor)editor);
            boolean bl = isSelfReference = ref instanceof JSReferenceExpression && JSResolveUtil.isSelfReference((PsiElement)((JSReferenceExpression)ref));
        }
        if (element instanceof JSVariable) {
            settings = VarOrFieldInliner.handleVariable(element, editor, invokedOnReference, deferredUsages, isSelfReference);
        } else if (element instanceof JSFunction) {
            settings = FunctionInliner.handleFunction(element, editor, invokedOnReference, deferredUsages, isSelfReference);
        } else if (element instanceof JSClass) {
            PsiReference invocationReference;
            PsiReference psiReference = invocationReference = editor != null ? TargetElementUtil.findReference((Editor)editor) : null;
            if (invocationReference != null && invocationReference.getElement() instanceof JSReferenceExpression && invocationReference.getElement().getParent() instanceof JSCallExpression) {
                FunctionInliner.inlineFunctionProblem(JSBundle.message((String)"javascript.refactoring.cannot.inline.constructor", (Object[])new Object[0]), editor, element.getProject());
                settings = InlineHandler.Settings.CANNOT_INLINE_SETTINGS;
            }
        }
        if (settings != null && settings != InlineHandler.Settings.CANNOT_INLINE_SETTINGS) {
            Collection value = (Collection)deferredUsages.getValue();
            String elementKind = JSBundle.message((String)JSNamedElementKind.kind((JSNamedElement)element).humanReadableKey(), (Object[])new Object[0]);
            String elementName = ((JSNamedElement)element).getName();
            int occurenceCount = value.size();
            if (occurenceCount == 0) {
                settings = InlineHandler.Settings.CANNOT_INLINE_SETTINGS;
                CommonRefactoringUtil.showErrorHint((Project)element.getProject(), (Editor)editor, (String)JSBundle.message((String)"javascript.inline.element.is.not.used", (Object[])new Object[]{elementKind, elementName}), (String)"Inline", null);
            } else if (!ApplicationManager.getApplication().isUnitTestMode()) {
                if (editor != null) {
                    ArrayList<PsiReference> referencesToHighlightFromCurrentEditor = new ArrayList<PsiReference>();
                    VirtualFile file = JSInlineHandler.getPhysicalFileOfEditor(editor);
                    for (PsiReference ref : (Collection)deferredUsages.getValue()) {
                        if (!Comparing.equal((Object)file, (Object)JSInlineHandler.getVirtualFile(ref.getElement().getContainingFile()))) continue;
                        referencesToHighlightFromCurrentEditor.add(ref);
                    }
                    ((JSInlineSettingsBase)settings).highlightUsages(editor, referencesToHighlightFromCurrentEditor);
                }
                String kind = StringUtil.decapitalize((String)elementKind);
                String inlineTitle = JSBundle.message((String)"inline.0.dialog.title", (Object[])new Object[]{StringUtil.capitalizeWords((String)elementKind, (boolean)true)});
                String inlineAllMessage = "Inline " + kind + " '" + elementName + "'" + (!settings.isOnlyOneReferenceToInline() ? "?" : "") + " (" + occurenceCount + " occurrence" + (occurenceCount > 1 ? "s" : "") + ")";
                Object dialog = settings.isOnlyOneReferenceToInline() ? new JSInlineOptionsDialog(element.getProject(), element, (JSInlineSettingsBase)settings, inlineTitle, inlineAllMessage + (element.isWritable() ? " and remove the " + kind : ""), "Inline this usage and keep the " + kind, elementKind + " '" + elementName + "'") : new RefactoringMessageDialog(inlineTitle, inlineAllMessage, null, "OptionPane.questionIcon", true, element.getProject());
                if (!dialog.showAndGet()) {
                    settings = InlineHandler.Settings.CANNOT_INLINE_SETTINGS;
                    if (dialog instanceof JSInlineOptionsDialog) {
                        ((JSInlineSettingsBase)settings).setOneRefToInline(((JSInlineOptionsDialog)((Object)dialog)).isInlineThisOnly());
                    }
                } else if (dialog instanceof JSInlineOptionsDialog) {
                    ((JSInlineSettingsBase)settings).setOneRefToInline(((JSInlineOptionsDialog)((Object)dialog)).isInlineThisOnly());
                }
            }
        }
        return settings;
    }

    static VirtualFile getPhysicalFileOfEditor(Editor editor) {
        PsiFile psifile = PsiDocumentManager.getInstance((Project)editor.getProject()).getPsiFile(editor.getDocument());
        return JSInlineHandler.getVirtualFile(psifile);
    }

    static VirtualFile getVirtualFile(PsiFile psifile) {
        VirtualFile file = psifile.getVirtualFile();
        if (file instanceof VirtualFileWindow) {
            file = ((VirtualFileWindow)file).getDelegate();
        }
        return file;
    }

    public void removeDefinition(PsiElement element, InlineHandler.Settings _settings) {
        JSInlineSettingsBase settings = (JSInlineSettingsBase)_settings;
        if (element instanceof JSVariable) {
            VarOrFieldInliner.removeDefinition(element, (VarOrFieldInliner.MySettings)settings);
        } else {
            ASTNode prev;
            PsiElement whitespace;
            if (element instanceof JSFunction && element.getParent() instanceof JSClass && (whitespace = (prev = element.getNode().getTreePrev()).getPsi()) instanceof PsiWhiteSpace) {
                whitespace.delete();
            }
            element.delete();
        }
        if (settings.editor != null) {
            HighlightingUtils.highlightOccurrences(settings.editor.getProject(), settings.editor, new HighlightingUtils.RangesOccurrenceInfoSource(settings.myHighlightedMarkers));
        }
    }

    public InlineHandler.Inliner createInliner(PsiElement element, InlineHandler.Settings settings) {
        if (element instanceof JSVariable) {
            return new VarOrFieldInliner(element, (VarOrFieldInliner.MySettings)settings);
        }
        JSFunction function = JSPsiImplUtils.getPossibleFunction(element);
        if (function != null) {
            return new FunctionInliner(element, (JSInlineSettingsBase)settings);
        }
        return null;
    }

    static void addThisReference(PsiElement node, PsiElement qualifier, PsiElement psiElement, int funOffset, Set<RangeMarker> thisRefs, Document document) {
        if ((psiElement instanceof JSFunction || psiElement instanceof JSVariable) && JSResolveUtil.findParent(psiElement) instanceof JSClass) {
            if (psiElement instanceof JSFunction && ((JSFunction)psiElement).isConstructor()) {
                return;
            }
            JSInlineHandler.doAddThisReference(node, qualifier, funOffset, thisRefs, document);
        }
    }

    static void doAddThisReference(PsiElement node, PsiElement qualifier, int funOffset, Set<RangeMarker> thisRefs, Document document) {
        TextRange range;
        if (qualifier != null) {
            range = qualifier.getTextRange().shiftRight(funOffset);
        } else {
            int offset = node.getTextRange().getStartOffset() + funOffset;
            range = new TextRange(offset, offset);
        }
        thisRefs.add(document.createRangeMarker(range));
    }

    private static class JSInlineOptionsDialog
    extends InlineOptionsDialog {
        private InlineHandler.Settings mySettings;
        private String myInlineAllText;
        private String myInlineThisText;
        private String myNameLabelText;

        protected JSInlineOptionsDialog(Project project, PsiElement element, JSInlineSettingsBase settings, String title, String inlineAllText, String inlineThisText, String nameLabelText) {
            super(project, true, element);
            this.mySettings = settings;
            this.myInlineAllText = inlineAllText;
            this.myInlineThisText = inlineThisText;
            this.myNameLabelText = nameLabelText;
            this.myInvokedOnReference = !settings.isSelfReference();
            this.setTitle(title);
            this.init();
        }

        protected String getNameLabelText() {
            return this.myNameLabelText;
        }

        protected String getBorderTitle() {
            return "Inline";
        }

        protected String getInlineAllText() {
            return this.myInlineAllText;
        }

        protected String getInlineThisText() {
            return this.myInlineThisText;
        }

        protected boolean isInlineThis() {
            return this.mySettings.isOnlyOneReferenceToInline();
        }

        protected void doAction() {
            this.close(0);
        }

        protected boolean hasHelpAction() {
            return false;
        }

        protected boolean hasPreviewButton() {
            return false;
        }
    }

    public static class JSInlineSettingsBase
    implements InlineHandler.Settings {
        final List<RangeMarker> myHighlightedMarkers = new ArrayList<RangeMarker>();
        @Nullable
        final Editor editor;
        private boolean myOneRefToInline;
        private final PsiFile myFile;
        private final boolean myIsSelfReference;

        public JSInlineSettingsBase(boolean oneRefToInline, PsiFile file, @Nullable Editor editor, boolean isSelfReference) {
            this.myOneRefToInline = oneRefToInline;
            this.myFile = file;
            this.myIsSelfReference = isSelfReference;
            this.editor = editor != null ? InjectedLanguageUtil.getInjectedEditorForInjectedFile((Editor)editor, (PsiFile)file) : null;
        }

        public void addRangeHighlighterForPsiElement(PsiElement element) {
            if (this.editor != null && element.getContainingFile() == this.myFile) {
                this.myHighlightedMarkers.add(this.editor.getDocument().createRangeMarker(element.getTextRange()));
            }
        }

        public boolean isOnlyOneReferenceToInline() {
            return this.myOneRefToInline;
        }

        public void setOneRefToInline(boolean oneRefToInline) {
            this.myOneRefToInline = oneRefToInline;
        }

        public void highlightUsages(Editor editor, Collection<PsiReference> refs) {
            ArrayList<PsiElement> refsToHighlight = new ArrayList<PsiElement>();
            for (PsiReference ref : refs) {
                refsToHighlight.add(ref.getElement());
            }
            Project project = editor.getProject();
            HighlightingUtils.doHighlightOccurences(project, editor, new HighlightingUtils.PsiElementsOccurrenceInfoSource(PsiUtilCore.toPsiElementArray(refsToHighlight)), false);
            HighlightingUtils.informThatHighlightingCanbeRemoved(project);
        }

        public boolean isSelfReference() {
            return this.myIsSelfReference;
        }
    }
}

