/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.introduceParameter;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.psi.JSElementFactory;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.refactoring.introduce.BasicIntroducedEntityInfoProvider;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseIntroduceDialog;
import com.intellij.lang.javascript.refactoring.introduceParameter.JSIntroduceParameterSettings;
import com.intellij.lang.javascript.validation.fixes.JSParameterInserter;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.ui.NameSuggestionsField;
import com.intellij.ui.EditorComboBox;
import com.intellij.ui.LanguageTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.xdebugger.XDebuggerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSIntroduceParameterDialog
extends JSBaseIntroduceDialog<BasicIntroducedEntityInfoProvider>
implements JSIntroduceParameterSettings {
    private JPanel myPanel;
    private EditorComboBox myVarType;
    private JLabel myNameLabel;
    private NameSuggestionsField myNameField;
    private JCheckBox myReplaceAllCheckBox;
    private JCheckBox myOptionalParameter;
    private JLabel myValueLabel;
    private JPanel myIntroducedParameterValuePanel;
    private JLabel myVarTypeText;
    private final LanguageTextField myIntroducedParameterValue;
    private final JSFunction myFunction;
    private final boolean myEcmaScriptLevel4;

    protected JSIntroduceParameterDialog(@NotNull Project project, JSExpression[] occurrences, JSExpression mainOccurrence, String initialValue, final JSFunction function) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/refactoring/introduceParameter/JSIntroduceParameterDialog", "<init>"));
        }
        super(project, new BasicIntroducedEntityInfoProvider(mainOccurrence, occurrences, (PsiElement)function), "javascript.introduce.parameter.title");
        this.$$$setupUI$$$();
        final PsiFile containingFile = mainOccurrence.getContainingFile();
        this.myEcmaScriptLevel4 = containingFile.getLanguage().isKindOf((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4);
        this.myVarType.setVisible(this.myEcmaScriptLevel4);
        this.myVarTypeText.setVisible(this.myEcmaScriptLevel4);
        this.myIntroducedParameterValue = new LanguageTextField((Language)JavascriptLanguage.INSTANCE, project, initialValue, new LanguageTextField.DocumentCreator(){

            public Document createDocument(String value, @Nullable Language language, Project project) {
                VirtualFile contextVirtualFile = containingFile.getVirtualFile();
                PsiElement context = null;
                if (contextVirtualFile != null) {
                    context = XDebuggerUtil.getInstance().findContextElement(contextVirtualFile, function.getTextOffset(), project, true);
                }
                return PsiDocumentManager.getInstance((Project)project).getDocument((PsiFile)JSElementFactory.createExpressionCodeFragment(project, value, context));
            }
        });
        boolean mustBeOptional = JSParameterInserter.build(function.getFirstChild()).mustBeOptional();
        if (mustBeOptional) {
            this.myOptionalParameter.setEnabled(false);
        }
        this.myIntroducedParameterValuePanel.add((Component)this.myIntroducedParameterValue, "Center");
        this.myValueLabel.setLabelFor((Component)this.myIntroducedParameterValue);
        this.myFunction = function;
        this.doInit();
    }

    @Override
    protected NameSuggestionsField getNameField() {
        return this.myNameField;
    }

    @Override
    protected JLabel getNameLabel() {
        return this.myNameLabel;
    }

    @Override
    protected JPanel getPanel() {
        return this.myPanel;
    }

    @Override
    protected JCheckBox getReplaceAllCheckBox() {
        return this.myReplaceAllCheckBox;
    }

    @Override
    public JComboBox getVarTypeField() {
        return this.myVarType;
    }

    private void createUIComponents() {
        this.myNameField = this.configureNameField();
        this.myVarType = this.configureTypeField();
    }

    @Override
    public boolean addOptionalParameter() {
        return this.myOptionalParameter.isSelected();
    }

    @Override
    public String getInitialValue() {
        return this.myIntroducedParameterValue.getText();
    }

    @Override
    public JSFunction functionForIntroduceParameter() {
        return this.myFunction;
    }

    protected String getHelpId() {
        return this.myEcmaScriptLevel4 ? "refactoring.introduceParameter.ActionScript" : "refactoring.introduceParameter.JavaScript";
    }

    @Override
    public boolean addJsDoc() {
        return false;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JLabel jLabel;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JLabel jLabel2;
        JLabel jLabel3;
        JPanel jPanel2;
        this.createUIComponents();
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myVarTypeText = jLabel3 = new JLabel();
        jLabel3.setText("Type:");
        jLabel3.setDisplayedMnemonic('T');
        jLabel3.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        EditorComboBox editorComboBox = this.myVarType;
        jPanel2.add((Component)editorComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myNameLabel = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("com/intellij/lang/javascript/JavaScriptBundle").getString("javascript.introduce.variable.name.prompt"));
        jLabel2.setRequestFocusEnabled(false);
        jPanel2.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        NameSuggestionsField nameSuggestionsField = this.myNameField;
        jPanel2.add((Component)nameSuggestionsField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myReplaceAllCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setActionCommand("");
        jCheckBox2.setMargin(new Insets(2, 0, 2, 0));
        jCheckBox2.setContentAreaFilled(false);
        jCheckBox2.setText("");
        jCheckBox2.setFocusable(false);
        jPanel2.add((Component)jCheckBox2, new GridConstraints(4, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myOptionalParameter = jCheckBox = new JCheckBox();
        jCheckBox.setActionCommand("");
        jCheckBox.setMargin(new Insets(2, 0, 2, 0));
        jCheckBox.setContentAreaFilled(false);
        jCheckBox.setText("Optional parameter");
        jCheckBox.setMnemonic('O');
        jCheckBox.setDisplayedMnemonicIndex(0);
        jCheckBox.setSelected(true);
        jCheckBox.setFocusable(false);
        jPanel2.add((Component)jCheckBox, new GridConstraints(3, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myValueLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("com/intellij/lang/javascript/JavaScriptBundle").getString("javascript.introduce.parameter.introduced.variable.value"));
        jLabel.setRequestFocusEnabled(false);
        jPanel2.add((Component)jLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myIntroducedParameterValuePanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(2, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        jLabel3.setLabelFor((Component)editorComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

