/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.search;

import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.search.JSClassSearch;
import com.intellij.psi.PsiElement;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import com.intellij.util.QueryFactory;
import org.jetbrains.annotations.NotNull;

public abstract class JSFunctionsSearch
implements QueryExecutor<JSFunction, SearchParameters> {
    private static final QueryFactory<JSFunction, SearchParameters> OVERRIDDEN_FUNCTIONS_QUERY_FACTORY = new QueryFactory();
    private static final QueryFactory<JSFunction, SearchParameters> IMPLEMENTING_FUNCTIONS_QUERY_FACTORY = new QueryFactory();

    public static Query<JSFunction> searchOverridingFunctions(JSFunction baseFunction, boolean checkDeepInheritance) {
        SearchParameters parameters = new SearchParameters(baseFunction, checkDeepInheritance);
        return OVERRIDDEN_FUNCTIONS_QUERY_FACTORY.createUniqueResultsQuery((Object)parameters);
    }

    public static Query<JSFunction> searchImplementingFunctions(JSFunction baseFunction, boolean checkDeepInheritance) {
        SearchParameters parameters = new SearchParameters(baseFunction, checkDeepInheritance);
        return IMPLEMENTING_FUNCTIONS_QUERY_FACTORY.createUniqueResultsQuery((Object)parameters);
    }

    public boolean execute(@NotNull SearchParameters queryParameters, final @NotNull Processor<JSFunction> consumer) {
        if (queryParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "com/intellij/lang/javascript/search/JSFunctionsSearch", "execute"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/lang/javascript/search/JSFunctionsSearch", "execute"));
        }
        final JSFunction baseFunction = queryParameters.getBaseFunction();
        final PsiElement clazz = JSResolveUtil.findParent((PsiElement)baseFunction);
        if (!(clazz instanceof JSClass)) {
            return true;
        }
        return this.makeQuery(queryParameters, clazz).forEach((Processor)new Processor<JSClass>(){

            public boolean process(JSClass jsClass) {
                JSFunction function = JSInheritanceUtil.findMethodInClass(baseFunction, jsClass, ((JSClass)clazz).isInterface() && !jsClass.isInterface());
                if (function != null && (jsClass instanceof TypeScriptInterface || JSInheritanceUtil.canHaveSuperMethod(function.getAttributeList()))) {
                    return consumer.process((Object)function);
                }
                return true;
            }
        });
    }

    protected abstract Query<JSClass> makeQuery(SearchParameters var1, PsiElement var2);

    static {
        OVERRIDDEN_FUNCTIONS_QUERY_FACTORY.registerExecutor((QueryExecutor)new JSFunctionsSearch(){

            @Override
            protected Query<JSClass> makeQuery(SearchParameters queryParameters, PsiElement parent) {
                return JSClassSearch.searchClassInheritors((JSClass)parent, queryParameters.isCheckDeepInheritance());
            }
        });
        IMPLEMENTING_FUNCTIONS_QUERY_FACTORY.registerExecutor((QueryExecutor)new ImplementingFunctionsSearch());
    }

    private static class ImplementingFunctionsSearch
    extends JSFunctionsSearch {
        private ImplementingFunctionsSearch() {
        }

        @Override
        protected Query<JSClass> makeQuery(SearchParameters queryParameters, PsiElement parent) {
            return JSClassSearch.searchInterfaceImplementations((JSClass)parent, true);
        }
    }

    public static class SearchParameters {
        private final JSFunction myBaseFunction;
        private final boolean myCheckDeepInheritance;

        public SearchParameters(JSFunction baseFunction, boolean checkDeepInheritance) {
            this.myBaseFunction = baseFunction;
            this.myCheckDeepInheritance = checkDeepInheritance;
        }

        public JSFunction getBaseFunction() {
            return this.myBaseFunction;
        }

        public boolean isCheckDeepInheritance() {
            return this.myCheckDeepInheritance;
        }
    }
}

