/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.settings;

import com.intellij.ide.browsers.BrowserFamily;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.settings.JSLanguageVersionModel;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EnumMap;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSRootConfigurationPanel {
    JPanel myMainPanel;
    JComboBox myJSLanguageVersion;
    private JPanel myBrowsersInfo;
    private JBCheckBox myPreferStrict;
    private JBCheckBox myOnlyTypeBasedCompletion;
    private EnumMap<BrowserFamily, JLabel> myBrowsersLabels = null;
    private JLabel myES6Label;

    public JSRootConfigurationPanel() {
        this.$$$setupUI$$$();
    }

    public JPanel getPanel() {
        return this.myMainPanel;
    }

    @NotNull
    public JSLanguageLevel getLanguageLevel() {
        JSLanguageLevel jSLanguageLevel = (JSLanguageLevel)((Object)this.myJSLanguageVersion.getModel().getSelectedItem());
        if (jSLanguageLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/settings/JSRootConfigurationPanel", "getLanguageLevel"));
        }
        return jSLanguageLevel;
    }

    private void createUIComponents() {
        this.myJSLanguageVersion = new ComboBox((ComboBoxModel)new JSLanguageVersionModel());
        this.myJSLanguageVersion.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ComboBoxModel model = ((JComboBox)e.getSource()).getModel();
                if (model instanceof JSLanguageVersionModel) {
                    JSLanguageVersionModel jsModel = (JSLanguageVersionModel)model;
                    JSLanguageLevel level = (JSLanguageLevel)((Object)jsModel.getSelectedItem());
                    JSRootConfigurationPanel.this.updateBrowsersInfo(level);
                }
            }
        });
        this.myBrowsersInfo = new JPanel();
        this.myES6Label = new JLabel(JSBundle.message((String)"js.language.version.not.supported.by.browsers", (Object[])new Object[0]));
        this.myBrowsersInfo.add(this.myES6Label);
        if (this.myBrowsersLabels == null) {
            this.myBrowsersLabels = new EnumMap(BrowserFamily.class);
            for (BrowserFamily browser : BrowserFamily.values()) {
                JLabel browserInfo = new JLabel("...", browser.getIcon(), 2);
                browserInfo.setToolTipText(browser.getName());
                this.myBrowsersInfo.add((Component)browserInfo, browser == BrowserFamily.FIREFOX ? 0 : -1);
                this.myBrowsersLabels.put(browser, browserInfo);
            }
        }
    }

    public void setLanguageLevel(JSLanguageLevel level) {
        this.myJSLanguageVersion.getModel().setSelectedItem((Object)level);
        this.updateBrowsersInfo(level);
    }

    public void setPreferStrict(boolean preferStrict) {
        this.myPreferStrict.setSelected(preferStrict);
    }

    public boolean isPreferStrict() {
        return this.myPreferStrict.isSelected();
    }

    public void setOnlyTypeBasedCompletion(boolean selected) {
        this.myOnlyTypeBasedCompletion.setSelected(selected);
    }

    public boolean getOnlyTypeBasedCompletion() {
        return this.myOnlyTypeBasedCompletion.isSelected();
    }

    private void updateBrowsersInfo(@Nullable JSLanguageLevel level) {
        EnumMap<BrowserFamily, String> supportedBrowsers = level == null ? new EnumMap<BrowserFamily, String>(BrowserFamily.class) : JSRootConfigurationPanel.getSupportedBrowsers(level);
        for (BrowserFamily browser : this.myBrowsersLabels.keySet()) {
            String versions = supportedBrowsers.get(browser);
            if (versions == null) {
                this.myBrowsersLabels.get(browser).setVisible(false);
                continue;
            }
            this.myBrowsersLabels.get(browser).setVisible(true);
            this.myBrowsersLabels.get(browser).setText(versions);
        }
        this.myES6Label.setVisible(level == JSLanguageLevel.ES6);
    }

    private static EnumMap<BrowserFamily, String> getSupportedBrowsers(JSLanguageLevel level) {
        EnumMap<BrowserFamily, String> result = new EnumMap<BrowserFamily, String>(BrowserFamily.class);
        switch (level) {
            case JS_1_5: {
                result.put(BrowserFamily.EXPLORER, "5.5+");
                result.put(BrowserFamily.CHROME, "1.0+");
                result.put(BrowserFamily.FIREFOX, "1.0+");
                result.put(BrowserFamily.OPERA, "6.0+");
                result.put(BrowserFamily.SAFARI, "3.0+");
                break;
            }
            case ES5: {
                result.put(BrowserFamily.EXPLORER, "9.0+");
                result.put(BrowserFamily.CHROME, "13.0+");
                result.put(BrowserFamily.FIREFOX, "4.0+");
                result.put(BrowserFamily.OPERA, "11.6+");
                result.put(BrowserFamily.SAFARI, "5.1+");
                break;
            }
            case JS_1_6: {
                result.put(BrowserFamily.FIREFOX, "1.5+");
                break;
            }
            case JS_1_7: {
                result.put(BrowserFamily.FIREFOX, "2.0+");
                break;
            }
            case JS_1_8: {
                result.put(BrowserFamily.FIREFOX, "3.0+");
                break;
            }
            case JS_1_8_5: {
                result.put(BrowserFamily.FIREFOX, "4.0+");
                break;
            }
            case ES6: 
            case JSX: 
            case NASHORN: 
            case FLOW: {
                break;
            }
            default: {
                assert (false) : "Not all possible dialects listed for supported browser versions";
                break;
            }
        }
        return result;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 4, new Insets(0, 0, 0, 0), -1, 15, false, false));
        jPanel.add((Component)jPanel2, "Center");
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("com/intellij/lang/javascript/JavaScriptBundle").getString("js.language.version.label"));
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myOnlyTypeBasedCompletion = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setToolTipText(ResourceBundle.getBundle("com/intellij/lang/javascript/JavaScriptBundle").getString("settings.javascript.only.type.based.completion.tooptip"));
        jBCheckBox2.setMargin(new Insets(0, 0, 0, 0));
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, ResourceBundle.getBundle("com/intellij/lang/javascript/JavaScriptBundle").getString("settings.javascript.only.type.based.completion"));
        jPanel2.add((Component)jBCheckBox2, new GridConstraints(2, 0, 1, 4, 8, 0, 0, 0, null, null, null));
        JPanel jPanel3 = this.myBrowsersInfo;
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 2, 1, 1, 0, 3, 3, 3, null, null, null));
        JComboBox jComboBox = this.myJSLanguageVersion;
        jPanel2.add((Component)jComboBox, new GridConstraints(0, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(3, 0, 1, 4, 0, 2, 1, 6, null, null, null));
        this.myPreferStrict = jBCheckBox = new JBCheckBox();
        jBCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, ResourceBundle.getBundle("com/intellij/lang/javascript/JavaScriptBundle").getString("settings.javascript.prefer.strict"));
        jPanel2.add((Component)jBCheckBox, new GridConstraints(1, 0, 1, 4, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

