/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.template.postfix;

import com.intellij.codeInsight.template.postfix.templates.StringBasedPostfixTemplate;
import com.intellij.lang.javascript.template.postfix.JSPostfixTemplateUtils;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLogPostfixTemplate
extends StringBasedPostfixTemplate {
    private static final String CONSOLE = "console";
    private static Condition<PsiElement> FILTER_FOR_CONSOLE_KEYWORD = new Condition<PsiElement>(){

        public boolean value(PsiElement element) {
            return !JSLogPostfixTemplate.CONSOLE.equals(element.getText());
        }
    };

    public JSLogPostfixTemplate() {
        super("log", "console.log(expr)", JSPostfixTemplateUtils.selectorTopmost((Condition<PsiElement>)Conditions.and(FILTER_FOR_CONSOLE_KEYWORD, JSPostfixTemplateUtils.DEFAULT_FILTER)));
    }

    @Nullable
    public String getTemplateString(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/template/postfix/JSLogPostfixTemplate", "getTemplateString"));
        }
        return "console.log($expr$)" + JSPostfixTemplateUtils.endTemplate(element);
    }
}

