/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.flex.ECMAScriptImportOptimizer;
import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class AddConstructorAndSuperInvocationFix
implements IntentionAction {
    private final JSClass myClass;
    private final JSFunction superConstructor;

    public AddConstructorAndSuperInvocationFix(@NotNull JSClass clazz, @NotNull JSFunction _superCall) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/lang/javascript/validation/fixes/AddConstructorAndSuperInvocationFix", "<init>"));
        }
        if (_superCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_superCall", "com/intellij/lang/javascript/validation/fixes/AddConstructorAndSuperInvocationFix", "<init>"));
        }
        this.myClass = clazz;
        this.superConstructor = _superCall;
    }

    public static String getConstructorText(JSClass jsClass, JSFunction superConstructor, Collection<String> toImport) {
        int i;
        JSAttributeList attributeList = jsClass.getAttributeList();
        StringBuilder fun = new StringBuilder();
        if (attributeList != null && attributeList.getAccessType() == JSAttributeList.AccessType.PUBLIC) {
            fun.append(JSVisibilityUtil.getVisibilityKeyword(JSAttributeList.AccessType.PUBLIC)).append(" ");
        }
        fun.append("function ").append(jsClass.getName()).append("(");
        JSParameterList parameterList = superConstructor.getParameterList();
        JSParameter[] parameters = parameterList.getParameters();
        for (i = 0; i < parameters.length; ++i) {
            JSExpression initializer;
            if (i > 0) {
                fun.append(",");
            }
            if (parameters[i].isRest()) {
                fun.append("...").append(parameters[i].getName());
                continue;
            }
            fun.append(parameters[i].getName());
            JSType jsType = parameters[i].getType();
            if (jsType != null) {
                String type = jsType.getResolvedTypeText();
                if (ImportUtils.needsImport((JSQualifiedNamedElement)jsClass, StringUtil.getPackageName((String)type))) {
                    toImport.add(type);
                }
                fun.append(":").append(type);
            }
            if ((initializer = parameters[i].getInitializer()) == null) continue;
            fun.append("=").append(initializer.getText());
        }
        fun.append("){\nsuper(");
        for (i = 0; i < parameters.length; ++i) {
            if (i > 0) {
                fun.append(",");
            }
            fun.append(parameters[i].getName());
        }
        fun.append(")").append(JSCodeStyleSettings.getSemicolon(jsClass.getContainingFile())).append("\n}");
        return fun.toString();
    }

    @NotNull
    public String getText() {
        String string = JSBundle.message((String)"javascript.fix.create.constructor.invoke.super", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/fixes/AddConstructorAndSuperInvocationFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/fixes/AddConstructorAndSuperInvocationFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/validation/fixes/AddConstructorAndSuperInvocationFix", "isAvailable"));
        }
        return this.myClass.isValid() && this.superConstructor.isValid();
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/validation/fixes/AddConstructorAndSuperInvocationFix", "invoke"));
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        JSClass jsClass = this.myClass;
        HashSet<String> toImport = new HashSet<String>();
        String text = AddConstructorAndSuperInvocationFix.getConstructorText(jsClass, this.superConstructor, toImport);
        jsClass.add(JSChangeUtil.createJSTreeFromText(jsClass.getProject(), text, JavaScriptSupportLoader.ECMA_SCRIPT_L4).getPsi());
        if (!toImport.isEmpty()) {
            ImportUtils.insertImportStatements((PsiElement)jsClass, toImport);
            new ECMAScriptImportOptimizer().processFile(jsClass.getContainingFile()).run();
        }
    }

    public boolean startInWriteAction() {
        return true;
    }
}

