/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.settings.JSRootConfiguration;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeLanguageLevelFix
implements IntentionAction,
LocalQuickFix {
    private final JSLanguageLevel myProposedLevel;

    public ChangeLanguageLevelFix(JSLanguageLevel proposedLevel) {
        this.myProposedLevel = proposedLevel;
    }

    @NotNull
    public String getText() {
        String string = JSBundle.message((String)"javascript.change.language.level.message", (Object[])new Object[]{this.myProposedLevel});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/fixes/ChangeLanguageLevelFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/fixes/ChangeLanguageLevelFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"javascript.change.language.level.family", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/fixes/ChangeLanguageLevelFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/validation/fixes/ChangeLanguageLevelFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/javascript/validation/fixes/ChangeLanguageLevelFix", "applyFix"));
        }
        this.invoke(project, null, descriptor.getPsiElement().getContainingFile());
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/validation/fixes/ChangeLanguageLevelFix", "invoke"));
        }
        JSRootConfiguration.getInstance(project).storeLanguageLevelAndUpdateCaches(this.myProposedLevel);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/validation/fixes/ChangeLanguageLevelFix", "isAvailable"));
        }
        return true;
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Nullable
    public static JSLanguageLevel defineMinimalLanguageLevel(JSLanguageFeature feature, JSLanguageLevel currentLevel) {
        JSLanguageLevel minLevel = null;
        for (JSLanguageLevel level : JSLanguageLevel.orderedByNewFeatures()) {
            if (!level.getDialect().getOptionHolder().hasFeature(feature)) continue;
            minLevel = level;
            break;
        }
        if (minLevel != null) {
            return JSLanguageLevel.ES5.equals((Object)currentLevel) ? JSLanguageLevel.JS_1_8_5 : minLevel;
        }
        return null;
    }
}

