/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler;

import com.intellij.lang.typescript.compiler.TypeScriptCompileInfo;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerConfigUtil;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptCompileInfoBuilder {
    @NotNull
    public static TypeScriptCompileInfo createCompilerInputWithUnSavedFiles(Project project, @NotNull VirtualFile currentVirtualFile, boolean shouldGetValueFromCache, long documentModificationTime) {
        if (currentVirtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentVirtualFile", "com/intellij/lang/typescript/compiler/TypeScriptCompileInfoBuilder", "createCompilerInputWithUnSavedFiles"));
        }
        String path = TypeScriptCompilerService.normalizeNameAndPath(currentVirtualFile);
        String compilerId = TypeScriptCompilerService.getService(project).getCompilerId(currentVirtualFile);
        HashMap nameToContent = ContainerUtil.newHashMap();
        FileDocumentManager manager = FileDocumentManager.getInstance();
        long stamp = currentVirtualFile.getModificationStamp();
        for (Document document : manager.getUnsavedDocuments()) {
            VirtualFile virtualFile = manager.getFile(document);
            long currentDocumentStamp = document.getModificationStamp();
            if (currentVirtualFile.equals(virtualFile) && currentDocumentStamp > stamp) {
                stamp = currentDocumentStamp;
            }
            if (virtualFile == null || !virtualFile.isInLocalFileSystem() || !TypeScriptCompilerSettings.acceptFileType(virtualFile.getFileType())) continue;
            nameToContent.put(TypeScriptCompilerService.normalizeNameAndPath(virtualFile), document.getText());
        }
        if (stamp < documentModificationTime) {
            stamp = documentModificationTime;
        }
        TypeScriptCompileInfo typeScriptCompileInfo = new TypeScriptCompileInfo(ContainerUtil.newHashMap((Pair)Pair.create((Object)path, (Object)stamp), (Pair[])new Pair[0]), nameToContent, true, shouldGetValueFromCache, TypeScriptCompileInfoBuilder.getModuleInfoIfNeed(currentVirtualFile, project), compilerId);
        if (typeScriptCompileInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/TypeScriptCompileInfoBuilder", "createCompilerInputWithUnSavedFiles"));
        }
        return typeScriptCompileInfo;
    }

    public static TypeScriptCompileInfo createSimpleCompilerInput(Project project, @NotNull VirtualFile currentVirtualFile) {
        if (currentVirtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentVirtualFile", "com/intellij/lang/typescript/compiler/TypeScriptCompileInfoBuilder", "createSimpleCompilerInput"));
        }
        String compilerId = TypeScriptCompilerService.getService(project).getCompilerId(currentVirtualFile);
        List fileNames = ContainerUtil.createMaybeSingletonList((Object)TypeScriptCompilerService.normalizeNameAndPath(currentVirtualFile));
        return new TypeScriptCompileInfo((Collection)fileNames, (Pair)TypeScriptCompileInfoBuilder.getModuleInfoIfNeed(currentVirtualFile, project), compilerId){

            @Override
            public boolean shouldShowErrorsInToolWindow() {
                return false;
            }

            @Override
            protected boolean isReturnCompiledFiles() {
                return true;
            }
        };
    }

    public static TypeScriptCompileInfo createCompilerInputForConfig(Project project, TypeScriptConfig config) {
        String compilerIdForConfig = TypeScriptCompilerConfigUtil.getCompilerIdForConfig(config);
        return new TypeScriptCompileInfo((Collection)ContainerUtil.emptyList(), null, compilerIdForConfig){

            @Override
            public boolean shouldShowErrorsInToolWindow() {
                return false;
            }

            @Override
            public boolean forceCompile() {
                return true;
            }

            @Override
            protected boolean isReturnCompiledFiles() {
                return true;
            }
        };
    }

    @Nullable
    public static Pair<String, String> getModuleInfoIfNeed(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/TypeScriptCompileInfoBuilder", "getModuleInfoIfNeed"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/TypeScriptCompileInfoBuilder", "getModuleInfoIfNeed"));
        }
        TypeScriptCompilerSettings settings = TypeScriptCompilerSettings.getSettings(project);
        if (settings.isHasOutDirectory()) {
            ProjectFileIndex projectFileIndex = ProjectFileIndex.SERVICE.getInstance((Project)project);
            VirtualFile contentRoot = projectFileIndex.getContentRootForFile(file);
            String contentRootPath = null;
            if (contentRoot != null) {
                contentRootPath = TypeScriptCompilerService.normalizeNameAndPath(contentRoot.getCanonicalPath());
            }
            VirtualFile sourceRoot = projectFileIndex.getSourceRootForFile(file);
            String sourceRootPath = null;
            if (sourceRoot != null) {
                sourceRootPath = TypeScriptCompilerService.normalizeNameAndPath(sourceRoot.getCanonicalPath());
            }
            return Pair.create((Object)contentRootPath, sourceRootPath);
        }
        return null;
    }

    @NotNull
    public static String toPath(@NotNull VirtualFile configFile) {
        if (configFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFile", "com/intellij/lang/typescript/compiler/TypeScriptCompileInfoBuilder", "toPath"));
        }
        String canonicalPath = configFile.getParent().getCanonicalPath();
        assert (canonicalPath != null);
        String string = FileUtil.toSystemDependentName((String)canonicalPath);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/TypeScriptCompileInfoBuilder", "toPath"));
        }
        return string;
    }
}

