/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler;

import com.intellij.json.JsonFileType;
import com.intellij.lang.typescript.compiler.TypeScriptCompileInfoBuilder;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptCompilerConfigUtil {
    @NotNull
    public static String getConfigDirectoryByCompilerId(@NotNull String compilerId) {
        if (compilerId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compilerId", "com/intellij/lang/typescript/compiler/TypeScriptCompilerConfigUtil", "getConfigDirectoryByCompilerId"));
        }
        String string = compilerId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/TypeScriptCompilerConfigUtil", "getConfigDirectoryByCompilerId"));
        }
        return string;
    }

    @Nullable
    public static TypeScriptConfig getConfigByCompilerId(@Nullable Project project, @NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/lang/typescript/compiler/TypeScriptCompilerConfigUtil", "getConfigByCompilerId"));
        }
        for (TypeScriptConfig config : TypeScriptConfigService.Provider.getConfigFiles(project)) {
            if (!TypeScriptCompilerConfigUtil.getCompilerIdForConfig(config).equals(id)) continue;
            return config;
        }
        return null;
    }

    @NotNull
    public static String getCompilerIdForConfig(@NotNull TypeScriptConfig config) {
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/lang/typescript/compiler/TypeScriptCompilerConfigUtil", "getCompilerIdForConfig"));
        }
        String string = TypeScriptCompilerConfigUtil.getCompilerIdForConfig(config.getConfigFile());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/TypeScriptCompilerConfigUtil", "getCompilerIdForConfig"));
        }
        return string;
    }

    public static String getCompilerIdForConfig(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/TypeScriptCompilerConfigUtil", "getCompilerIdForConfig"));
        }
        return TypeScriptCompileInfoBuilder.toPath(file);
    }

    @Nullable
    public static String getCompilerIdForFile(@Nullable Project project, @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/TypeScriptCompilerConfigUtil", "getCompilerIdForFile"));
        }
        TypeScriptConfig config = TypeScriptCompilerConfigUtil.getConfigForFile(project, file);
        return config == null ? null : TypeScriptCompilerConfigUtil.getCompilerIdForConfig(config);
    }

    @Nullable
    public static TypeScriptConfig getConfigForFile(@Nullable Project project, @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/TypeScriptCompilerConfigUtil", "getConfigForFile"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Collection<TypeScriptConfig> filteredConfigs = TypeScriptConfigService.Provider.getConfigInclude(project, file);
        if (filteredConfigs.isEmpty()) {
            return null;
        }
        assert (project != null);
        if (1 == filteredConfigs.size() || filteredConfigs.isEmpty()) {
            return (TypeScriptConfig)ContainerUtil.getFirstItem(filteredConfigs);
        }
        Map configToDirectory = ContainerUtil.newMapFromKeys(filteredConfigs.iterator(), (Convertor)new Convertor<TypeScriptConfig, VirtualFile>(){

            public VirtualFile convert(TypeScriptConfig o) {
                return o.getConfigFile().getParent();
            }
        });
        for (VirtualFile toSearch = file.getParent(); toSearch != null; toSearch = toSearch.getParent()) {
            for (Map.Entry entry : configToDirectory.entrySet()) {
                VirtualFile configDirectory = (VirtualFile)entry.getValue();
                if (!configDirectory.equals(toSearch)) continue;
                return (TypeScriptConfig)entry.getKey();
            }
        }
        return (TypeScriptConfig)ContainerUtil.getFirstItem(filteredConfigs);
    }

    public static boolean isConfig(VirtualFile file, FileType type) {
        return type == JsonFileType.INSTANCE && "tsconfig.json".equals(file.getName());
    }
}

