/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.action;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.compiler.JSLanguageCompilerResult;
import com.intellij.lang.javascript.compiler.JSLanguageCompilerResultContainer;
import com.intellij.lang.javascript.compiler.ui.JSLanguageCompilerToolWindowManager;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.typescript.compiler.TypeScriptCompileInfo;
import com.intellij.lang.typescript.compiler.TypeScriptCompileInfoBuilder;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.protocol.commands.TypeScriptCompilerCommandClean;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import icons.JavaScriptLanguageIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptCompileAllAction
extends AnAction {
    public static final Logger LOGGER = Logger.getInstance((String)"#com.intellij.lang.javascript.compiler.JSLanguageExternalCompilerImpl");
    private TypeScriptCompilerCommandClean myCommandClean = new TypeScriptCompilerCommandClean(false);

    public TypeScriptCompileAllAction() {
        super(JSBundle.message((String)"typescript.compiler.action.compile.all", (Object[])new Object[0]), JSBundle.message((String)"typescript.compiler.action.compile.all.description", (Object[])new Object[0]), JavaScriptLanguageIcons.Typescript.CompileCurrentFile2);
    }

    public TypeScriptCompileAllAction(@Nullable String text, @Nullable String description, @Nullable Icon icon) {
        super(text, description, icon);
    }

    @Nullable
    protected VirtualFile[] getFiles(Project project, DataContext context) {
        return null;
    }

    public synchronized void actionPerformed(AnActionEvent e) {
        FileDocumentManager.getInstance().saveAllDocuments();
        final Project project = e.getProject();
        if (project == null) {
            return;
        }
        final VirtualFile[] files = this.getFiles(project, e.getDataContext());
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, "Compiling TypeScript Files", true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/lang/typescript/compiler/action/TypeScriptCompileAllAction$1", "run"));
                }
                try {
                    indicator.checkCanceled();
                    TypeScriptCompileAllAction.this.runCompile(indicator, project, files);
                }
                catch (ProcessCanceledException processCanceledException) {
                    // empty catch block
                }
            }
        });
    }

    protected boolean canSkipIterateAll() {
        return true;
    }

    protected void runCompile(final @NotNull ProgressIndicator indicator, final Project project, @Nullable VirtualFile[] files) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/lang/typescript/compiler/action/TypeScriptCompileAllAction", "runCompile"));
        }
        final LinkedHashSet infos = ContainerUtil.newLinkedHashSet();
        final TypeScriptCompilerService compilerService = TypeScriptCompilerService.getService(project);
        final GlobalSearchScope scope = TypeScriptCompilerService.getCompileScope(project);
        TypeScriptCompilerSettings settings = TypeScriptCompilerSettings.getSettings(project);
        if (this.canSkipIterateAll() && settings.isUseConfigForCompiler()) {
            this.processConfigs(project, indicator, compilerService, infos);
            indicator.checkCanceled();
            this.logErrors(infos, compilerService);
            return;
        }
        final boolean mainOnly = settings.isUseMainFile();
        final HashSet processedFiles = ContainerUtil.newHashSet();
        this.iterateFilesForCompile(project, indicator, new Processor<VirtualFile>(){

            public boolean process(VirtualFile file) {
                String path;
                indicator.checkCanceled();
                if (!TypeScriptCompilerSettings.acceptFileType(file.getFileType()) || !scope.accept(file) || JSLibraryUtil.isProbableLibraryFile(file)) {
                    return true;
                }
                if (processedFiles.size() > 0 && (path = file.getCanonicalPath()) != null) {
                    String independentName = FileUtil.toSystemIndependentName((String)path);
                    if (processedFiles.contains(independentName)) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Action Compile: skip compile for " + file.getName());
                        }
                        return true;
                    }
                    if (mainOnly) {
                        infos.add(new JSLanguageCompilerResult(JSBundle.message((String)"typescript.compiler.action.no.compile.message", (Object[])new Object[0]), path, "warning", 0, 0));
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Action Compile: skip and warning no compile for " + file.getName());
                        }
                        return true;
                    }
                }
                return TypeScriptCompileAllAction.this.compileFile(project, file, indicator, compilerService, infos, processedFiles);
            }
        }, files);
        indicator.checkCanceled();
        this.logErrors(infos, compilerService);
    }

    private void logErrors(final Collection<JSLanguageCompilerResult> infos, TypeScriptCompilerService compilerService) {
        final JSLanguageCompilerToolWindowManager manager = compilerService.getToolWindowManager();
        if (manager != null) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    manager.init();
                    TypeScriptCompileAllAction.this.logErrors(manager, infos);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processConfigs(Project project, ProgressIndicator indicator, TypeScriptCompilerService service, Collection<JSLanguageCompilerResult> infos) {
        Collection<TypeScriptConfig> configs;
        AccessToken token = ApplicationManager.getApplication().acquireReadActionLock();
        try {
            configs = TypeScriptConfigService.Provider.getConfigFiles(project);
        }
        finally {
            token.finish();
        }
        for (TypeScriptConfig config : configs) {
            if (!this.compileConfig(project, indicator, service, config, infos)) break;
        }
    }

    protected boolean compileConfig(Project project, ProgressIndicator indicator, TypeScriptCompilerService service, TypeScriptConfig config, Collection<JSLanguageCompilerResult> infos) {
        indicator.checkCanceled();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Action Compile: do compile for " + config.getConfigFile().getName());
        }
        try {
            indicator.setText2(JSBundle.message((String)"typescript.compiler.action.compile.all.clean", (Object[])new Object[0]));
            service.sendCleanCommandToCompiler(this.myCommandClean);
            indicator.setText2(JSBundle.message((String)"typescript.compiler.action.compile.all.compile.config", (Object[])new Object[]{config.getConfigFile().getPath()}));
            TypeScriptCompileInfo info = TypeScriptCompileInfoBuilder.createCompilerInputForConfig(project, config);
            Future<JSLanguageCompilerResultContainer> compile = service.compile(info);
            if (compile != null) {
                JSLanguageCompilerResultContainer container = compile.get(60L, TimeUnit.SECONDS);
                infos.addAll((Collection<JSLanguageCompilerResult>)container.getCompiledResults());
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.info(e.getMessage(), (Throwable)e);
            indicator.cancel();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void iterateFilesForCompile(Project project, ProgressIndicator indicator, Processor<VirtualFile> processor, @Nullable VirtualFile[] files) {
        GlobalSearchScope scope = TypeScriptCompilerService.getCompileScope(project);
        AccessToken token = ApplicationManager.getApplication().acquireReadActionLock();
        ArrayList filesToIterate = ContainerUtil.newArrayList();
        try {
            for (FileType type : TypeScriptUtil.TYPESCRIPT_FILE_TYPES) {
                filesToIterate.addAll(FileTypeIndex.getFiles((FileType)type, (GlobalSearchScope)scope));
            }
        }
        finally {
            token.finish();
        }
        for (VirtualFile file : filesToIterate) {
            if (TypeScriptUtil.isUnderNodeModules(file, project) || processor.process((Object)file)) continue;
            return;
        }
    }

    protected void logErrors(JSLanguageCompilerToolWindowManager manager, Collection<JSLanguageCompilerResult> infos) {
        manager.logProjectErrors((ImmutableList<JSLanguageCompilerResult>)ContainerUtil.immutableList((List)ContainerUtil.newArrayList(infos)), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean compileFile(Project project, VirtualFile file, @NotNull ProgressIndicator indicator, TypeScriptCompilerService service, Collection<JSLanguageCompilerResult> infos, Collection<String> processedFiles) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/lang/typescript/compiler/action/TypeScriptCompileAllAction", "compileFile"));
        }
        indicator.checkCanceled();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Action Compile: do compile for " + file.getName());
        }
        indicator.setText2(JSBundle.message((String)"typescript.compiler.action.compile.all.clean", (Object[])new Object[0]));
        service.sendCleanCommandToCompiler(this.myCommandClean);
        indicator.setText2(JSBundle.message((String)"typescript.compiler.action.compile.all.compile", (Object[])new Object[]{file.getName()}));
        try {
            TypeScriptCompileInfo info;
            AccessToken token = ApplicationManager.getApplication().acquireReadActionLock();
            try {
                info = TypeScriptCompileInfoBuilder.createSimpleCompilerInput(project, file);
            }
            finally {
                token.finish();
            }
            Future<JSLanguageCompilerResultContainer> compile = service.compile(info);
            if (compile != null) {
                JSLanguageCompilerResultContainer container = compile.get(60L, TimeUnit.SECONDS);
                infos.addAll((Collection<JSLanguageCompilerResult>)container.getCompiledResults());
                if (container.getCompiledFiles() != null) {
                    List<String> files = container.getCompiledFiles();
                    for (String s : files) {
                        if (StringUtil.isEmpty((String)s)) continue;
                        processedFiles.add(FileUtil.toSystemIndependentName((String)s));
                    }
                }
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.info(e.getMessage(), (Throwable)e);
            indicator.checkCanceled();
            return false;
        }
    }
}

