/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.scopeChooser.ScopeChooserCombo;
import com.intellij.javascript.nodejs.NodeDetectionUtil;
import com.intellij.javascript.nodejs.NodeUIUtil;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.TypeScriptFileType;
import com.intellij.lang.typescript.TypeScriptSettings;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.ui.TypeScriptCompilerVersionPanel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ReadonlyFieldWithHistoryWithBrowseButton;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptCompilerConfigurable
implements SearchableConfigurable {
    public static final String TYPESCRIPT_CONFIG_ID = "settings.typescriptcompiler";
    private final Project myProject;
    private final TypeScriptCompilerSettings myCompilerSettings;
    private final TypeScriptSettings mySettings;
    private volatile UIHolder myUIHolder;

    public TypeScriptCompilerConfigurable(Project project) {
        this.myProject = project;
        this.myCompilerSettings = TypeScriptCompilerSettings.getSettings(project);
        this.mySettings = TypeScriptSettings.getSettings(project);
    }

    @NotNull
    public String getId() {
        if (TYPESCRIPT_CONFIG_ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/ui/TypeScriptCompilerConfigurable", "getId"));
        }
        return TYPESCRIPT_CONFIG_ID;
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return null;
    }

    @Nls
    public String getDisplayName() {
        return JSBundle.message((String)"typescript.compiler.configurable.name", (Object[])new Object[0]);
    }

    @Nullable
    public String getHelpTopic() {
        return "reference.settings.typescript";
    }

    @Nullable
    public JComponent createComponent() {
        if (this.myUIHolder == null) {
            this.myUIHolder = new UIHolder();
        }
        return this.myUIHolder.myPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply() throws ConfigurationException {
        if (this.myUIHolder == null) {
            return;
        }
        TypeScriptCompilerService service = TypeScriptCompilerService.getService(this.myProject);
        Object object = service.getCompilerStartLock();
        synchronized (object) {
            this.myUIHolder.apply();
            if (this.myProject.isDefault()) {
                return;
            }
            service.restartCompiler();
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                EditorNotifications.getInstance((Project)TypeScriptCompilerConfigurable.this.myProject).updateAllNotifications();
            }
        }, this.myProject.getDisposed());
    }

    public void reset() {
        if (this.myUIHolder == null) {
            return;
        }
        this.myUIHolder.reset();
    }

    public void disposeUIResources() {
    }

    @Nullable
    private static String getDefaultNodeInterpreter() {
        File path = NodeDetectionUtil.findInterpreterInPath();
        return path != null ? path.getAbsolutePath() : null;
    }

    public boolean isModified() {
        if (this.myUIHolder == null) {
            return false;
        }
        return this.myUIHolder.isModified();
    }

    private final class UIHolder {
        private JCheckBox myEnableTypeScriptCompilerCheckBox;
        private JBTextField myCompilerParamsTextField;
        private ReadonlyFieldWithHistoryWithBrowseButton myNodeInterpreterTextField;
        private ScopeChooserCombo myScopeChooserCombo;
        private JPanel myCompilerComponentPanel;
        private JPanel myPanel;
        private JCheckBox myGenerateSourceMapCheckBox;
        private JCheckBox myTrackFileSystemChanges;
        private JCheckBox myHasOutDirectoryCheckbox;
        private TextFieldWithBrowseButton myOutDirectory;
        private TypeScriptCompilerVersionPanel myVersionTextPanel;
        private JComponent myNoteMacroLabel;
        private JCheckBox myUseMainFileCheckbox;
        private TextFieldWithBrowseButton myMainFilePath;
        private JBLabel myMainFileErrorLabel;
        private JCheckBox myEnableTypeScriptConfigCheckBox;
        private JBRadioButton myRadioSetManual;
        private JBRadioButton myRadioUseConfigForCompiler;
        private JPanel myCompilerOptionsPanel;

        private UIHolder() {
            FormBuilder mainFormBuilder = FormBuilder.createFormBuilder();
            this.myEnableTypeScriptConfigCheckBox = new JCheckBox(JSBundle.message((String)"typescript.config.configurable.options.enable", (Object[])new Object[0]));
            this.myEnableTypeScriptCompilerCheckBox = new JCheckBox(JSBundle.message((String)"typescript.compiler.configurable.options.enable", (Object[])new Object[0]));
            mainFormBuilder.addComponent((JComponent)new TitledSeparator("Common"));
            mainFormBuilder.addComponent((JComponent)this.myEnableTypeScriptConfigCheckBox);
            mainFormBuilder.addComponent((JComponent)new TitledSeparator("Compiler"));
            mainFormBuilder.addComponent((JComponent)this.myEnableTypeScriptCompilerCheckBox);
            this.myEnableTypeScriptCompilerCheckBox.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    UIHolder.this.setComponentsEnable(UIHolder.this.myEnableTypeScriptCompilerCheckBox.isSelected(), UIHolder.this.myRadioUseConfigForCompiler.isSelected());
                }
            });
            FormBuilder compilerBuilder = this.createCompilerBuilder();
            this.myRadioSetManual = new JBRadioButton("Set options manually");
            this.myRadioUseConfigForCompiler = new JBRadioButton("Use tsconfig.json");
            compilerBuilder.addComponent((JComponent)new TitledSeparator(""));
            compilerBuilder.addLabeledComponent((JComponent)this.myRadioSetManual, (JComponent)this.myRadioUseConfigForCompiler);
            ButtonGroup group = new ButtonGroup();
            group.add((AbstractButton)this.myRadioUseConfigForCompiler);
            group.add((AbstractButton)this.myRadioSetManual);
            this.myRadioUseConfigForCompiler.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    UIHolder.this.setComponentsEnable(UIHolder.this.myEnableTypeScriptCompilerCheckBox.isSelected(), UIHolder.this.myRadioUseConfigForCompiler.isSelected());
                }
            });
            FormBuilder compilerOptionsBuilder = this.createCompilerOptionsBuilder();
            this.myCompilerOptionsPanel = compilerOptionsBuilder.getPanel();
            this.myCompilerOptionsPanel.setBorder((Border)JBUI.Borders.emptyLeft((int)25));
            JPanel compilerOptionsWrapper = new JPanel(new BorderLayout());
            compilerOptionsWrapper.add((Component)this.myCompilerOptionsPanel, "North");
            compilerBuilder.addComponent((JComponent)compilerOptionsWrapper);
            this.myCompilerComponentPanel = compilerBuilder.getPanel();
            this.myCompilerComponentPanel.setBorder((Border)JBUI.Borders.emptyLeft((int)25));
            JPanel restComponentsWrapper = new JPanel(new BorderLayout());
            restComponentsWrapper.add((Component)this.myCompilerComponentPanel, "North");
            mainFormBuilder.addComponent((JComponent)restComponentsWrapper);
            this.setComponentsEnable(this.myEnableTypeScriptCompilerCheckBox.isSelected(), this.myRadioUseConfigForCompiler.isSelected());
            this.myPanel = new JPanel(new BorderLayout());
            this.myPanel.add((Component)mainFormBuilder.getPanel(), "North");
            this.updateError();
        }

        @NotNull
        private FormBuilder createCompilerBuilder() {
            FormBuilder compilerBuilder = FormBuilder.createFormBuilder();
            this.myNodeInterpreterTextField = NodeUIUtil.createNodeInterpreterTextField(TypeScriptCompilerConfigurable.this.myProject);
            compilerBuilder.addLabeledComponent("&Node interpreter:", this.myNodeInterpreterTextField.getComponent());
            this.myVersionTextPanel = new TypeScriptCompilerVersionPanel(TypeScriptCompilerConfigurable.this.myProject, TypeScriptCompilerConfigurable.this.myCompilerSettings);
            compilerBuilder.addLabeledComponent(JSBundle.message((String)"typescript.compiler.configurable.options.version", (Object[])new Object[0]), (JComponent)this.myVersionTextPanel);
            this.myTrackFileSystemChanges = new JCheckBox(JSBundle.message((String)"typescript.compiler.configurable.options.track.file.system", (Object[])new Object[0]));
            this.myTrackFileSystemChanges.setBorder((Border)JBUI.Borders.empty());
            compilerBuilder.addComponent((JComponent)this.myTrackFileSystemChanges);
            if (!TypeScriptCompilerConfigurable.this.myProject.isDefault()) {
                this.myScopeChooserCombo = new ScopeChooserCombo();
                compilerBuilder.addLabeledComponent(JSBundle.message((String)"typescript.compiler.configurable.options.scope", (Object[])new Object[0]), (JComponent)this.myScopeChooserCombo);
            } else {
                this.myScopeChooserCombo = null;
            }
            FormBuilder formBuilder = compilerBuilder;
            if (formBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/ui/TypeScriptCompilerConfigurable$UIHolder", "createCompilerBuilder"));
            }
            return formBuilder;
        }

        @NotNull
        private FormBuilder createCompilerOptionsBuilder() {
            FormBuilder compilerOptionsBuilder = FormBuilder.createFormBuilder();
            this.myCompilerParamsTextField = new JBTextField();
            compilerOptionsBuilder.addLabeledComponent(JSBundle.message((String)"typescript.compiler.configurable.options.command.line", (Object[])new Object[0]), (JComponent)this.myCompilerParamsTextField);
            this.myGenerateSourceMapCheckBox = new JCheckBox(JSBundle.message((String)"typescript.compiler.configurable.options.generate.source.map", (Object[])new Object[0]));
            this.myGenerateSourceMapCheckBox.setBorder((Border)JBUI.Borders.empty((int)0, (int)0, (int)10, (int)0));
            compilerOptionsBuilder.addComponent((JComponent)this.myGenerateSourceMapCheckBox);
            this.myUseMainFileCheckbox = new JCheckBox(JSBundle.message((String)"typescript.compiler.configurable.options.compile.main", (Object[])new Object[0]));
            this.myUseMainFileCheckbox.setBorder((Border)JBUI.Borders.empty());
            this.myMainFilePath = new TextFieldWithBrowseButton();
            this.myMainFilePath.addBrowseFolderListener("Main File", "Choose main file", TypeScriptCompilerConfigurable.this.myProject, FileChooserDescriptorFactory.createSingleFileDescriptor((FileType)TypeScriptFileType.INSTANCE));
            this.myUseMainFileCheckbox.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    boolean enabled = UIHolder.this.myUseMainFileCheckbox.isEnabled() && UIHolder.this.myUseMainFileCheckbox.isSelected();
                    UIHolder.this.myMainFilePath.setEnabled(enabled);
                    UIHolder.this.updateError();
                }
            });
            this.myMainFileErrorLabel = new JBLabel(AllIcons.Actions.Lightning);
            compilerOptionsBuilder.addLabeledComponent((JComponent)this.myUseMainFileCheckbox, (JComponent)this.myMainFilePath);
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)this.myMainFileErrorLabel, "West");
            this.myMainFileErrorLabel.setBorder((Border)JBUI.Borders.emptyLeft((int)8));
            UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.SMALL, (Component)this.myMainFileErrorLabel);
            compilerOptionsBuilder.addComponentToRightColumn((JComponent)panel);
            this.myHasOutDirectoryCheckbox = new JCheckBox(JSBundle.message((String)"typescript.compiler.configurable.options.output.path", (Object[])new Object[0]));
            this.myHasOutDirectoryCheckbox.setBorder((Border)JBUI.Borders.empty());
            this.myOutDirectory = new TextFieldWithBrowseButton();
            this.myOutDirectory.addBrowseFolderListener("Output Directory", "Choose output directory", TypeScriptCompilerConfigurable.this.myProject, FileChooserDescriptorFactory.createSingleFolderDescriptor());
            compilerOptionsBuilder.addLabeledComponent((JComponent)this.myHasOutDirectoryCheckbox, (JComponent)this.myOutDirectory);
            this.myNoteMacroLabel = this.createMacroComponent();
            compilerOptionsBuilder.addComponent(this.myNoteMacroLabel);
            this.myHasOutDirectoryCheckbox.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    boolean enabled = UIHolder.this.myHasOutDirectoryCheckbox.isEnabled() && UIHolder.this.myHasOutDirectoryCheckbox.isSelected();
                    UIHolder.this.myOutDirectory.setEnabled(enabled);
                    UIHolder.this.myNoteMacroLabel.setEnabled(enabled);
                }
            });
            FormBuilder formBuilder = compilerOptionsBuilder;
            if (formBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/ui/TypeScriptCompilerConfigurable$UIHolder", "createCompilerOptionsBuilder"));
            }
            return formBuilder;
        }

        @NotNull
        private JEditorPane createMacroComponent() {
            Font font = UIUtil.getTitledBorderFont();
            JEditorPane viewer = SwingHelper.createHtmlViewer((boolean)true, (Font)font, null, null);
            String html = String.format("<html><head>%s</head><body>%s</body></html>", UIUtil.getCssFontDeclaration((Font)font, (Color)UIUtil.getLabelForeground(), null, null), JSBundle.message((String)"typescript.compiler.configurable.options.macro.text", (Object[])new Object[0]) + " " + JSBundle.message((String)"typescript.compiler.configurable.options.macro.list", (Object[])new Object[0]));
            viewer.setText(html);
            viewer.setBorder((Border)JBUI.Borders.emptyLeft((int)7));
            JEditorPane jEditorPane = viewer;
            if (jEditorPane == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/ui/TypeScriptCompilerConfigurable$UIHolder", "createMacroComponent"));
            }
            return jEditorPane;
        }

        private void setComponentsEnable(boolean globalEnable, boolean useTSConfigCompiler) {
            UIUtil.setEnabled((Component)this.myCompilerComponentPanel, (boolean)globalEnable, (boolean)true);
            UIUtil.setEnabled((Component)this.myCompilerOptionsPanel, (globalEnable && !useTSConfigCompiler ? 1 : 0) != 0, (boolean)true);
            boolean enabledForOut = globalEnable && !useTSConfigCompiler && this.myHasOutDirectoryCheckbox.isSelected();
            this.myOutDirectory.setEnabled(enabledForOut);
            this.myNoteMacroLabel.setEnabled(enabledForOut);
            boolean enableForMainFile = globalEnable && !useTSConfigCompiler && this.myUseMainFileCheckbox.isSelected();
            this.myMainFilePath.setEnabled(enableForMainFile);
        }

        private void apply() {
            TypeScriptCompilerConfigurable.this.myCompilerSettings.setImmediateCompileEnabled(this.myEnableTypeScriptCompilerCheckBox.isSelected());
            TypeScriptCompilerConfigurable.this.myCompilerSettings.setTypeScriptCompilerParams(this.myCompilerParamsTextField.getText());
            TypeScriptCompilerConfigurable.this.myCompilerSettings.setNodeInterpreter(this.getNodeInterpreterValueForStore());
            TypeScriptCompilerConfigurable.this.myCompilerSettings.setGenerateSourceMap(this.myGenerateSourceMapCheckBox.isSelected());
            TypeScriptCompilerConfigurable.this.myCompilerSettings.setHasOutDirectory(this.myHasOutDirectoryCheckbox.isSelected());
            TypeScriptCompilerConfigurable.this.myCompilerSettings.setOutDirectory(this.myOutDirectory.getText());
            TypeScriptCompilerConfigurable.this.myCompilerSettings.setMainFilePath(this.myMainFilePath.getText());
            TypeScriptCompilerConfigurable.this.myCompilerSettings.setUseMainFile(this.myUseMainFileCheckbox.isSelected());
            TypeScriptCompilerConfigurable.this.myCompilerSettings.setUseConfigForCompiler(this.myRadioUseConfigForCompiler.isSelected());
            if (this.myScopeChooserCombo != null) {
                String scopeName = this.myScopeChooserCombo.getSelectedScopeName();
                TypeScriptCompilerConfigurable.this.myCompilerSettings.setScopeName(scopeName == null ? "Project Files" : scopeName);
            }
            TypeScriptCompilerConfigurable.this.myCompilerSettings.setTrackFileSystemChanges(this.myTrackFileSystemChanges.isSelected());
            this.myVersionTextPanel.apply();
            TypeScriptCompilerConfigurable.this.mySettings.setUseConfig(this.myEnableTypeScriptConfigCheckBox.isSelected());
        }

        private void reset() {
            this.myEnableTypeScriptCompilerCheckBox.setSelected(TypeScriptCompilerConfigurable.this.myCompilerSettings.isCompilerEnabled());
            this.myCompilerParamsTextField.setText(TypeScriptCompilerConfigurable.this.myCompilerSettings.getTypeScriptCompilerParams());
            this.myNodeInterpreterTextField.set(StringUtil.notNullize((String)this.getNodeInterpreterValueForField()));
            this.myGenerateSourceMapCheckBox.setSelected(TypeScriptCompilerConfigurable.this.myCompilerSettings.isGenerateSourceMap());
            this.myEnableTypeScriptCompilerCheckBox.setSelected(TypeScriptCompilerConfigurable.this.myCompilerSettings.isCompilerEnabled());
            this.myCompilerParamsTextField.setText(TypeScriptCompilerConfigurable.this.myCompilerSettings.getTypeScriptCompilerParams());
            this.myGenerateSourceMapCheckBox.setSelected(TypeScriptCompilerConfigurable.this.myCompilerSettings.isGenerateSourceMap());
            boolean useConfigForCompiler = TypeScriptCompilerConfigurable.this.myCompilerSettings.isUseConfigForCompiler();
            if (useConfigForCompiler) {
                this.myRadioUseConfigForCompiler.setSelected(true);
                this.myRadioSetManual.setSelected(false);
            } else {
                this.myRadioUseConfigForCompiler.setSelected(false);
                this.myRadioSetManual.setSelected(true);
            }
            this.myMainFilePath.setText(TypeScriptCompilerConfigurable.this.myCompilerSettings.getMainFilePath());
            this.myUseMainFileCheckbox.setSelected(TypeScriptCompilerConfigurable.this.myCompilerSettings.isUseMainFile());
            boolean enableForMainFile = this.myUseMainFileCheckbox.isEnabled() && this.myUseMainFileCheckbox.isSelected();
            this.myMainFilePath.setEnabled(enableForMainFile);
            this.myHasOutDirectoryCheckbox.setSelected(TypeScriptCompilerConfigurable.this.myCompilerSettings.isHasOutDirectory());
            this.myOutDirectory.setText(TypeScriptCompilerConfigurable.this.myCompilerSettings.getOutDirectory());
            boolean enabledForOut = this.myHasOutDirectoryCheckbox.isEnabled() && this.myHasOutDirectoryCheckbox.isSelected();
            this.myOutDirectory.setEnabled(enabledForOut);
            this.myNoteMacroLabel.setEnabled(enabledForOut);
            if (this.myScopeChooserCombo != null) {
                this.myScopeChooserCombo.init(TypeScriptCompilerConfigurable.this.myProject, false, false, TypeScriptCompilerConfigurable.this.myCompilerSettings.getScopeName());
            }
            this.myTrackFileSystemChanges.setSelected(TypeScriptCompilerConfigurable.this.myCompilerSettings.isTrackFileSystemChanges());
            this.myVersionTextPanel.resetValue();
            this.myEnableTypeScriptConfigCheckBox.setSelected(TypeScriptCompilerConfigurable.this.mySettings.isEnabledConfig());
            this.updateError();
        }

        private boolean isModified() {
            this.updateError();
            if (this.myMainFileErrorLabel.isVisible()) {
                return false;
            }
            return this.myEnableTypeScriptConfigCheckBox.isSelected() != TypeScriptCompilerConfigurable.this.mySettings.isEnabledConfig() || this.myEnableTypeScriptCompilerCheckBox.isSelected() != TypeScriptCompilerConfigurable.this.myCompilerSettings.isCompilerEnabled() || this.myTrackFileSystemChanges.isSelected() != TypeScriptCompilerConfigurable.this.myCompilerSettings.isTrackFileSystemChanges() || this.myGenerateSourceMapCheckBox.isSelected() != TypeScriptCompilerConfigurable.this.myCompilerSettings.isGenerateSourceMap() || this.myHasOutDirectoryCheckbox.isSelected() != TypeScriptCompilerConfigurable.this.myCompilerSettings.isHasOutDirectory() || this.myRadioUseConfigForCompiler.isSelected() != TypeScriptCompilerConfigurable.this.myCompilerSettings.isUseConfigForCompiler() || this.myHasOutDirectoryCheckbox.isSelected() && !StringUtil.equals((CharSequence)StringUtil.nullize((String)this.myOutDirectory.getText()), (CharSequence)TypeScriptCompilerConfigurable.this.myCompilerSettings.getOutDirectory()) || this.myUseMainFileCheckbox.isSelected() != TypeScriptCompilerConfigurable.this.myCompilerSettings.isUseMainFile() || this.myUseMainFileCheckbox.isSelected() && !StringUtil.equals((CharSequence)StringUtil.nullize((String)this.myMainFilePath.getText()), (CharSequence)TypeScriptCompilerConfigurable.this.myCompilerSettings.getMainFilePath()) || this.myVersionTextPanel.isModified() || !StringUtil.equals((CharSequence)StringUtil.nullize((String)this.myCompilerParamsTextField.getText()), (CharSequence)TypeScriptCompilerConfigurable.this.myCompilerSettings.getTypeScriptCompilerParams()) || null != this.myScopeChooserCombo && !StringUtil.equals((CharSequence)this.myScopeChooserCombo.getSelectedScopeName(), (CharSequence)TypeScriptCompilerConfigurable.this.myCompilerSettings.getScopeName()) || !StringUtil.equals((CharSequence)StringUtil.nullize((String)this.getNodeInterpreterValueForStore()), (CharSequence)TypeScriptCompilerConfigurable.this.myCompilerSettings.getNodeInterpreter());
        }

        @Nullable
        private String getNodeInterpreterValueForField() {
            return TypeScriptCompilerConfigurable.this.myCompilerSettings.getNodeInterpreter() != null ? TypeScriptCompilerConfigurable.this.myCompilerSettings.getNodeInterpreter() : TypeScriptCompilerConfigurable.getDefaultNodeInterpreter();
        }

        private String getNodeInterpreterValueForStore() {
            if (StringUtil.equals((CharSequence)this.myNodeInterpreterTextField.get(), (CharSequence)TypeScriptCompilerConfigurable.getDefaultNodeInterpreter())) {
                return null;
            }
            return this.myNodeInterpreterTextField.get();
        }

        private void updateError() {
            this.myMainFileErrorLabel.setText("");
            this.myMainFileErrorLabel.setVisible(false);
            if (!this.myUseMainFileCheckbox.isSelected() || !this.myUseMainFileCheckbox.isEnabled()) {
                return;
            }
            String path = this.myMainFilePath.getText();
            if (StringUtil.isEmpty((String)path) || !new File(path).exists()) {
                this.myMainFileErrorLabel.setVisible(true);
                this.myMainFileErrorLabel.setText(JSBundle.message((String)"typescript.compiler.configurable.options.compile.main.error", (Object[])new Object[0]));
            }
        }
    }
}

