/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.completion;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.completion.JSCompletionContributor;
import com.intellij.lang.javascript.completion.JSInsertHandler;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.completion.JSReferenceCompletionContributor;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSCompletionProcessor;
import com.intellij.lang.javascript.settings.JSApplicationSettings;
import com.intellij.lang.typescript.psi.TypeScriptAutoImportUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import gnu.trove.THashSet;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class TypeScriptCompletionUtil {
    public static void addAllVariants(@NotNull JSReferenceExpression expression, @NotNull PsiFile containingFile, @NotNull Collection sinkResults) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/typescript/completion/TypeScriptCompletionUtil", "addAllVariants"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/lang/typescript/completion/TypeScriptCompletionUtil", "addAllVariants"));
        }
        if (sinkResults == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sinkResults", "com/intellij/lang/typescript/completion/TypeScriptCompletionUtil", "addAllVariants"));
        }
        final THashSet addedElements = new THashSet();
        for (Object object : sinkResults) {
            PsiElement sinkResult;
            if (object instanceof LookupElement) {
                sinkResult = ((LookupElement)object).getPsiElement();
            } else {
                if (!(object instanceof PsiElement)) continue;
                sinkResult = (PsiElement)object;
            }
            if (sinkResult instanceof ES6ImportExportSpecifier) {
                ResolveResult[] results;
                for (ResolveResult result : results = ((ES6ImportExportSpecifier)sinkResult).multiResolve(false)) {
                    PsiElement element = result.getElement();
                    if (element == null) continue;
                    addedElements.add((Object)CompletionUtil.getOriginalOrSelf((PsiElement)element));
                }
                continue;
            }
            if (sinkResult == null) continue;
            addedElements.add((Object)CompletionUtil.getOriginalOrSelf((PsiElement)sinkResult));
        }
        final CompletionResultSet completionResultSet = JSCompletionContributor.getInstance().getCompletionResultSet();
        final Project project = containingFile.getProject();
        final JSInsertHandler<LookupElement> insertHandler = new JSInsertHandler<LookupElement>(){

            @Override
            public void handleInsert(InsertionContext context, LookupElement item) {
                super.handleInsert(context, item);
                if (!JSApplicationSettings.getInstance().isShowTypeScriptAutoImport()) {
                    return;
                }
                JSQualifiedNamedElement element = (JSQualifiedNamedElement)item.getPsiElement();
                assert (element != null);
                PsiElement elementAt = context.getFile().findElementAt(context.getStartOffset());
                if (elementAt != null) {
                    TypeScriptAutoImportUtil.addImportStatement(element, elementAt);
                }
            }
        };
        final TypeScriptAutoImportUtil.JSReferencePlaceInfo info = new TypeScriptAutoImportUtil.JSReferencePlaceInfo(expression);
        JSReferenceCompletionContributor.processAllIndexedSymbols(new JSCompletionProcessor(){

            @Override
            public boolean acceptsFile(PsiFile file) {
                return file instanceof JSFile && DialectDetector.isTypeScript((PsiElement)file);
            }

            @Override
            public void doAdd(@NotNull JSPsiElementBase element) {
                LookupItem<Object> item;
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/typescript/completion/TypeScriptCompletionUtil$2", "doAdd"));
                }
                if (!addedElements.contains((Object)element) && TypeScriptAutoImportUtil.isAvailableForImport((JSElement)element, info, project) && (item = JSLookupUtilImpl.createPrioritizedLookupItem((PsiElement)element, element.getName(), 2, false, false)) != null) {
                    item.setInsertHandler((InsertHandler)insertHandler);
                    completionResultSet.addElement(item);
                }
            }
        }, project, TypeScriptAutoImportUtil.createSymbolToImportSearchScope((PsiElement)containingFile, project));
    }
}

