/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.javascript.JSModuleReference;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.javascript.TypeScriptFileType;
import com.intellij.lang.javascript.frameworks.amd.TypeScriptNodeReference;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import org.jetbrains.annotations.NotNull;

public class TypeScriptExternalModuleCompletionContributor
extends CompletionContributor {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/lang/typescript/completion/TypeScriptExternalModuleCompletionContributor", "fillCompletionVariants"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/typescript/completion/TypeScriptExternalModuleCompletionContributor", "fillCompletionVariants"));
        }
        PsiReference refStart = parameters.getPosition().getContainingFile().findReferenceAt(parameters.getOffset());
        PsiReference[] refs = refStart instanceof PsiMultiReference ? ((PsiMultiReference)refStart).getReferences() : new PsiReference[]{refStart};
        boolean visited = false;
        for (PsiReference ref : refs) {
            PsiElement element;
            if (ref == null || !((element = ref.getElement()) instanceof ES6FromClause) && !(element.getParent() instanceof TypeScriptImportStatement)) continue;
            Object[] variants = ref.getVariants();
            if (ref instanceof JSModuleReference) {
                visited = true;
                this.processJSModuleVariants(parameters, result, ref, variants);
                continue;
            }
            if (!(ref instanceof TypeScriptNodeReference) || ref.getCanonicalText().contains("/")) continue;
            visited = true;
            this.processTypeScriptModuleVariants(parameters, result, ref, variants);
        }
        if (visited) {
            result.stopHere();
        }
    }

    public void processTypeScriptModuleVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result, PsiReference ref, Object[] variants) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/lang/typescript/completion/TypeScriptExternalModuleCompletionContributor", "processTypeScriptModuleVariants"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/typescript/completion/TypeScriptExternalModuleCompletionContributor", "processTypeScriptModuleVariants"));
        }
        for (Object variant : variants) {
            if (!(variant instanceof LookupElementBuilder)) continue;
            LookupElementBuilder newBuilder = ((LookupElementBuilder)variant).withIcon(TypeScriptFileType.INSTANCE.getIcon());
            result.addElement((LookupElement)newBuilder);
        }
    }

    public void processJSModuleVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result, PsiReference ref, Object[] variants) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/lang/typescript/completion/TypeScriptExternalModuleCompletionContributor", "processJSModuleVariants"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/typescript/completion/TypeScriptExternalModuleCompletionContributor", "processJSModuleVariants"));
        }
        for (Object variant : variants) {
            if (variant instanceof LookupElementBuilder) {
                LookupElementBuilder builder = (LookupElementBuilder)variant;
                String fileName = builder.getLookupString();
                if (!fileName.endsWith(".ts") && !fileName.endsWith(".tsx") || TypeScriptExternalModuleCompletionContributor.isSameNameFile(parameters, fileName, ref)) continue;
                int suffix = 0;
                if (fileName.endsWith(".d.ts")) {
                    suffix = ".d.ts".length();
                } else if (fileName.endsWith(".ts")) {
                    suffix = ".ts".length();
                } else if (fileName.endsWith(".tsx")) {
                    suffix = ".tsx".length();
                }
                String nameWithoutExtension = fileName.substring(0, fileName.length() - suffix);
                LookupElementBuilder newBuilder = LookupElementBuilder.create((Object)builder.getObject(), (String)nameWithoutExtension);
                newBuilder = newBuilder.withIcon(TypeScriptFileType.INSTANCE.getIcon());
                result.addElement((LookupElement)newBuilder);
                continue;
            }
            if (!(variant instanceof PsiDirectory) || TypeScriptExternalModuleCompletionContributor.isFirstElement(ref)) continue;
            LookupElementBuilder newBuilder = LookupElementBuilder.create((Object)variant, (String)((PsiDirectory)variant).getName());
            newBuilder = newBuilder.withIcon(AllIcons.Nodes.Folder);
            result.addElement((LookupElement)newBuilder);
        }
    }

    private static boolean isSameNameFile(@NotNull CompletionParameters parameters, String fileName, PsiReference ref) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/lang/typescript/completion/TypeScriptExternalModuleCompletionContributor", "isSameNameFile"));
        }
        String name = parameters.getOriginalFile().getName();
        if (name == null || !name.equals(fileName)) {
            return false;
        }
        if (ref instanceof FileReference) {
            FileReferenceSet set = ((FileReference)ref).getFileReferenceSet();
            return set.getAllReferences().length == 1 || set.getAllReferences().length == 2 && StringUtil.equals((CharSequence)set.getReference(0).getText(), (CharSequence)".");
        }
        return false;
    }

    private static boolean isFirstElement(PsiReference ref) {
        FileReferenceSet set;
        if (ref instanceof FileReference && (set = ((FileReference)ref).getFileReferenceSet()).getAllReferences().length > 0) {
            return set.getAllReferences()[0] == ref;
        }
        return true;
    }
}

