/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptReferenceContributor;
import com.intellij.lang.javascript.index.JavaScriptIndex;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.typescript.psi.TypeScriptExternalModuleReference;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class TypeScriptGenerateReferencePathIntention
extends PsiElementBaseIntentionAction {
    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiElement resolve;
        int newlineOffset;
        PsiElement ws;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/intentions/TypeScriptGenerateReferencePathIntention", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/typescript/intentions/TypeScriptGenerateReferencePathIntention", "invoke"));
        }
        PsiFile file = element.getContainingFile();
        PsiComment lastReferencePathComment = null;
        PsiElement child = file.getFirstChild();
        while (child instanceof PsiComment || child instanceof PsiWhiteSpace) {
            String path;
            if (child instanceof PsiComment && (path = TypeScriptReferenceContributor.findReferencePath((PsiComment)child)) != null) {
                lastReferencePathComment = (PsiComment)child;
            }
            child = child.getNextSibling();
        }
        int offset = 0;
        if (lastReferencePathComment != null && (ws = lastReferencePathComment.getNextSibling()) instanceof PsiWhiteSpace && (newlineOffset = ws.getText().indexOf(10)) >= 0) {
            offset = ws.getTextRange().getStartOffset() + newlineOffset + 1;
        }
        if ((resolve = ((JSReferenceExpression)element.getParent()).resolve()) == null) {
            return;
        }
        String relativePath = VfsUtil.getPath((VirtualFile)file.getVirtualFile(), (VirtualFile)resolve.getContainingFile().getVirtualFile(), (char)'/');
        editor.getDocument().insertString(offset, (CharSequence)("///<reference path=\"" + relativePath + "\"/>\n"));
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/intentions/TypeScriptGenerateReferencePathIntention", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/typescript/intentions/TypeScriptGenerateReferencePathIntention", "isAvailable"));
        }
        PsiFile containingFile = element.getContainingFile();
        if (!(containingFile instanceof JSFile && element.getParent() instanceof JSReferenceExpression && DialectDetector.isTypeScript(element))) {
            return false;
        }
        PsiElement resolve = ((JSReferenceExpression)element.getParent()).resolve();
        if (resolve == null) {
            return false;
        }
        PsiFile referencedFile = resolve.getContainingFile();
        PsiFile currentFile = element.getContainingFile();
        if (referencedFile == null || currentFile == null) {
            return false;
        }
        if (referencedFile.isEquivalentTo((PsiElement)currentFile) || JavaScriptIndex.LIBS_D_TS.contains(referencedFile.getName())) {
            return false;
        }
        PsiElement currentElement = element.getParent().getParent().getFirstChild();
        while (true) {
            PsiElement nextSibling;
            TypeScriptExternalModuleReference externalModuleReference;
            if (currentElement instanceof PsiComment) {
                PsiFile file = TypeScriptReferenceContributor.findReferencedFile((PsiComment)currentElement);
                if (file != null && file.isEquivalentTo((PsiElement)referencedFile)) {
                    return false;
                }
            } else if (currentElement instanceof TypeScriptImportStatement && (externalModuleReference = ((TypeScriptImportStatement)currentElement).getExternalModuleReference()) != null) {
                ResolveResult[] resolveResults;
                for (ResolveResult resolveResult : resolveResults = externalModuleReference.multiResolve()) {
                    PsiElement importResolve = resolveResult.getElement();
                    if (!(importResolve instanceof PsiFile) || !importResolve.isEquivalentTo((PsiElement)referencedFile)) continue;
                    return false;
                }
            }
            if ((nextSibling = currentElement.getNextSibling()) != null) {
                currentElement = nextSibling;
                continue;
            }
            PsiElement parent = currentElement.getParent();
            if (parent instanceof PsiFile) {
                return true;
            }
            PsiElement grandParent = parent.getParent();
            if (grandParent == null) {
                return true;
            }
            currentElement = grandParent.getFirstChild();
        }
    }

    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"ts.generate.reference.path.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/intentions/TypeScriptGenerateReferencePathIntention", "getFamilyName"));
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/intentions/TypeScriptGenerateReferencePathIntention", "getText"));
        }
        return string;
    }
}

