/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.structureView;

import com.intellij.lang.javascript.documentation.JSSymbolPresentationUtils;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSNamedElementBase;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCallSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.structureView.JSStructureItemPresentation;
import com.intellij.lang.javascript.structureView.JSStructureViewElement;
import com.intellij.psi.PsiElement;

class TypeScriptStructureItemPresentation
extends JSStructureItemPresentation {
    public TypeScriptStructureItemPresentation(JSStructureViewElement jsStructureViewElement) {
        super(jsStructureViewElement);
    }

    @Override
    protected String buildPresentationForElement(PsiElement psiElement) {
        String presentation = null;
        if (psiElement instanceof TypeScriptCallSignature) {
            presentation = ((TypeScriptCallSignature)psiElement).isConstructor() ? "new" : "";
            presentation = presentation + JSSymbolPresentationUtils.buildFunctionSignaturePresentation((JSFunctionItem)((JSFunction)psiElement));
        } else if (psiElement instanceof TypeScriptPropertySignature) {
            presentation = JSPsiImplUtils.getNameOrComputedPropertyName((JSNamedElementBase)((TypeScriptPropertySignature)psiElement));
            JSTypeDeclaration type = ((TypeScriptPropertySignature)psiElement).getTypeDeclaration();
            if (type != null && !(type instanceof TypeScriptObjectType)) {
                presentation = presentation + ":" + TypeScriptTypeParser.buildTypeFromTypeScript(type).getTypeText(JSType.TypeTextFormat.PRESENTABLE);
            }
        }
        return presentation != null ? presentation : super.buildPresentationForElement(psiElement);
    }
}

