/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsconfig;

import com.intellij.json.JsonLanguage;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.Language;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class TypeScriptConfigUtil {
    @Nullable
    private static JsonProperty getFilesProperty(Project project, TypeScriptConfig config) {
        PsiFile file = PsiManager.getInstance((Project)project).findFile(config.getConfigFile());
        return TypeScriptConfigUtil.getFilesProperty(file);
    }

    @Nullable
    private static JsonProperty getFilesProperty(PsiFile file) {
        JsonObject jsonObject = (JsonObject)PsiTreeUtil.getChildOfType((PsiElement)file, JsonObject.class);
        if (jsonObject == null) {
            return null;
        }
        return jsonObject.findProperty("files");
    }

    public static boolean addVirtualFileToConfigFiles(Project project, VirtualFile file, TypeScriptConfig config) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        assert (!config.isDirectoryBased());
        JsonProperty property = TypeScriptConfigUtil.getFilesProperty(project, config);
        if (property == null) {
            return false;
        }
        JsonArray value = (JsonArray)property.getValue();
        if (value == null) {
            return false;
        }
        List list = value.getValueList();
        if (list.isEmpty()) {
            return false;
        }
        String text = value.getText();
        StringBuilder builder = new StringBuilder(text);
        String path = VfsUtil.getPath((VirtualFile)config.getConfigFile(), (VirtualFile)file, (char)(text.indexOf("/") > 0 ? (char)'/' : (char)File.separatorChar));
        int i = text.lastIndexOf("]");
        builder.insert(i, ",\"" + path + "\"");
        value.replace((PsiElement)TypeScriptConfigUtil.createJSONAndGetPropertyValue(project, builder.toString()));
        return true;
    }

    private static JsonValue createJSONAndGetPropertyValue(Project project, String propertyValue) {
        String json = String.format("{ \"files\":%s }", propertyValue);
        PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText((Language)JsonLanguage.INSTANCE, (CharSequence)json);
        JsonProperty property = TypeScriptConfigUtil.getFilesProperty(psiFile);
        assert (property != null);
        return property.getValue();
    }

    public static String getOutDirectory(VirtualFile baseFile, String relativeOrAbsolutePath) {
        if (StringUtil.isEmpty((String)relativeOrAbsolutePath)) {
            return null;
        }
        if (FileUtil.isAbsolute((String)relativeOrAbsolutePath)) {
            return relativeOrAbsolutePath;
        }
        VirtualFile file = VfsUtil.findRelativeFile((VirtualFile)baseFile, (String[])ArrayUtil.toStringArray((Collection)FileUtil.splitPath((String)FileUtil.toCanonicalPath((String)relativeOrAbsolutePath))));
        return file == null ? null : file.getCanonicalPath();
    }
}

