/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.tokenindex;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.tokenindex.AnonymToken;
import com.intellij.tokenindex.IndentToken;
import com.intellij.tokenindex.RecursiveTokenizingVisitor;
import com.intellij.tokenindex.TextToken;
import com.intellij.tokenindex.Token;
import com.intellij.tokenindex.Tokenizer;
import org.jetbrains.annotations.NotNull;

public class JavaScriptTokenizer
implements Tokenizer {
    private static final byte EXPRESSION_TYPE = 0;
    private static final byte IDENTIFIER_TYPE = 1;
    private static final byte PARAM_LIST_TYPE = 2;
    private final MyVisitor myVisitor = new MyVisitor();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean visit(@NotNull PsiElement node, RecursiveTokenizingVisitor globalVisitor) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/structuralsearch/tokenindex/JavaScriptTokenizer", "visit"));
        }
        try {
            this.myVisitor.myGlobalVisitor = globalVisitor;
            this.myVisitor.myToVisitChildren = false;
            node.accept((PsiElementVisitor)this.myVisitor);
            boolean bl = this.myVisitor.myToVisitChildren;
            return bl;
        }
        finally {
            this.myVisitor.myGlobalVisitor = null;
        }
    }

    public void elementFinished(@NotNull PsiElement element, RecursiveTokenizingVisitor globalVisitor) {
        PsiElement parent;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/structuralsearch/tokenindex/JavaScriptTokenizer", "elementFinished"));
        }
        if (element instanceof JSStatement && ((parent = element.getParent()) instanceof JSIfStatement || parent instanceof JSLoopStatement)) {
            globalVisitor.addToken((Token)new IndentToken(-1, globalVisitor.getBaseOffset() + element.getTextRange().getEndOffset()));
        }
    }

    private static class MyVisitor
    extends JSElementVisitor {
        private RecursiveTokenizingVisitor myGlobalVisitor;
        private boolean myToVisitChildren;

        private MyVisitor() {
        }

        public void visitElement(PsiElement element) {
            this.myToVisitChildren = true;
            if (element instanceof LeafPsiElement && !(element instanceof PsiWhiteSpace) && !(element instanceof PsiComment)) {
                this.visitLeafElement((LeafPsiElement)element);
            }
        }

        public void visitJSExpression(JSExpression expression) {
            TextRange range = expression.getTextRange();
            this.myGlobalVisitor.getTokens().add(new AnonymToken(0, this.myGlobalVisitor.getBaseOffset() + range.getStartOffset(), this.myGlobalVisitor.getBaseOffset() + range.getEndOffset()));
        }

        public void visitJSParameterList(JSParameterList node) {
            TextRange range = node.getTextRange();
            this.myGlobalVisitor.addToken((Token)new AnonymToken(2, this.myGlobalVisitor.getBaseOffset() + range.getStartOffset(), this.myGlobalVisitor.getBaseOffset() + range.getEndOffset()));
        }

        private void visitLeafElement(LeafPsiElement element) {
            JSStatement[] statements;
            PsiElement parent;
            if (element.getTextLength() == 0) {
                return;
            }
            IElementType type = element.getElementType();
            if (type == JSTokenTypes.IDENTIFIER) {
                TextRange range = element.getTextRange();
                this.myGlobalVisitor.addToken((Token)new AnonymToken(1, this.myGlobalVisitor.getBaseOffset() + range.getStartOffset(), this.myGlobalVisitor.getBaseOffset() + range.getEndOffset()));
                return;
            }
            if ((type == JSTokenTypes.LBRACE || type == JSTokenTypes.RBRACE) && (parent = element.getParent()) instanceof JSBlockStatement && (statements = ((JSBlockStatement)parent).getStatements()).length == 1 && ((parent = parent.getParent()) instanceof JSIfStatement || parent instanceof JSLoopStatement)) {
                return;
            }
            TextRange range = element.getTextRange();
            this.myGlobalVisitor.addToken((Token)new TextToken(element.getText().hashCode(), this.myGlobalVisitor.getBaseOffset() + range.getStartOffset(), this.myGlobalVisitor.getBaseOffset() + range.getEndOffset()));
        }
    }
}

