/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.moveattributeout;

import com.intellij.openapi.help.HelpManager;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.sixrr.xrp.base.BaseRefactoringDialog;
import com.sixrr.xrp.ui.ScopePanel;
import javax.swing.JComponent;
import javax.swing.JLabel;

class MoveAttributeOutDialog
extends BaseRefactoringDialog {
    private final JLabel attributeNameLabel = new JLabel();
    private final XmlAttribute attribute;

    MoveAttributeOutDialog(XmlAttribute attribute) {
        super(attribute.getProject(), true);
        this.setTitle("Move Attribute Out");
        this.attribute = attribute;
        XmlTag tag = attribute.getParent();
        XmlFile containingFile = (XmlFile)tag.getContainingFile();
        this.scopePanel = new ScopePanel(containingFile, this);
        this.init();
        String attributeName = attribute.getName();
        String tagName = tag.getName();
        this.attributeNameLabel.setText("Move attribute " + attributeName + " out from tag " + tagName);
    }

    @Override
    protected String getDimensionServiceKey() {
        return "RefactorX.MoveAttributeOut";
    }

    protected JComponent createNorthPanel() {
        return this.attributeNameLabel;
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    @Override
    protected boolean isValid() {
        return this.scopePanel.isScopeValid();
    }

    @Override
    protected String calculateXSLT() {
        String tagName = this.attribute.getParent().getName();
        String attributeName = this.attribute.getName();
        return "<xsl:template match=\"*[child::" + tagName + "/@" + attributeName + "]\">\n" + "\t<xsl:copy> \n" + "\t\t<xsl:attribute name = \"" + attributeName + "\">\n" + "\t\t\t<xsl:value-of select=\"" + tagName + "/@" + attributeName + "\"/>\n" + "\t\t</xsl:attribute>\n" + "\t\t<xsl:apply-templates select=\"@*|node()\"/>\n" + "\t</xsl:copy>\n" + "</xsl:template>  \n" + "<xsl:template match = \"@" + attributeName + "[parent::" + tagName + "]\"/>";
    }

    @Override
    protected void doHelpAction() {
        HelpManager helpManager = HelpManager.getInstance();
        helpManager.invokeHelp("refactoring.moveAttributeOut");
    }
}

