/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.renametag;

import com.intellij.openapi.help.HelpManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.border.IdeaTitledBorder;
import com.sixrr.xrp.base.BaseRefactoringDialog;
import com.sixrr.xrp.ui.ScopePanel;
import com.sixrr.xrp.utils.XMLUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.text.Document;

class RenameTagDialog
extends BaseRefactoringDialog {
    private final JLabel tagNameLabel = new JLabel();
    private final JTextField newTagField;
    private final XmlTag tag;

    RenameTagDialog(XmlTag tag) {
        super(tag.getProject(), true);
        this.tag = tag;
        String tagName = tag.getName();
        XmlFile containingFile = (XmlFile)tag.getContainingFile();
        this.scopePanel = new ScopePanel(containingFile, this);
        this.setTitle("Rename Tag");
        this.tagNameLabel.setText("New name for tag " + tagName);
        this.newTagField = new JTextField("");
        Document document = this.newTagField.getDocument();
        document.addDocumentListener(this.docListener);
        this.init();
        this.validateButtons();
    }

    @Override
    protected String getDimensionServiceKey() {
        return "RefactorX.RenameTag";
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.newTagField;
    }

    public String getNewTagName() {
        String text = this.newTagField.getText();
        return text.trim();
    }

    protected JComponent createNorthPanel() {
        String tagName = this.tag.getName();
        JPanel panel = new JPanel(new BorderLayout());
        IdeaTitledBorder border = IdeBorderFactory.createTitledBorder((String)("Change name of tag " + tagName), (boolean)true);
        panel.add((Component)this.tagNameLabel, "North");
        Box box = Box.createVerticalBox();
        panel.setBorder((Border)border);
        this.newTagField.setEditable(true);
        box.add(this.newTagField);
        panel.add((Component)box, "Center");
        return panel;
    }

    @Override
    protected boolean isValid() {
        String tagName = this.getNewTagName();
        boolean tagNameEntered = XMLUtil.tagNameIsValid(tagName);
        boolean scopeIsValid = this.scopePanel.isScopeValid();
        return tagNameEntered && scopeIsValid;
    }

    @Override
    protected String calculateXSLT() {
        String tagName = this.tag.getName();
        String newTagName = this.getNewTagName();
        return " <xsl:template match=\"" + tagName + "\">\n" + "/t<xsl:tag name=\"" + newTagName + "\">\n" + "/t/t<xsl:value-of select=\".\" />\n" + "/t</xsl:tag>\n" + " </xsl:template>";
    }

    @Override
    protected void doHelpAction() {
        HelpManager helpManager = HelpManager.getInstance();
        helpManager.invokeHelp("refactoring.renameTag");
    }
}

