/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.j2k;

import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.KotlinOutOfBlockCompletionModificationTracker;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.conversion.copy.RangeUtilsKt;
import org.jetbrains.kotlin.idea.j2k.J2KPostProcessingRegistrar;
import org.jetbrains.kotlin.idea.j2k.J2kPostProcessing;
import org.jetbrains.kotlin.idea.util.ImportDescriptorResult;
import org.jetbrains.kotlin.idea.util.ImportInsertHelper;
import org.jetbrains.kotlin.j2k.PostProcessor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0019\u001aB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J,\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\f2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J\u001a\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0018\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001a\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/j2k/J2kPostProcessor;", "Lorg/jetbrains/kotlin/j2k/PostProcessor;", "formatCode", "", "(Z)V", "analyzeFileRange", "Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "rangeMarker", "Lcom/intellij/openapi/editor/RangeMarker;", "collectAvailableActions", "Ljava/util/LinkedHashMap;", "Lorg/jetbrains/kotlin/psi/KtElement;", "Lcom/intellij/util/SmartList;", "Lorg/jetbrains/kotlin/idea/j2k/J2kPostProcessor$ActionData;", "doAdditionalProcessing", "", "insertImport", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "rangeFilter", "Lorg/jetbrains/kotlin/idea/j2k/J2kPostProcessor$RangeFilterResult;", "element", "Lcom/intellij/psi/PsiElement;", "ActionData", "RangeFilterResult", "idea"})
public final class J2kPostProcessor
implements PostProcessor {
    private final boolean formatCode;

    /*
     * WARNING - void declaration
     */
    @Override
    public void insertImport(@NotNull KtFile file, @NotNull FqName fqName2) {
        ImportDescriptorResult importDescriptorResult;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
        Collection<DeclarationDescriptor> descriptors = ResolutionUtils.resolveImportReference(file, fqName2);
        DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)CollectionsKt.firstOrNull((Iterable)descriptors);
        if (declarationDescriptor != null) {
            void $receiver$iv;
            DeclarationDescriptor declarationDescriptor2 = declarationDescriptor;
            DeclarationDescriptor it = (DeclarationDescriptor)$receiver$iv;
            Project project = file.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"file.project");
            importDescriptorResult = ImportInsertHelper.importDescriptor$default(ImportInsertHelper.Companion.getInstance(project), file, it, false, 4, null);
        } else {
            importDescriptorResult = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void doAdditionalProcessing(@NotNull KtFile file, @Nullable RangeMarker rangeMarker) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        LinkedHashMap<KtElement, SmartList<ActionData>> elementToActions = this.collectAvailableActions(file, rangeMarker);
        while (true) {
            void $receiver$iv;
            void $receiver$iv2;
            Map map2 = elementToActions;
            if (!(!$receiver$iv2.isEmpty())) break;
            Long modificationStamp = file.getModificationStamp();
            Map map3 = elementToActions;
            Iterator iterator2 = $receiver$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                void $receiver$iv3;
                void $receiver$iv4;
                Map.Entry entry;
                Map.Entry $i$f$iterator = entry = iterator2.next();
                KtElement element2 = (KtElement)$receiver$iv4.getKey();
                Map.Entry $i$f$component1 = entry;
                SmartList actions2 = (SmartList)$receiver$iv3.getValue();
                for (ActionData actionData : actions2) {
                    Function0<Unit> action2 = actionData.component1();
                    J2kPostProcessing processing = actionData.component2();
                    if (element2.isValid()) {
                        action2.invoke();
                        continue;
                    }
                    modificationStamp = null;
                }
            }
            if (Intrinsics.areEqual((Object)modificationStamp, (Object)file.getModificationStamp())) break;
            Project project = file.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"file.project");
            KotlinOutOfBlockCompletionModificationTracker.Companion.getInstance(project).incModificationCount();
            elementToActions = this.collectAvailableActions(file, rangeMarker);
        }
        if (this.formatCode) {
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)file.getProject());
            if (rangeMarker != null) {
                if (rangeMarker.isValid()) {
                    codeStyleManager.reformatRange((PsiElement)file, rangeMarker.getStartOffset(), rangeMarker.getEndOffset());
                }
            } else {
                codeStyleManager.reformat((PsiElement)file);
            }
        }
    }

    private final LinkedHashMap<KtElement, SmartList<ActionData>> collectAvailableActions(KtFile file, RangeMarker rangeMarker) {
        Diagnostics diagnostics = this.analyzeFileRange(file, rangeMarker);
        LinkedHashMap<KtElement, SmartList<ActionData>> elementToActions = new LinkedHashMap<KtElement, SmartList<ActionData>>();
        file.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(this, rangeMarker, diagnostics, elementToActions){
            final /* synthetic */ J2kPostProcessor this$0;
            final /* synthetic */ RangeMarker $rangeMarker;
            final /* synthetic */ Diagnostics $diagnostics;
            final /* synthetic */ LinkedHashMap $elementToActions;

            /*
             * WARNING - void declaration
             */
            public void visitElement(@NotNull PsiElement element2) {
                Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
                if (element2 instanceof KtElement) {
                    RangeFilterResult rangeResult = J2kPostProcessor.access$rangeFilter(this.this$0, element2, this.$rangeMarker);
                    if (Intrinsics.areEqual((Object)((Object)rangeResult), (Object)((Object)RangeFilterResult.SKIP))) {
                        return;
                    }
                    super.visitElement(element2);
                    if (Intrinsics.areEqual((Object)((Object)rangeResult), (Object)((Object)RangeFilterResult.PROCESS))) {
                        Iterable $receiver$iv = J2KPostProcessingRegistrar.INSTANCE.getProcessings();
                        for (T element$iv : $receiver$iv) {
                            J2kPostProcessing processing = (J2kPostProcessing)element$iv;
                            Function0<Unit> action2 = processing.createAction((KtElement)element2, this.$diagnostics);
                            if (action2 != null) {
                                Object object;
                                void key$iv;
                                void $receiver$iv2;
                                Map map2 = this.$elementToActions;
                                PsiElement psiElement2 = element2;
                                V value$iv = $receiver$iv2.get(key$iv);
                                if (value$iv == null) {
                                    SmartList answer$iv = new SmartList();
                                    $receiver$iv2.put(key$iv, answer$iv);
                                    object = answer$iv;
                                } else {
                                    object = value$iv;
                                }
                                ((SmartList)object).add((Object)new ActionData(action2, processing));
                            }
                        }
                    }
                }
            }
            {
                this.this$0 = $outer;
                this.$rangeMarker = $captured_local_variable$1;
                this.$diagnostics = $captured_local_variable$2;
                this.$elementToActions = $captured_local_variable$3;
            }
        });
        return elementToActions;
    }

    /*
     * WARNING - void declaration
     */
    private final Diagnostics analyzeFileRange(KtFile file, RangeMarker rangeMarker) {
        Diagnostics diagnostics;
        Collection $receiver$iv;
        List list2;
        if (rangeMarker == null) {
            list2 = CollectionsKt.listOf((Object)file);
        } else {
            void destination$iv$iv;
            void $receiver$iv$iv;
            PsiFile psiFile = (PsiFile)file;
            TextRange textRange = RangeUtilsKt.getRange(rangeMarker);
            if (textRange == null) {
                Intrinsics.throwNpe();
            }
            Iterable iterable = PsiUtilsKt.elementsInRange(psiFile, textRange);
            Collection collection = $receiver$iv;
            Collection collection2 = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                if (!(element$iv$iv instanceof KtElement)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        }
        List elements = list2;
        $receiver$iv = elements;
        if (!$receiver$iv.isEmpty()) {
            Diagnostics diagnostics2 = ResolutionUtils.getResolutionFacade(file).analyzeFullyAndGetResult(elements).getBindingContext().getDiagnostics();
            diagnostics = diagnostics2;
            Intrinsics.checkExpressionValueIsNotNull((Object)diagnostics2, (String)"file.getResolutionFacade\u2026indingContext.diagnostics");
        } else {
            diagnostics = Diagnostics.Companion.getEMPTY();
        }
        return diagnostics;
    }

    private final RangeFilterResult rangeFilter(PsiElement element2, RangeMarker rangeMarker) {
        TextRange elementRange;
        if (rangeMarker == null) {
            return RangeFilterResult.PROCESS;
        }
        if (!rangeMarker.isValid()) {
            return RangeFilterResult.SKIP;
        }
        TextRange range = new TextRange(rangeMarker.getStartOffset(), rangeMarker.getEndOffset());
        return range.contains(elementRange = element2.getTextRange()) ? RangeFilterResult.PROCESS : (range.intersects(elementRange) ? RangeFilterResult.GO_INSIDE : RangeFilterResult.SKIP);
    }

    public J2kPostProcessor(boolean formatCode) {
        this.formatCode = formatCode;
    }

    @NotNull
    public static final /* synthetic */ RangeFilterResult access$rangeFilter(J2kPostProcessor $this, @NotNull PsiElement element2, @Nullable RangeMarker rangeMarker) {
        return $this.rangeFilter(element2, rangeMarker);
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/j2k/J2kPostProcessor$RangeFilterResult;", "", "(Ljava/lang/String;I)V", "SKIP", "GO_INSIDE", "PROCESS", "idea"})
    private static final class RangeFilterResult
    extends Enum<RangeFilterResult> {
        public static final /* enum */ RangeFilterResult SKIP;
        public static final /* enum */ RangeFilterResult GO_INSIDE;
        public static final /* enum */ RangeFilterResult PROCESS;
        private static final /* synthetic */ RangeFilterResult[] $VALUES;

        static {
            RangeFilterResult[] rangeFilterResultArray = new RangeFilterResult[3];
            RangeFilterResult[] rangeFilterResultArray2 = rangeFilterResultArray;
            rangeFilterResultArray[0] = SKIP = new RangeFilterResult();
            rangeFilterResultArray[1] = GO_INSIDE = new RangeFilterResult();
            rangeFilterResultArray[2] = PROCESS = new RangeFilterResult();
            $VALUES = rangeFilterResultArray;
        }

        public static RangeFilterResult[] values() {
            return (RangeFilterResult[])$VALUES.clone();
        }

        public static RangeFilterResult valueOf(String string) {
            return Enum.valueOf(RangeFilterResult.class, string);
        }
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0082\b\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/j2k/J2kPostProcessor$ActionData;", "", "action", "Lkotlin/Function0;", "", "processing", "Lorg/jetbrains/kotlin/idea/j2k/J2kPostProcessing;", "(Lkotlin/jvm/functions/Function0;Lorg/jetbrains/kotlin/idea/j2k/J2kPostProcessing;)V", "getAction", "()Lkotlin/jvm/functions/Function0;", "getProcessing", "()Lorg/jetbrains/kotlin/idea/j2k/J2kPostProcessing;", "component1", "component2", "copy", "idea"})
    private static final class ActionData {
        @NotNull
        private final Function0<Unit> action;
        @NotNull
        private final J2kPostProcessing processing;

        @NotNull
        public final Function0<Unit> getAction() {
            return this.action;
        }

        @NotNull
        public final J2kPostProcessing getProcessing() {
            return this.processing;
        }

        public ActionData(@NotNull Function0<Unit> action2, @NotNull J2kPostProcessing processing) {
            Intrinsics.checkParameterIsNotNull(action2, (String)"action");
            Intrinsics.checkParameterIsNotNull((Object)processing, (String)"processing");
            this.action = action2;
            this.processing = processing;
        }

        @NotNull
        public final Function0<Unit> component1() {
            return this.action;
        }

        @NotNull
        public final J2kPostProcessing component2() {
            return this.processing;
        }

        @NotNull
        public final ActionData copy(@NotNull Function0<Unit> action2, @NotNull J2kPostProcessing processing) {
            Intrinsics.checkParameterIsNotNull(action2, (String)"action");
            Intrinsics.checkParameterIsNotNull((Object)processing, (String)"processing");
            return new ActionData(action2, processing);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ ActionData copy$default(ActionData actionData, Function0 function0, J2kPostProcessing j2kPostProcessing, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copy");
            }
            if ((n & 1) != 0) {
                function0 = actionData.action;
            }
            if ((n & 2) != 0) {
                j2kPostProcessing = actionData.processing;
            }
            return actionData.copy(function0, j2kPostProcessing);
        }

        public String toString() {
            return "ActionData(action=" + this.action + ", processing=" + this.processing + ")";
        }

        public int hashCode() {
            Function0<Unit> function0 = this.action;
            J2kPostProcessing j2kPostProcessing = this.processing;
            return (function0 != null ? function0.hashCode() : 0) * 31 + (j2kPostProcessing != null ? j2kPostProcessing.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ActionData)) break block3;
                    ActionData actionData = (ActionData)object;
                    if (!Intrinsics.areEqual(this.action, actionData.action) || !Intrinsics.areEqual((Object)this.processing, (Object)actionData.processing)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

