/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jam.model.util;

import com.intellij.ide.DeleteProvider;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.jam.JamChief;
import com.intellij.jam.JamConverter;
import com.intellij.jam.JamElement;
import com.intellij.jam.JamPomTarget;
import com.intellij.jam.JamService;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.model.common.CommonDomModelElement;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.model.common.CommonModelTarget;
import com.intellij.jam.reflect.JamAnnotationAttributeMeta;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamClassMeta;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.jam.view.JamDeleteProvider;
import com.intellij.jam.view.tree.JamNodeDescriptor;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomTarget;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.ModelMergerUtil;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JamCommonUtil {
    @NonNls
    public static final String VALUE_PARAMETER = "value";
    private static final TObjectHashingStrategy<PsiClass> HASHING_STRATEGY = new TObjectHashingStrategy<PsiClass>(){

        public int computeHashCode(PsiClass object) {
            String qualifiedName = object.getQualifiedName();
            return qualifiedName == null ? 0 : qualifiedName.hashCode();
        }

        public boolean equals(PsiClass o1, PsiClass o2) {
            return Comparing.equal((String)o1.getQualifiedName(), (String)o2.getQualifiedName());
        }
    };
    private static final Key<CachedValue<Module[]>> MODULE_DEPENDENCIES = Key.create((String)"MODULE_DEPENDENCIES");
    private static final Key<CachedValue<Module[]>> MODULE_DEPENDENTS = Key.create((String)"MODULE_DEPENDENTS");

    @Nullable
    public static Object computeMemberValue(@Nullable PsiElement value) {
        if (value == null) {
            return null;
        }
        if (value instanceof XmlAttributeValue) {
            GenericAttributeValue genericValue = DomManager.getDomManager(value.getProject()).getDomElement((XmlAttribute)value.getParent());
            return genericValue != null ? genericValue.getValue() : ((XmlAttributeValue)value).getValue();
        }
        try {
            return JavaPsiFacade.getInstance(value.getProject()).getConstantEvaluationHelper().computeConstantExpression(value, false);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return null;
        }
    }

    public static boolean isSuperClass(@Nullable PsiClass firstClass, final String superClassQName) {
        return !JamCommonUtil.processSuperClassList(firstClass, (Collection<PsiClass>)new SmartList(), new Processor<PsiClass>(){

            public boolean process(PsiClass superClass) {
                return !Comparing.equal((String)superClass.getQualifiedName(), (String)superClassQName);
            }
        });
    }

    @NotNull
    public static List<PsiClass> getSuperClassList(@Nullable PsiClass firstClass) {
        SmartList list = new SmartList();
        JamCommonUtil.processSuperClassList(firstClass, (Collection<PsiClass>)list, (Processor<PsiClass>)CommonProcessors.alwaysTrue());
        SmartList smartList = list;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jam/model/util/JamCommonUtil", "getSuperClassList"));
        }
        return smartList;
    }

    public static boolean processSuperClassList(@Nullable PsiClass firstClass, @NotNull Collection<PsiClass> supers, Processor<PsiClass> processor) {
        if (supers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supers", "com/intellij/jam/model/util/JamCommonUtil", "processSuperClassList"));
        }
        for (PsiClass curClass = firstClass; curClass != null && !"java.lang.Object".equals(curClass.getQualifiedName()) && !supers.contains(curClass); curClass = curClass.getSuperClass()) {
            ProgressManager.checkCanceled();
            if (!processor.process((Object)curClass)) {
                return false;
            }
            supers.add(curClass);
        }
        return true;
    }

    @Nullable
    public static <T> T getRootElement(PsiFile file, Class<T> domClass, Module module) {
        if (!(file instanceof XmlFile)) {
            return null;
        }
        DomManager domManager = DomManager.getDomManager(file.getProject());
        DomFileElement<DomElement> element = domManager.getFileElement((XmlFile)file, DomElement.class);
        if (element == null) {
            return null;
        }
        DomElement root = element.getRootElement();
        if (!ReflectionUtil.isAssignable(domClass, root.getClass())) {
            return null;
        }
        return (T)root;
    }

    @Nullable
    public static String getDisplayName(Object element) {
        if (element instanceof CommonModelElement) {
            CommonModelElement modelElement = (CommonModelElement)element;
            String name = JamCommonUtil.getElementName(modelElement);
            if (name == null) {
                name = "";
            }
            return JamCommonUtil.getClassName(modelElement) + " '" + name + "'";
        }
        return null;
    }

    @Nullable
    public static String getElementName(CommonModelElement element) {
        return ElementPresentationManager.getElementName(element);
    }

    public static String getClassName(CommonModelElement element) {
        return ElementPresentationManager.getTypeNameForObject(element);
    }

    @Nullable
    public static Module findModuleForPsiElement(PsiElement element) {
        Module module;
        DomFileElement<CommonDomModelElement> domFileElement;
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null) {
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile(element);
            return virtualFile == null ? null : ProjectRootManager.getInstance(element.getProject()).getFileIndex().getModuleForFile(virtualFile);
        }
        if ((psiFile = psiFile.getOriginalFile()) instanceof XmlFile && (domFileElement = DomManager.getDomManager(element.getProject()).getFileElement((XmlFile)psiFile, CommonDomModelElement.class)) != null && (module = domFileElement.getRootElement().getModule()) != null) {
            return module;
        }
        return ModuleUtilCore.findModuleForPsiElement(psiFile);
    }

    @NotNull
    public static PsiElement[] getTargetPsiElements(CommonModelElement element) {
        ArrayList<PsiElement> list = new ArrayList<PsiElement>();
        for (CommonModelElement modelElement : ModelMergerUtil.getFilteredImplementations(element)) {
            if (modelElement instanceof DomElement) {
                DomElement domModelElement = (DomElement)((Object)modelElement);
                if (domModelElement.getXmlTag() == null) continue;
                list.add(domModelElement.getXmlTag());
                continue;
            }
            if (modelElement instanceof JamChief) {
                list.add(((JamChief)((Object)modelElement)).getPsiElement());
                continue;
            }
            ContainerUtil.addIfNotNull((Object)modelElement.getIdentifyingPsiElement(), list);
        }
        PsiElement[] result = list.isEmpty() ? PsiElement.EMPTY_ARRAY : PsiUtilCore.toPsiElementArray(list);
        Arrays.sort(result, new Comparator<PsiElement>(){

            @Override
            public int compare(@NotNull PsiElement o1, @NotNull PsiElement o2) {
                if (o1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "com/intellij/jam/model/util/JamCommonUtil$3", "compare"));
                }
                if (o2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "com/intellij/jam/model/util/JamCommonUtil$3", "compare"));
                }
                return this.getWeight(o1) - this.getWeight(o2);
            }

            private int getWeight(PsiElement o) {
                if (o instanceof XmlTag) {
                    return 0;
                }
                if (o instanceof PsiMember) {
                    return 1;
                }
                if (o instanceof PsiAnnotation) {
                    return 2;
                }
                return 3;
            }
        });
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jam/model/util/JamCommonUtil", "getTargetPsiElements"));
        }
        return result;
    }

    @Contract(value="null -> false")
    public static boolean isInLibrary(CommonModelElement modelElement) {
        if (modelElement == null) {
            return false;
        }
        PsiElement psiElement = modelElement.getIdentifyingPsiElement();
        if (psiElement == null) {
            return false;
        }
        PsiFile psiFile = psiElement.getContainingFile();
        if (psiFile == null) {
            return false;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        return ProjectRootManager.getInstance(modelElement.getPsiManager().getProject()).getFileIndex().isInLibraryClasses(virtualFile);
    }

    @Contract(value="null -> false")
    public static boolean isKindOfJavaFile(PsiElement element) {
        return element instanceof PsiJavaFile && element.getLanguage().isKindOf(StdLanguages.JAVA);
    }

    @Contract(value="null -> false")
    public static boolean isPlainJavaFile(PsiElement element) {
        return JamCommonUtil.isKindOfJavaFile(element) && ((PsiFile)element).getFileType() == StdFileTypes.JAVA;
    }

    @Contract(value="null -> false")
    public static boolean isPlainXmlFile(PsiElement element) {
        return element instanceof XmlFile && element.getLanguage() == StdLanguages.XML;
    }

    @NotNull
    public static Module[] getAllModuleDependencies(final @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/jam/model/util/JamCommonUtil", "getAllModuleDependencies"));
        }
        Module[] moduleArray = CachedValuesManager.getManager(module.getProject()).getCachedValue(module, MODULE_DEPENDENCIES, new CachedValueProvider<Module[]>(){

            @Override
            public CachedValueProvider.Result<Module[]> compute() {
                Set<Module> result = JamCommonUtil.addModuleDependencies(module, (Set<Module>)new THashSet(), false);
                return new CachedValueProvider.Result<Module[]>(result.toArray(new Module[result.size()]), ProjectRootManager.getInstance(module.getProject()));
            }
        }, false);
        if (moduleArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jam/model/util/JamCommonUtil", "getAllModuleDependencies"));
        }
        return moduleArray;
    }

    @NotNull
    public static Module[] getAllDependentModules(final @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/jam/model/util/JamCommonUtil", "getAllDependentModules"));
        }
        Module[] moduleArray = CachedValuesManager.getManager(module.getProject()).getCachedValue(module, MODULE_DEPENDENTS, new CachedValueProvider<Module[]>(){

            @Override
            public CachedValueProvider.Result<Module[]> compute() {
                Module[] modules = ModuleManager.getInstance(module.getProject()).getModules();
                Set<Module> result = JamCommonUtil.addModuleDependents(module, (Set<Module>)new THashSet(), modules);
                return new CachedValueProvider.Result<Module[]>(result.toArray(new Module[result.size()]), ProjectRootManager.getInstance(module.getProject()));
            }
        }, false);
        if (moduleArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jam/model/util/JamCommonUtil", "getAllDependentModules"));
        }
        return moduleArray;
    }

    public static Set<Module> addModuleDependencies(Module module, Set<Module> result, boolean exported) {
        OrderEntry[] orderEntries;
        if (module.isDisposed()) {
            return Collections.emptySet();
        }
        for (OrderEntry orderEntry : orderEntries = ModuleRootManager.getInstance(module).getOrderEntries()) {
            Module exportedModule;
            if (!orderEntry.isValid() || !(orderEntry instanceof ModuleOrderEntry) || exported && !((ModuleOrderEntry)orderEntry).isExported() || !result.add(exportedModule = ((ModuleOrderEntry)orderEntry).getModule())) continue;
            JamCommonUtil.addModuleDependencies(exportedModule, result, true);
        }
        return result;
    }

    public static Set<Module> addModuleDependents(Module module, Set<Module> result, Module[] modules) {
        if (!result.add(module)) {
            return result;
        }
        for (Module allModule : modules) {
            OrderEntry[] orderEntries;
            for (OrderEntry orderEntry : orderEntries = ModuleRootManager.getInstance(allModule).getOrderEntries()) {
                Module exportedModule;
                if (!orderEntry.isValid() || !(orderEntry instanceof ModuleOrderEntry) || (exportedModule = ((ModuleOrderEntry)orderEntry).getModule()) != module || !result.add(allModule) || !((ModuleOrderEntry)orderEntry).isExported()) continue;
                JamCommonUtil.addModuleDependents(allModule, result, modules);
            }
        }
        return result;
    }

    @NotNull
    public static Collection<PsiClass> getAnnotationTypesWithChildren(String annotationName, Module module) {
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope(module, false);
        Collection<PsiClass> collection = JamCommonUtil.getAnnotationTypesWithChildren(annotationName, module.getProject(), scope);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jam/model/util/JamCommonUtil", "getAnnotationTypesWithChildren"));
        }
        return collection;
    }

    @NotNull
    private static Collection<PsiClass> getAnnotationTypesWithChildren(String annotationName, Project project, GlobalSearchScope scope) {
        PsiClass psiClass = JavaPsiFacade.getInstance(project).findClass(annotationName, scope);
        if (psiClass == null || !psiClass.isAnnotationType()) {
            List<PsiClass> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jam/model/util/JamCommonUtil", "getAnnotationTypesWithChildren"));
            }
            return list;
        }
        THashSet classes = new THashSet(HASHING_STRATEGY);
        JamCommonUtil.collectClassWithChildren(psiClass, (Set<PsiClass>)classes, scope);
        THashSet tHashSet = classes;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jam/model/util/JamCommonUtil", "getAnnotationTypesWithChildren"));
        }
        return tHashSet;
    }

    public static Collection<PsiClass> getAnnotationTypesWithChildren(Module module, Key<CachedValue<Collection<PsiClass>>> key, String annotationName) {
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope(module, false);
        return JamCommonUtil.getAnnotationTypesWithChildren(module, key, annotationName, scope);
    }

    public static Collection<PsiClass> getAnnotationTypesWithChildren(final Module module, Key<CachedValue<Collection<PsiClass>>> key, final String annotationName, final GlobalSearchScope scope) {
        return CachedValuesManager.getManager(module.getProject()).getCachedValue(module, key, new CachedValueProvider<Collection<PsiClass>>(){

            @Override
            public CachedValueProvider.Result<Collection<PsiClass>> compute() {
                Collection classes = JamCommonUtil.getAnnotationTypesWithChildren(annotationName, module.getProject(), scope);
                return new CachedValueProvider.Result<Collection<PsiClass>>(classes, PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT);
            }
        }, false);
    }

    private static void collectClassWithChildren(PsiClass psiClass, Set<PsiClass> classes, GlobalSearchScope scope) {
        classes.add(psiClass);
        for (PsiClass aClass : JamCommonUtil.getChildren(psiClass, scope)) {
            if (classes.contains(aClass)) continue;
            JamCommonUtil.collectClassWithChildren(aClass, classes, scope);
        }
    }

    public static Collection<PsiClass> getAnnotatedTypes(final Module module, Key<CachedValue<Collection<PsiClass>>> key, final String annotationName) {
        return CachedValuesManager.getManager(module.getProject()).getCachedValue(module, key, new CachedValueProvider<Collection<PsiClass>>(){

            @Override
            public CachedValueProvider.Result<Collection<PsiClass>> compute() {
                GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope(module, false);
                PsiClass psiClass = JavaPsiFacade.getInstance(module.getProject()).findClass(annotationName, scope);
                Collection<Object> classes = psiClass == null || !psiClass.isAnnotationType() ? Collections.emptyList() : JamCommonUtil.getChildren(psiClass, scope);
                return new CachedValueProvider.Result<Collection<PsiClass>>(classes, PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT);
            }
        }, false);
    }

    public static Set<PsiClass> getChildren(PsiClass psiClass, GlobalSearchScope scope) {
        if (!JamCommonUtil.isAcceptedFor(psiClass, ElementType.ANNOTATION_TYPE, ElementType.TYPE)) {
            return Collections.emptySet();
        }
        String name = psiClass.getQualifiedName();
        if (name == null) {
            return Collections.emptySet();
        }
        THashSet result = new THashSet(HASHING_STRATEGY);
        AnnotatedElementsSearch.searchPsiClasses(psiClass, scope).forEach(new Processor<PsiClass>((Set)result){
            final /* synthetic */ Set val$result;
            {
                this.val$result = set;
            }

            public boolean process(PsiClass processorResult) {
                if (processorResult.isAnnotationType()) {
                    this.val$result.add(processorResult);
                }
                return true;
            }
        });
        return result;
    }

    public static boolean isAcceptedFor(PsiClass psiClass, final ElementType ... elementTypes) {
        PsiAnnotation psiAnnotation;
        PsiModifierList modifierList = psiClass.getModifierList();
        PsiAnnotation psiAnnotation2 = psiAnnotation = modifierList == null ? null : modifierList.findAnnotation(Target.class.getName());
        if (psiAnnotation == null) {
            return false;
        }
        return !JamCommonUtil.processObjectArrayValue(psiAnnotation, VALUE_PARAMETER, new Processor<PsiAnnotationMemberValue>(){

            public boolean process(PsiAnnotationMemberValue value) {
                ElementType obj = JamCommonUtil.getObjectValue(value, ElementType.class);
                if (obj == null) {
                    return true;
                }
                for (ElementType type : elementTypes) {
                    if (!type.equals((Object)obj)) continue;
                    return false;
                }
                return true;
            }
        });
    }

    @Nullable
    public static XmlTag getXmlTag(CommonModelElement object) {
        DomElement dom = ModelMergerUtil.getImplementation(object, DomElement.class);
        return dom != null ? dom.getXmlTag() : null;
    }

    public static <M extends PsiModifierListOwner, V extends JamElement> List<V> getElementsIncludingSingle(M member, JamAnnotationMeta multiMeta, JamAnnotationAttributeMeta<V, List<V>> multiAttrMeta) {
        List multiValue = (List)multiMeta.getAttribute(member, multiAttrMeta);
        PsiElementRef<PsiAnnotation> singleAnno = multiAttrMeta.getAnnotationMeta().getAnnotationRef(member);
        return singleAnno.isImaginary() ? multiValue : ContainerUtil.concat(Collections.singletonList(multiAttrMeta.getInstantiator().instantiate(singleAnno)), (List)multiValue);
    }

    public static boolean isClassAvailable(Project project, String qName) {
        return JavaPsiFacade.getInstance(project).findClass(qName, GlobalSearchScope.allScope(project)) != null;
    }

    public static String getFirstRootAnnotation(JamMemberMeta<?, ?> meta) {
        List<JamAnnotationMeta> annos = meta == null ? null : meta.getAnnotations();
        return annos == null || annos.isEmpty() ? null : annos.get(0).getAnnoName();
    }

    @Nullable
    public static Object getModelObject(PsiElement element) {
        if (!(element instanceof PomTargetPsiElement)) {
            return null;
        }
        PomTarget target = ((PomTargetPsiElement)element).getTarget();
        return target instanceof CommonModelTarget ? ((CommonModelTarget)target).getCommonElement() : (target instanceof JamPomTarget ? ((JamPomTarget)target).getJamElement() : (target instanceof DomTarget ? ((DomTarget)target).getDomElement() : null));
    }

    @Nullable
    public static DeleteProvider createDeleteProvider(AbstractTreeBuilder builder) {
        final ArrayList<DeleteProvider> toRun = new ArrayList<DeleteProvider>();
        ArrayList<JamDeleteProvider> jamProviders = new ArrayList<JamDeleteProvider>();
        for (JamNodeDescriptor descriptor : builder.getSelectedElements(JamNodeDescriptor.class)) {
            DeleteProvider provider;
            DeleteProvider deleteProvider = provider = descriptor.isValid() ? (DeleteProvider)descriptor.getDataForElement(PlatformDataKeys.DELETE_ELEMENT_PROVIDER.getName()) : null;
            if (provider instanceof JamDeleteProvider) {
                jamProviders.add((JamDeleteProvider)provider);
                continue;
            }
            if (provider == null) continue;
            toRun.add(provider);
        }
        if (!jamProviders.isEmpty()) {
            if (jamProviders.size() == 1) {
                toRun.add((DeleteProvider)jamProviders.get(0));
            } else {
                toRun.add(new JamDeleteProvider(jamProviders));
            }
        }
        if (toRun.isEmpty()) {
            return null;
        }
        return new DeleteProvider(){

            @Override
            public void deleteElement(@NotNull DataContext dataContext) {
                if (dataContext == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/jam/model/util/JamCommonUtil$10", "deleteElement"));
                }
                for (DeleteProvider provider : toRun) {
                    provider.deleteElement(dataContext);
                }
            }

            @Override
            public boolean canDeleteElement(@NotNull DataContext dataContext) {
                if (dataContext == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/jam/model/util/JamCommonUtil$10", "canDeleteElement"));
                }
                for (DeleteProvider provider : toRun) {
                    if (provider.canDeleteElement(dataContext)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static <T extends JamElement> CachedValue<List<T>> createClassCachedValue(final Project project, final Factory<GlobalSearchScope> scope, final JamClassMeta<? extends T> ... meta) {
        return CachedValuesManager.getManager(project).createCachedValue(new CachedValueProvider<List<T>>(){

            @Override
            public CachedValueProvider.Result<List<T>> compute() {
                GlobalSearchScope searchScope = (GlobalSearchScope)scope.create();
                JamService jamService = JamService.getJamService(project);
                ArrayList result = new ArrayList();
                if (!DumbService.isDumb(project)) {
                    for (JamClassMeta classMeta : meta) {
                        for (JamAnnotationMeta annotationMeta : classMeta.getRootAnnotations()) {
                            result.addAll(jamService.getJamClassElements(classMeta, annotationMeta.getAnnoName(), searchScope));
                        }
                    }
                }
                return new CachedValueProvider.Result(result, PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT);
            }
        }, false);
    }

    public static void setAnnotationAttributeValue(PsiAnnotation annotation, String attribute, String value) {
        new JamStringAttributeElement<String>(PsiElementRef.real(annotation), attribute, JamConverter.DUMMY_CONVERTER).setStringValue(value);
    }

    public static <T extends PsiModifierListOwner> void findAnnotatedElements(Class<T> elementClass, String annotationClass, PsiManager psiManager, GlobalSearchScope scope, Processor<T> processor) {
        PsiClass aClass = JavaPsiFacade.getInstance(psiManager.getProject()).findClass(annotationClass, GlobalSearchScope.allScope(psiManager.getProject()));
        if (aClass != null) {
            AnnotatedElementsSearch.searchElements(aClass, scope, elementClass).forEach(processor);
        }
    }

    public static boolean processObjectArrayValue(PsiAnnotation annotation, String attributeName, Processor<PsiAnnotationMemberValue> processor) {
        if (annotation != null) {
            PsiAnnotationMemberValue memberValue = annotation.findAttributeValue(attributeName);
            if (memberValue instanceof PsiArrayInitializerMemberValue) {
                PsiArrayInitializerMemberValue arrayValue = (PsiArrayInitializerMemberValue)memberValue;
                for (PsiAnnotationMemberValue value : arrayValue.getInitializers()) {
                    if (processor.process((Object)value)) continue;
                    return false;
                }
            } else if (memberValue != null && !processor.process((Object)memberValue)) {
                return false;
            }
        }
        return true;
    }

    @Nullable
    public static PsiClass getPsiClass(@Nullable PsiAnnotationMemberValue psiAnnotationMemberValue) {
        Object value;
        PsiClass psiClass = null;
        if (psiAnnotationMemberValue instanceof PsiClassObjectAccessExpression) {
            PsiType type = ((PsiClassObjectAccessExpression)psiAnnotationMemberValue).getOperand().getType();
            if (type instanceof PsiClassType) {
                psiClass = ((PsiClassType)type).resolve();
            }
        } else if (psiAnnotationMemberValue instanceof PsiExpression && (value = JamCommonUtil.computeMemberValue(psiAnnotationMemberValue)) instanceof String) {
            String className = StringUtil.unquoteString((String)((String)value));
            psiClass = JavaPsiFacade.getInstance(psiAnnotationMemberValue.getProject()).findClass(className, psiAnnotationMemberValue.getResolveScope());
        }
        if (psiClass != null && "java.lang.Object".equals(psiClass.getQualifiedName())) {
            return null;
        }
        return psiClass;
    }

    @Nullable
    public static <T> T getObjectValue(@Nullable PsiAnnotationMemberValue value, Class<T> clazz) {
        boolean isString;
        boolean bl = isString = clazz == String.class;
        if (ReflectionUtil.isAssignable(Enum.class, clazz)) {
            return JamCommonUtil.getEnumValue(value, clazz);
        }
        Object obj = JamCommonUtil.computeMemberValue(value);
        if (obj != null && ReflectionUtil.isAssignable(clazz, obj.getClass())) {
            return (T)(isString ? StringUtil.unquoteString((String)((String)obj)) : obj);
        }
        return null;
    }

    @Nullable
    public static <T extends Enum> T getEnumValue(PsiAnnotationMemberValue memberValue, Class<T> clazz) {
        PsiReferenceExpression psiReferenceExpression;
        PsiElement psiElement;
        assert (ReflectionUtil.isAssignable(Enum.class, clazz));
        if (memberValue instanceof PsiReferenceExpression && (psiElement = (psiReferenceExpression = (PsiReferenceExpression)memberValue).resolve()) instanceof PsiField) {
            PsiField psiField = (PsiField)psiElement;
            return Enum.valueOf(clazz, psiField.getName());
        }
        return null;
    }
}

