/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jam.reflect;

import com.intellij.jam.JamElement;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamChildrenQuery;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.jam.reflect.JamRegisteringChildrenQuery;
import com.intellij.patterns.ElementPattern;
import com.intellij.pom.PomTarget;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.semantic.SemRegistrar;
import com.intellij.util.Consumer;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JamMemberArchetype<Psi extends PsiModifierListOwner, Jam extends JamElement> {
    private final List<JamAnnotationMeta> myAnnos = ContainerUtil.newArrayList();
    private final List<JamChildrenQuery<?>> myChildren = ContainerUtil.newArrayList();
    @Nullable
    private final JamMemberArchetype<? super Psi, ? super Jam> myParent;
    private List<PairConsumer<Jam, Consumer<PomTarget>>> myPomTargetProducers = ContainerUtil.newArrayList();

    public JamMemberArchetype() {
        this(null);
    }

    public JamMemberArchetype(@Nullable JamMemberArchetype<? super Psi, ? super Jam> parent) {
        this.myParent = parent;
    }

    protected final void registerChildren(SemRegistrar registrar, ElementPattern<? extends Psi> pattern) {
        for (JamChildrenQuery<?> child : this.myChildren) {
            if (!(child instanceof JamRegisteringChildrenQuery)) continue;
            ((JamRegisteringChildrenQuery)((Object)child)).registerSem(registrar, pattern);
        }
    }

    @Nullable
    public JamAnnotationMeta findAnnotationMeta(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/jam/reflect/JamMemberArchetype", "findAnnotationMeta"));
        }
        String qname = annotation.getQualifiedName();
        for (JamAnnotationMeta anno : this.myAnnos) {
            if (!anno.getAnnoName().equals(qname)) continue;
            return anno;
        }
        if (this.myParent != null) {
            return this.myParent.findAnnotationMeta(annotation);
        }
        return null;
    }

    public JamMemberArchetype<Psi, Jam> addAnnotation(JamAnnotationMeta meta) {
        this.myAnnos.add(meta);
        return this;
    }

    public List<JamAnnotationMeta> getAnnotations() {
        return this.myAnnos;
    }

    @Nullable
    public JamMemberArchetype<? super Psi, ? super Jam> getParent() {
        return this.myParent;
    }

    public JamMemberArchetype<Psi, Jam> addChildrenQuery(JamChildrenQuery<?> childrenQuery) {
        this.myChildren.add(childrenQuery);
        return this;
    }

    public JamMemberArchetype<Psi, Jam> addPomTargetProducer(@NotNull PairConsumer<Jam, Consumer<PomTarget>> producer) {
        if (producer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "producer", "com/intellij/jam/reflect/JamMemberArchetype", "addPomTargetProducer"));
        }
        this.myPomTargetProducers.add(producer);
        return this;
    }

    public List<PomTarget> getAssociatedTargets(@NotNull Jam element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/jam/reflect/JamMemberArchetype", "getAssociatedTargets"));
        }
        final ArrayList list = ContainerUtil.newArrayList();
        Consumer<PomTarget> targetConsumer = new Consumer<PomTarget>(){

            public void consume(PomTarget target) {
                list.add(target);
            }
        };
        for (PairConsumer<Jam, Consumer<PomTarget>> function : this.myPomTargetProducers) {
            function.consume(element, (Object)targetConsumer);
        }
        if (this.myParent != null) {
            list.addAll(this.myParent.getAssociatedTargets(element));
        }
        return list;
    }

    @Nullable
    public JamMemberMeta findChildMeta(@NotNull PsiModifierListOwner member) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/jam/reflect/JamMemberArchetype", "findChildMeta"));
        }
        for (JamChildrenQuery<?> child : this.myChildren) {
            JamMemberMeta<?, ?> meta = child.getMeta(member);
            if (meta == null) continue;
            return meta;
        }
        if (this.myParent != null) {
            return this.myParent.findChildMeta(member);
        }
        return null;
    }
}

