/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jam.view.tree;

import com.intellij.jam.view.tree.JamNodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTreeStructure;

public class JamTreeStructure
extends SimpleTreeStructure {
    private final SimpleNode myRootDescriptor;
    private final Project myProject;

    public JamTreeStructure(SimpleNode rootDescriptor, Project project) {
        this.myProject = project;
        this.myRootDescriptor = rootDescriptor;
    }

    public Project getProject() {
        return this.myProject;
    }

    @Override
    public Object getRootElement() {
        return this.myRootDescriptor;
    }

    @Override
    public boolean hasSomethingToCommit() {
        return PsiDocumentManager.getInstance(this.myProject).hasUncommitedDocuments();
    }

    @Override
    public void commit() {
        PsiDocumentManager.getInstance(this.myProject).commitAllDocuments();
    }

    @Override
    public Object getParentElement(Object element) {
        if (element instanceof SimpleNode) {
            return super.getParentElement(element);
        }
        return null;
    }

    @Override
    public boolean isAlwaysLeaf(Object element) {
        return element instanceof JamNodeDescriptor && ((JamNodeDescriptor)element).isAlwaysLeaf();
    }

    public static JamTreeStructure asyncInstance(SimpleNode rootDescriptor, Project project) {
        return new JamTreeStructure(rootDescriptor, project){

            @Override
            public boolean isToBuildChildrenInBackground(Object element) {
                return true;
            }
        };
    }
}

