/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.actions.export;

import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.util.Collection;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SaveGraphToImageDialog
extends DialogWrapper {
    private JPanel myContentPane;
    private TextFieldWithBrowseButton myDirectory;
    private JTextField myFileName;
    private JComboBox myExtension;

    protected SaveGraphToImageDialog(Project project, @Nullable VirtualFile directory, @Nullable String defaultFileName, @NotNull Collection<String> extensions) {
        if (extensions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensions", "com/intellij/openapi/graph/builder/actions/export/SaveGraphToImageDialog", "<init>"));
        }
        super(project, false);
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(ActionsBundle.message("action.Graph.export.to.file.dialog.caption", objectArray));
        this.myDirectory.addBrowseFolderListener(ActionsBundle.message("action.Graph.choose.directory", new Object[0]), ActionsBundle.message("action.Graph.choose.directory", new Object[0]), project, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        if (directory != null) {
            this.myDirectory.setText(directory.getPath());
        }
        this.myDirectory.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                SaveGraphToImageDialog.this.myDirectory.getTextField().setForeground(SaveGraphToImageDialog.this.getDirectory() != null ? SimpleTextAttributes.REGULAR_ATTRIBUTES.getFgColor() : SimpleTextAttributes.ERROR_ATTRIBUTES.getFgColor());
                SaveGraphToImageDialog.this.updateOkButton();
            }
        });
        if (extensions.size() == 0) {
            this.myExtension.setEnabled(false);
        } else {
            for (String extension : extensions) {
                this.myExtension.addItem(extension);
            }
        }
        if (defaultFileName != null) {
            this.myFileName.setText(defaultFileName);
        }
        this.myFileName.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                SaveGraphToImageDialog.this.myFileName.setForeground(SaveGraphToImageDialog.isValidFileName(SaveGraphToImageDialog.this.myFileName.getText()) ? SimpleTextAttributes.REGULAR_ATTRIBUTES.getFgColor() : SimpleTextAttributes.ERROR_ATTRIBUTES.getFgColor());
                SaveGraphToImageDialog.this.updateOkButton();
            }
        });
        this.updateOkButton();
        this.init();
    }

    private static boolean isValidFileName(String text) {
        return !text.contains(".") && !text.contains("\\") && !text.contains("/");
    }

    private void updateOkButton() {
        this.getOKAction().setEnabled(this.myFileName.getText().trim().length() > 0 && this.getDirectory() != null && SaveGraphToImageDialog.isValidFileName(this.myFileName.getText().trim()));
    }

    @Nullable
    public VirtualFile getDirectory() {
        String path2 = this.myDirectory.getText();
        return LocalFileSystem.getInstance().findFileByPath(path2);
    }

    @Nullable
    public String getPath() {
        VirtualFile directory = this.getDirectory();
        if (directory == null || this.myFileName.getText().trim().length() == 0) {
            return null;
        }
        return directory.getPath() + File.separator + this.myFileName.getText() + "." + this.myExtension.getSelectedItem();
    }

    @Override
    @Nullable
    protected JComponent createCenterPanel() {
        return this.myContentPane;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JTextField jTextField;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(5, 5, 5, 5), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myDirectory = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, new Dimension(300, -1), null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Directory:");
        jLabel.setDisplayedMnemonic('D');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("File Name:");
        jLabel2.setDisplayedMnemonic('F');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myFileName = jTextField = new JTextField();
        jTextField.setText("");
        jPanel2.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 3, 0, null, new Dimension(150, -1), null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Save as:");
        jLabel3.setDisplayedMnemonic('S');
        jLabel3.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(2, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myExtension = jComboBox = new JComboBox();
        jPanel3.add(jComboBox, new GridConstraints(0, 0, 1, 1, 8, 1, 2, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(3, 1, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }
}

