/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.libraries;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.webcore.ScriptingFrameworkDescriptor;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScriptingLibraryModel {
    public static final ScriptingLibraryModel[] EMPTY_ARRAY = new ScriptingLibraryModel[0];
    private String myName;
    private final Set<VirtualFile> mySourceFiles = new HashSet<VirtualFile>();
    private final Set<VirtualFile> myCompactFiles = new HashSet<VirtualFile>();
    private final Set<String> myDocUrls = new TreeSet<String>();
    private LibraryLevel myLibraryLevel;
    private ScriptingFrameworkDescriptor myFrameworkDescriptor;
    private Library myOriginalLibrary;
    private Set<Module> myAssociatedModules;
    private boolean myIsOnByDefault;
    public static final ScriptingLibraryModel DUMMY_INSTANCE = new ScriptingLibraryModel("dummy", VirtualFile.EMPTY_ARRAY, VirtualFile.EMPTY_ARRAY, ArrayUtil.EMPTY_STRING_ARRAY, LibraryLevel.PREDEFINED, false);

    ScriptingLibraryModel(String name, VirtualFile[] sourceFiles, VirtualFile[] compactFiles, String[] docUrls, LibraryLevel level, boolean isOnByDefault) {
        this(name, level);
        this.setSourceFiles(sourceFiles);
        this.myCompactFiles.addAll(Arrays.asList(compactFiles));
        this.myDocUrls.addAll(Arrays.asList(docUrls));
        this.myIsOnByDefault = isOnByDefault;
    }

    public static ScriptingLibraryModel createPredefinedLibrary(String name, VirtualFile[] sourceFiles, boolean isOnByDefault) {
        return new ScriptingLibraryModel(name, sourceFiles, VirtualFile.EMPTY_ARRAY, ArrayUtil.EMPTY_STRING_ARRAY, LibraryLevel.PREDEFINED, isOnByDefault);
    }

    public static ScriptingLibraryModel createPredefinedLibrary(String name, VirtualFile[] sourceFiles, String extDocUrl, boolean isOnByDefault) {
        return new ScriptingLibraryModel(name, sourceFiles, VirtualFile.EMPTY_ARRAY, new String[]{extDocUrl}, LibraryLevel.PREDEFINED, isOnByDefault);
    }

    public ScriptingLibraryModel(@Nullable String name, LibraryLevel libraryLevel) {
        this.myName = name;
        this.myLibraryLevel = libraryLevel;
    }

    public void setName(String name) {
        this.myName = name;
    }

    public void setSourceFiles(VirtualFile[] files) {
        this.mySourceFiles.clear();
        this.mySourceFiles.addAll(Arrays.asList(files));
    }

    public void setCompactFiles(VirtualFile[] files) {
        this.myCompactFiles.clear();
        this.myCompactFiles.addAll(Arrays.asList(files));
    }

    public void setDocUrls(String[] docUrls) {
        this.myDocUrls.clear();
        this.myDocUrls.addAll(Arrays.asList(docUrls));
    }

    @NotNull
    public Set<VirtualFile> getSourceFiles() {
        Set<VirtualFile> set = this.mySourceFiles;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ScriptingLibraryModel", "getSourceFiles"));
        }
        return set;
    }

    public Set<VirtualFile> getCompactFiles() {
        return this.myCompactFiles;
    }

    public Set<String> getDocUrls() {
        return this.myDocUrls;
    }

    @NotNull
    public Set<VirtualFile> getAllFiles() {
        HashSet<VirtualFile> compactAndSourceFiles = new HashSet<VirtualFile>(this.mySourceFiles);
        compactAndSourceFiles.addAll(this.myCompactFiles);
        HashSet<VirtualFile> hashSet = compactAndSourceFiles;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ScriptingLibraryModel", "getAllFiles"));
        }
        return hashSet;
    }

    public String getName() {
        return this.myName;
    }

    public boolean containsFile(VirtualFile file) {
        return this.mySourceFiles.contains(file) || this.myCompactFiles.contains(file);
    }

    @Nullable
    public VirtualFile getMatchingFile(String fileName) {
        for (VirtualFile sourceFile : this.mySourceFiles) {
            if (!sourceFile.getName().equals(fileName)) continue;
            return sourceFile;
        }
        for (VirtualFile compactFile : this.myCompactFiles) {
            if (!compactFile.getName().equals(fileName)) continue;
            return compactFile;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.mySourceFiles.isEmpty() && this.myCompactFiles.isEmpty();
    }

    public String toString() {
        return this.myName + (this.isPredefined() ? " (Predefined)" : "");
    }

    public boolean isPredefined() {
        return this.myLibraryLevel == LibraryLevel.PREDEFINED;
    }

    public LibraryLevel getLibraryLevel() {
        return this.myLibraryLevel;
    }

    public ScriptingFrameworkDescriptor getFrameworkDescriptor() {
        return this.myFrameworkDescriptor;
    }

    public void setFrameworkDescriptor(ScriptingFrameworkDescriptor frameworkDescriptor) {
        this.myFrameworkDescriptor = frameworkDescriptor;
    }

    void setOriginalLibrary(@Nullable Library originalLibrary) {
        this.myOriginalLibrary = originalLibrary;
    }

    @Nullable
    public Library getOriginalLibrary() {
        return this.myOriginalLibrary;
    }

    public void setLibraryLevel(LibraryLevel libraryLevel) {
        assert (libraryLevel == LibraryLevel.PROJECT || libraryLevel == LibraryLevel.GLOBAL) : "Only Global or Project level is allowed here";
        if (libraryLevel != this.myLibraryLevel) {
            this.myLibraryLevel = libraryLevel;
            this.myOriginalLibrary = null;
        }
    }

    public void setAssociatedModules(Set<Module> modules) {
        this.myAssociatedModules = modules;
    }

    public boolean hasAssociatedModules() {
        return this.myAssociatedModules != null && !this.myAssociatedModules.isEmpty();
    }

    public boolean isAssociatedWith(Module module) {
        return this.myAssociatedModules != null && this.myAssociatedModules.contains(module);
    }

    public Set<Module> getAssociatedModules() {
        return this.myAssociatedModules;
    }

    public boolean isOnByDefault() {
        return this.myIsOnByDefault;
    }

    @NotNull
    public static ScriptingLibraryModel[] toArray(@NotNull Collection<ScriptingLibraryModel> collection) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/webcore/libraries/ScriptingLibraryModel", "toArray"));
        }
        ScriptingLibraryModel[] scriptingLibraryModelArray = collection.toArray(new ScriptingLibraryModel[collection.size()]);
        if (scriptingLibraryModelArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ScriptingLibraryModel", "toArray"));
        }
        return scriptingLibraryModelArray;
    }

    public void addSignificantFiles(Collection<VirtualFile> result) {
        if (!this.mySourceFiles.isEmpty()) {
            result.addAll(this.mySourceFiles);
        } else {
            result.addAll(this.myCompactFiles);
        }
    }

    public static enum LibraryLevel {
        PREDEFINED,
        GLOBAL,
        PROJECT;

    }
}

