/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.actions;

import com.intellij.facet.FacetManager;
import com.intellij.history.LocalHistory;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileStatusNotification;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.LanguageLevelUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.LanguageLevelModuleExtension;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.ws.WSBundle;
import com.intellij.ws.actions.DeployWebServiceDialog;
import com.intellij.ws.actions.GenerateJavaFromWsdlAction;
import com.intellij.ws.actions.GenerateJavaFromWsdlDialog;
import com.intellij.ws.actions.create.CreateWebServiceClientAction;
import com.intellij.ws.engines.LibraryDescriptor;
import com.intellij.ws.engines.jbossws.JBossWSEngine;
import com.intellij.ws.engines.jwsdp.JWSDPWSEngine;
import com.intellij.ws.engines.wsengine.DeployWebServiceOptions;
import com.intellij.ws.engines.wsengine.WSEngine;
import com.intellij.ws.facet.WebServicesFacet;
import com.intellij.ws.utils.CommonWsUtils;
import com.intellij.ws.utils.DeployUtils;
import com.intellij.ws.utils.FileUtils;
import com.intellij.ws.utils.InvokeExternalCodeUtil;
import com.intellij.ws.utils.LibUtils;
import com.intellij.ws.utils.SoapUI;
import com.intellij.ws.utils.WsPsiUtil;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnableWebServicesSupportUtils {
    @NonNls
    public static final String DEFAULT_WEBSERVICE_CLIENT_TEMPLATE_NAME = "default.webservice.client.java";

    private EnableWebServicesSupportUtils() {
    }

    public static void setupWebServicesInfrastructureForModule(Project project, boolean doLabel, Module module, WSEngine wsEngine, boolean isServerSideSupport, String bindingType) {
        EnableWebServicesSupportUtils.setupWebServicesInfrastructureForModule(project, doLabel, module, wsEngine, isServerSideSupport, bindingType, (WebFacet)FacetManager.getInstance((Module)module).getFacetByType(WebFacet.ID));
    }

    public static void setupWebServicesInfrastructureForModule(Project project, boolean doLabel, final Module module, final WSEngine wsEngine, boolean isServerSideSupport, final String bindingType, final WebFacet webFacet) {
        if (doLabel) {
            LocalHistory.getInstance().putSystemLabel(project, WSBundle.message("enable.web.services.support.lvcslabel", new Object[0]));
        }
        LibUtils.setupLibsForGeneratedCode(module, wsEngine, bindingType);
        if (CommonWsUtils.hasJ2EE && webFacet != null) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    CommonWsUtils.setupLibsForDeployment((Module)module, (LibraryDescriptor[])LibUtils.getGeneratedCodeLibInfos(wsEngine, bindingType, module), (WebFacet)webFacet);
                }
            });
        }
        if (isServerSideSupport) {
            wsEngine.doAdditionalWSServerSetup(module, webFacet);
            VirtualFile result = FileUtils.findWebXml((Module)module, (WebFacet)webFacet);
            String deploymentServletName = wsEngine.getDeploymentServletName();
            if (result != null && deploymentServletName != null) {
                DeployUtils.updateWebXml(project, result, deploymentServletName, wsEngine.getDeploymentServletClassName());
            }
        }
        CommonWsUtils.doFileSystemRefresh();
        SoapUI.installSoapUI(project);
    }

    public static void enableWebServicesServerSupport(Module module, WSEngine wsEngine, boolean generateExample, WebServicesFacet webServicesFacet) {
        EnableWebServicesSupportUtils.setupWebServicesInfrastructureForModule(module.getProject(), false, module, wsEngine, true, null, (WebFacet)webServicesFacet.getUnderlyingFacet());
        if (generateExample) {
            EnableWebServicesSupportUtils.createSimpleCodeForServer(module, wsEngine);
        }
    }

    public static void createSimpleCodeForServer(Module module, WSEngine wsEngine) {
        EnableWebServicesSupportUtils.createCodeForServer(module, wsEngine, "example", "HelloWorld", (Consumer<Exception>)Consumer.EMPTY_CONSUMER, null);
    }

    public static void createCodeForServer(Module module, WSEngine wsEngine, @NonNls String packageName, @NonNls String serviceName, @NotNull Consumer<Exception> onException, Runnable restartAction) {
        if (onException == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onException", "com/intellij/ws/actions/EnableWebServicesSupportUtils", "createCodeForServer"));
        }
        VirtualFile[] sourceRoots = ModuleRootManager.getInstance((Module)module).getSourceRoots();
        ArrayList<VirtualFile> createdSourceFiles = new ArrayList<VirtualFile>(2);
        if (sourceRoots.length > 0) {
            String interfaceName = null;
            String text = EnableWebServicesSupportUtils.getWebServiceTemplateText(packageName, serviceName, wsEngine, module.getProject());
            VirtualFile interfaceFile = EnableWebServicesSupportUtils.createInterfaceFile(module, wsEngine, packageName, serviceName);
            if (interfaceFile != null) {
                createdSourceFiles.add(interfaceFile);
                interfaceName = interfaceFile.getNameWithoutExtension();
            }
            VirtualFile virtualFile = CommonWsUtils.addFileToModuleFromTemplate((Module)module, (String[])EnableWebServicesSupportUtils.createPathComponents(packageName, serviceName), (InputStream)new StringBufferInputStream(text), (boolean)false, (boolean)true);
            assert (virtualFile != null);
            createdSourceFiles.add(virtualFile);
            boolean useInterfaceName = interfaceName != null && wsEngine instanceof JBossWSEngine;
            EnableWebServicesSupportUtils.compileAndRunDeployment(module, StringUtil.getQualifiedName((String)packageName, (String)(useInterfaceName ? interfaceName : serviceName)), createdSourceFiles, wsEngine, new Processor<PsiClass>(){

                public boolean process(PsiClass psiClass) {
                    psiClass.navigate(true);
                    return true;
                }
            }, onException, restartAction);
        }
    }

    private static String[] createPathComponents(String packageName, String className) {
        Object[] simpleNames = packageName.split("\\.");
        return (String[])ArrayUtil.append((Object[])simpleNames, (Object)(className + ".java"));
    }

    @Nullable
    public static VirtualFile createInterfaceFile(Module module, WSEngine wsEngine, String packageName, String serviceName) {
        return EnableWebServicesSupportUtils.createInterfaceFile(module, packageName, serviceName, wsEngine.getWebServicesInterfaceTemplateName());
    }

    @Nullable
    public static VirtualFile createInterfaceFile(Module module, String packageName, String serviceName, @Nullable String interfaceTemplateName) {
        if (interfaceTemplateName != null) {
            String interfaceName = "I" + serviceName;
            String interfaceText = CommonWsUtils.getFromFileTemplateWithCustomParameters((Project)module.getProject(), (String)interfaceTemplateName, (String[])new String[]{"PACKAGE_NAME", packageName, "INTERFACE_NAME", interfaceName});
            return CommonWsUtils.addFileToModuleFromTemplate((Module)module, (String[])EnableWebServicesSupportUtils.createPathComponents(packageName, interfaceName), (InputStream)new StringBufferInputStream(interfaceText), (boolean)false, (boolean)true);
        }
        return null;
    }

    public static String getWebServiceTemplateText(String packageName, String className, WSEngine wsEngine, Project project) {
        String interfaceName = "I" + className;
        return CommonWsUtils.getFromFileTemplateWithCustomParameters((Project)project, (String)wsEngine.getWebServicesTemplateName(), (String[])new String[]{"PACKAGE_NAME", packageName, "CLASS_NAME", className, "INTERFACE_NAME", interfaceName, "INTERFACE_Q_NAME", StringUtil.getQualifiedName((String)packageName, (String)interfaceName)});
    }

    public static void compileAndRunDeployment(final Module module, String mainClassName, List<VirtualFile> createdSourceFiles, final WSEngine wsEngine, final Processor<PsiClass> onSuccess, final @NotNull Consumer<Exception> onException, final Runnable restart) {
        if (onException == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onException", "com/intellij/ws/actions/EnableWebServicesSupportUtils", "compileAndRunDeployment"));
        }
        PsiManager psiManager = PsiManager.getInstance((Project)module.getProject());
        final PsiClass clazz = WsPsiUtil.findClass((String)mainClassName, (Project)psiManager.getProject(), (GlobalSearchScope)GlobalSearchScope.moduleScope((Module)module));
        CompilerManager.getInstance((Project)module.getProject()).compile(VfsUtil.toVirtualFileArray(createdSourceFiles), new CompileStatusNotification(){

            public void finished(boolean aborted, int errors, int warnings, CompileContext compileContext) {
                if (!aborted && errors == 0) {
                    try {
                        if (wsEngine.deploymentSupported()) {
                            EnableWebServicesSupportUtils.continueDeployment(wsEngine, module, clazz, (Processor<PsiClass>)onSuccess, (Consumer<Exception>)onException, restart);
                        }
                    }
                    catch (InvokeExternalCodeUtil.ExternalCodeException ex) {
                        Messages.showErrorDialog((Project)module.getProject(), (String)ex.getMessage(), (String)"Error");
                    }
                }
            }
        });
    }

    private static void continueDeployment(final WSEngine wsEngine, final Module module, final PsiClass clazz, final Processor<PsiClass> onSuccess, final Consumer<Exception> onException, final Runnable restart) throws InvokeExternalCodeUtil.ExternalCodeException {
        Runnable continueDeployment = new Runnable(){

            @Override
            public void run() {
                wsEngine.deployWebService(new DeployWebServiceOptions(){

                    @Override
                    public String getWsName() {
                        return clazz.getName();
                    }

                    @Override
                    public String getWsClassName() {
                        return clazz.getQualifiedName();
                    }

                    @Override
                    public String getWsNamespace() {
                        String packageName = ((PsiJavaFile)clazz.getContainingFile()).getPackageName();
                        if (packageName.length() == 0) {
                            return "empty";
                        }
                        return "http://" + DeployWebServiceDialog.buildNSNameFromPackageText(packageName, wsEngine);
                    }

                    @Override
                    public String getUseOfItems() {
                        return "LITERAL";
                    }

                    @Override
                    public String getBindingStyle() {
                        return "DOCUMENT";
                    }

                    @Override
                    public PsiClass getWsClass() {
                        return clazz;
                    }
                }, module, new Runnable(){

                    @Override
                    public void run() {
                        CommonWsUtils.doFileSystemRefresh();
                        if (onSuccess != null) {
                            onSuccess.process((Object)clazz);
                        }
                    }
                }, (Consumer<Exception>)onException, restart);
            }
        };
        wsEngine.undeployWebService(clazz.getName(), module, continueDeployment, onException, restart);
    }

    public static void enableWebServiceSupportForClient(Module module, WSEngine wsEngine, boolean generateExample) {
        EnableWebServicesSupportUtils.setupWebServicesInfrastructureForModule(module.getProject(), false, module, wsEngine, false, null);
        if (generateExample) {
            EnableWebServicesSupportUtils.createSimpleCodeForClient(module, wsEngine);
        }
    }

    public static void createSimpleCodeForClient(Module module, WSEngine engine) {
        EnableWebServicesSupportUtils.createCodeForClient(module, engine, "example", "HelloWorldClient");
    }

    public static void createCodeForClient(final Module module, final WSEngine wsEngine, final String packageNameToCreate, final String classNameToCreate) {
        final Project project = module.getProject();
        GenerateJavaFromWsdlDialog dialog = new GenerateJavaFromWsdlDialog(project, null, module, new Runnable(){

            @Override
            public void run() {
                VirtualFile interfaceFile = CommonWsUtils.addFileToModuleFromTemplate((Module)module, (String[])EnableWebServicesSupportUtils.createPathComponents(packageNameToCreate, classNameToCreate), (InputStream)new StringBufferInputStream(CommonWsUtils.getDefaultClientCode((Project)project, (String)packageNameToCreate, (String)classNameToCreate, (String)EnableWebServicesSupportUtils.DEFAULT_WEBSERVICE_CLIENT_TEMPLATE_NAME)), (boolean)false, (boolean)true);
                if (interfaceFile == null) {
                    return;
                }
                Editor editor = FileEditorManager.getInstance((Project)module.getProject()).openTextEditor(new OpenFileDescriptor(module.getProject(), interfaceFile), true);
                if (editor == null) {
                    return;
                }
                CreateWebServiceClientAction.runTemplate(editor, wsEngine);
            }
        });
        if (dialog.showAndGet()) {
            GenerateJavaFromWsdlAction.doOkAction(project, dialog);
        }
    }

    public static void ensureAnnotationsAreAllowedInJdkIfNeeded(@NotNull WSEngine wsEngine, @NotNull Module module) {
        if (wsEngine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wsEngine", "com/intellij/ws/actions/EnableWebServicesSupportUtils", "ensureAnnotationsAreAllowedInJdkIfNeeded"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/ws/actions/EnableWebServicesSupportUtils", "ensureAnnotationsAreAllowedInJdkIfNeeded"));
        }
        if (wsEngine instanceof JWSDPWSEngine && !LanguageLevelUtil.getEffectiveLanguageLevel((Module)module).isAtLeast(LanguageLevel.JDK_1_5)) {
            boolean moduleJdk;
            Sdk projectJdk = ModuleRootManager.getInstance((Module)module).getSdk();
            boolean bl = moduleJdk = projectJdk != null;
            if (projectJdk == null) {
                projectJdk = ProjectRootManager.getInstance((Project)module.getProject()).getProjectSdk();
            }
            if (projectJdk != null) {
                if (moduleJdk) {
                    final ModifiableRootModel rootModel = ModuleRootManager.getInstance((Module)module).getModifiableModel();
                    ((LanguageLevelModuleExtension)rootModel.getModuleExtension(LanguageLevelModuleExtension.class)).setLanguageLevel(LanguageLevel.JDK_1_5);
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            rootModel.commit();
                        }
                    });
                } else {
                    LanguageLevelProjectExtension.getInstance((Project)module.getProject()).setLanguageLevel(LanguageLevel.JDK_1_5);
                }
            }
        }
    }
}

