/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.engines.axis;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.io.HttpRequests;
import com.intellij.ws.WebServicesPluginSettings;
import com.intellij.ws.utils.ExternalProcessHandler;
import com.intellij.ws.utils.InvokeExternalCodeUtil;
import com.intellij.ws.utils.LibUtils;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class AxisUtil {
    @NonNls
    private static final Logger LOG = Logger.getInstance((String)"webservicesplugin.axisinvokator");
    public static final String TYPE_MAPPING_1_2 = "1.2";
    public static final String TYPE_MAPPING_1_1 = "1.1";
    public static final String APPLICATION_SCOPE = "Application";
    public static final String ORG_APACHE_AXIS_WSDL_JAVA2_WSDL = "org.apache.axis.wsdl.Java2WSDL";
    private static final String ORG_APACHE_AXIS_CLIENT_ADMIN_CLIENT = "org.apache.axis.client.AdminClient";

    private AxisUtil() {
    }

    static void invokeDeployment(String deploymentText, String contextName, Project project) throws RuntimeException, InvokeExternalCodeUtil.ExternalCodeException {
        AxisUtil.invokeAxisAdminInner(deploymentText, contextName, project);
    }

    private static void invokeAxisAdminInner(String deploymentText, String contextName, Project project) throws InvokeExternalCodeUtil.ExternalCodeException {
        try {
            File tempFile = FileUtil.createTempFile((String)"deploy", (String)".wsdd");
            tempFile.deleteOnExit();
            FileUtil.writeToFile((File)tempFile, (String)deploymentText);
            LinkedList<String> parameters = new LinkedList<String>();
            parameters.add("-l" + AxisUtil.getWebServiceUrlReference(contextName, "AdminService"));
            parameters.add(tempFile.getPath());
            InvokeExternalCodeUtil.invokeExternalProcess((ExternalProcessHandler)new InvokeExternalCodeUtil.JavaExternalProcessHandler("Axis Admin", ORG_APACHE_AXIS_CLIENT_ADMIN_CLIENT, LibUtils.getLibUrlsForToolRunning(WebServicesPluginSettings.getInstance().getEngineManager().getWSEngineByName("Apache Axis"), ModuleManager.getInstance((Project)project).getModules()[0]), ArrayUtil.toStringArray(parameters), null, false), (Project)project);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    public static boolean simpleCheckThatServerOnLocalHostIsRunning() {
        return AxisUtil.simplePing(AxisUtil.getTomcatUrl(), true);
    }

    private static String getTomcatUrl() {
        WebServicesPluginSettings instance = WebServicesPluginSettings.getInstance();
        return "http://" + instance.getHostName() + ":" + instance.getHostPort();
    }

    @Nullable
    public static String getServiceWsdl(String contextName, String serviceName) {
        try {
            return HttpRequests.request((String)AxisUtil.getWsdFileContent(contextName, serviceName)).readString(null);
        }
        catch (IOException e) {
            return null;
        }
    }

    private static String getWsdFileContent(String contextName, String serviceName) {
        return AxisUtil.getWebServiceUrlReference(contextName, serviceName) + "?wsdl";
    }

    public static String getWebServiceUrlReference(String contextName, String serviceName) {
        return AxisUtil.getContextUrl(contextName) + WebServicesPluginSettings.getInstance().getWebServicesUrlPathPrefix() + "/" + serviceName;
    }

    public static String getWebServiceNS(String contextName, String serviceName) {
        WebServicesPluginSettings instance = WebServicesPluginSettings.getInstance();
        return "http://" + instance.getHostName() + (contextName.length() > 0 ? "/" + contextName : "") + instance.getWebServicesUrlPathPrefix() + "/" + serviceName;
    }

    private static String getContextUrl(String contextName) {
        String result = AxisUtil.getTomcatUrl();
        return StringUtil.isEmpty((String)contextName) ? result + '/' + contextName : result;
    }

    private static boolean simplePing(String url, boolean acceptAnyResponse) {
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
            connection.connect();
            connection.disconnect();
            return acceptAnyResponse || connection.getResponseCode() == 200;
        }
        catch (IOException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Throwable)e);
            }
            return false;
        }
    }

    public static boolean simpleHappyServlet(String contextName, String servletName) {
        return AxisUtil.simplePing(AxisUtil.getContextUrl(contextName) + "/servlet/" + servletName, false);
    }

    public static boolean simpleHappyAxisMonitor(String contextName) {
        return AxisUtil.simplePing(AxisUtil.getContextUrl(contextName) + "/SOAPMonitor", false);
    }

    static void ensureSoapMonitorDeployed(String contextName, Project project) {
        try {
            AxisUtil.runDeployment("SOAPMonitorService", contextName, "org.apache.axis.monitor.SOAPMonitorService", "publishMessage", null, false, "<handler name=\"soapmonitor\"\n        type=\"java:org.apache.axis.handlers.SOAPMonitorHandler\">\n      <parameter name=\"wsdlURL\" \n        value=\"/axis/SOAPMonitorService-impl.wsdl\"/>\n      <parameter name=\"namespace\" \n        value=\"http://tempuri.org/wsdl/2001/12/SOAPMonitorService-impl.wsdl\"/>\n      <parameter name=\"serviceName\" value=\"SOAPMonitorService\"/>\n      <parameter name=\"portName\" value=\"Demo\"/>\n    </handler>\n", APPLICATION_SCOPE, null, project);
        }
        catch (InvokeExternalCodeUtil.ExternalCodeException e) {
            LOG.error((Throwable)e);
        }
    }

    static void runDeployment(String nameOfService, String contextName, String classToDeploy, String allowedMethods, List<String> nonelementaryTypes, boolean supportSoapMonitoring, String handlerText, String scope, String style, Project project) throws InvokeExternalCodeUtil.ExternalCodeException {
        String deploymentPrefix = "<deployment name=\"test\" xmlns=\"http://xml.apache.org/axis/wsdd/\" \n    xmlns:java=\"http://xml.apache.org/axis/wsdd/providers/java\">";
        if (handlerText != null) {
            deploymentPrefix = deploymentPrefix + handlerText;
        }
        deploymentPrefix = deploymentPrefix + "  <service name=\"" + nameOfService + "\" provider=\"java:RPC\"";
        if (style != null) {
            deploymentPrefix = deploymentPrefix + " style=\"" + style.toLowerCase(Locale.ENGLISH) + "\"";
        }
        deploymentPrefix = deploymentPrefix + ">\n";
        if (supportSoapMonitoring) {
            deploymentPrefix = deploymentPrefix + "<requestFlow>\n      <handler type=\"soapmonitor\"/>\n    </requestFlow>\n    <responseFlow>\n      <handler type=\"soapmonitor\"/>\n    </responseFlow>\n";
        }
        deploymentPrefix = deploymentPrefix + "    <parameter name=\"className\" value=\"" + classToDeploy + "\" />\n" + "    <parameter name=\"allowedMethods\" value=\"" + allowedMethods + "\" />\n";
        if (scope != null) {
            deploymentPrefix = deploymentPrefix + "<parameter name=\"scope\" value=\"" + scope + "\"/>\n";
        }
        String deploymentText = deploymentPrefix;
        if (nonelementaryTypes != null) {
            for (String s : nonelementaryTypes) {
                deploymentText = deploymentText + "    <beanMapping qname=\"myNS:" + s.substring(s.lastIndexOf(46) + 1) + "\" xmlns:myNS=\"" + nameOfService + "\" languageSpecificType=\"java:" + s + "\"/>\n";
            }
        }
        deploymentText = deploymentText + "  </service>\n</deployment>";
        AxisUtil.invokeDeployment(deploymentText, contextName, project);
    }
}

