/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.engines.axis2;

import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.ws.WSBundle;
import com.intellij.ws.WebServicesPluginSettings;
import com.intellij.ws.engines.LibraryDescriptor;
import com.intellij.ws.engines.LibraryInfo;
import com.intellij.ws.engines.wsengine.DeployWebServiceOptions;
import com.intellij.ws.engines.wsengine.GenerateJavaFromWsdlOptions;
import com.intellij.ws.engines.wsengine.GenerateWsdlFromJavaOptions;
import com.intellij.ws.engines.wsengine.WSEngine;
import com.intellij.ws.engines.wsengine.WSEngineUtils;
import com.intellij.ws.utils.CommonWsUtils;
import com.intellij.ws.utils.DeployUtils;
import com.intellij.ws.utils.ExternalProcessHandler;
import com.intellij.ws.utils.FileUtils;
import com.intellij.ws.utils.InvokeExternalCodeUtil;
import com.intellij.ws.utils.LibUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedList;

public class Axis2WSEngine
implements WSEngine {
    private static final String AXIS2_LIBRARY_NAME = "Axis2";
    private static final String ADB_MAPPING_TYPE = "ADB";
    private static final String JIBX_MAPPING_TYPE = "JibX";
    private static final String JAXBRI_MAPPING_TYPE = "JAXBRI";
    private static final String XMLBEANS_MAPPING_TYPE = "XmlBeans";
    public static final String AXIS2_PLATFORM = WSBundle.message("axis2.display.name", new Object[0]);
    private final String[] pathComponents = new String[]{"META-INF", "services.xml"};
    private final String[] pathComponents2 = new String[]{"WEB-INF", "conf", "axis2.xml"};
    private static final boolean CREATE_IN_CONTENT_ROOT = false;
    private static final Logger LOG = Logger.getInstance((String)("#" + Axis2WSEngine.class.getName()));

    @Override
    public String getName() {
        return AXIS2_PLATFORM;
    }

    @Override
    public LibraryDescriptor[] getLibraryDescriptors(String bindingType, final boolean isForGeneratedCode) {
        String axis2BasePath = WebServicesPluginSettings.getInstance().getAxis2Path();
        File[] axis2LibFiles = new File(axis2BasePath + "/lib").listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String filename) {
                boolean jarFile = filename.endsWith(".jar");
                if (jarFile && filename.startsWith("servletapi") && isForGeneratedCode) {
                    return false;
                }
                return jarFile;
            }
        });
        String[] axis2LibPathes = new String[axis2LibFiles.length];
        for (int i = 0; i < axis2LibFiles.length; ++i) {
            axis2LibPathes[i] = WSEngineUtils.stripPrefixPath(axis2LibFiles[i].getAbsolutePath(), axis2BasePath);
        }
        return new LibraryDescriptor[]{new LibraryInfo(AXIS2_LIBRARY_NAME, axis2LibPathes)};
    }

    @Override
    public String getBasePath() {
        return WebServicesPluginSettings.getInstance().getAxis2Path();
    }

    @Override
    public boolean hasSeparateClientServerJavaCodeGenerationOption() {
        return true;
    }

    @Override
    public boolean allowsTestCaseGeneration() {
        return true;
    }

    @Override
    public String[] getSupportedMappingTypesForJavaFromWsdl() {
        return new String[]{ADB_MAPPING_TYPE, XMLBEANS_MAPPING_TYPE, JAXBRI_MAPPING_TYPE};
    }

    @Override
    public String getDeploymentServletName() {
        return "Axis2Servlet";
    }

    @Override
    public String getDeploymentServletClassName() {
        return "org.apache.axis2.transport.http.AxisServlet";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doAdditionalWSServerSetup(Module currentModule, WebFacet webFacet) {
        CommonWsUtils.addFileToModuleFromTemplate((Module)currentModule, (String[])this.pathComponents, (InputStream)LibUtils.getResourcesStream("Axis2.services.xml"), (boolean)false, (boolean)false, (WebFacet)webFacet);
        File axis2ConfFile = new File(new File(this.getBasePath(), "conf"), "axis2.xml");
        if (axis2ConfFile.exists()) {
            FileInputStream inputStream = null;
            try {
                inputStream = new FileInputStream(axis2ConfFile);
                CommonWsUtils.addFileToModuleFromTemplate((Module)currentModule, (String[])this.pathComponents2, (InputStream)inputStream, (boolean)true, (boolean)false, (WebFacet)webFacet);
            }
            catch (FileNotFoundException e) {
            }
            finally {
                if (inputStream != null) {
                    try {
                        ((InputStream)inputStream).close();
                    }
                    catch (IOException e) {
                        LOG.error((Throwable)e);
                    }
                }
            }
        } else {
            InputStream bundledTemplateStream = LibUtils.getResourcesStream("Axis2.conf_axis2.xml");
            CommonWsUtils.addFileToModuleFromTemplate((Module)currentModule, (String[])this.pathComponents2, (InputStream)bundledTemplateStream, (boolean)true, (boolean)false, (WebFacet)webFacet);
        }
    }

    @Override
    public String checkNotAcceptableClassForGenerateWsdl(PsiClass clazz) {
        return null;
    }

    @Override
    public String checkNotAcceptableClassForDeployment(PsiClass clazz) {
        return null;
    }

    @Override
    public boolean supportsJaxWs2() {
        return false;
    }

    @Override
    public boolean deploymentSupported() {
        return true;
    }

    @Override
    public String getServiceInvocationTemplateName() {
        return "itaws";
    }

    @Override
    public void generateWsdlFromJava(GenerateWsdlFromJavaOptions options, Consumer<File> onSuccessAction, Consumer<Exception> onException, Runnable editAgain) {
        LinkedList<String> parametersList = new LinkedList<String>();
        PsiClass psiClass = options.getClassForOperation();
        String wsdlFileName = psiClass.getName() + ".wsdl";
        File tempFile = new File(psiClass.getContainingFile().getContainingDirectory().getVirtualFile().getPath() + "/" + wsdlFileName);
        parametersList.add("-o");
        parametersList.add(tempFile.getParentFile().getPath());
        parametersList.add("-st");
        parametersList.add(options.getBindingStyle().toLowerCase());
        parametersList.add("-tn");
        String webServiceNamespace = options.getWebServiceNamespace();
        parametersList.add(webServiceNamespace);
        parametersList.add("-stn");
        parametersList.add(webServiceNamespace);
        parametersList.add("-l");
        parametersList.add(options.getWebServiceURL());
        parametersList.add("-u");
        parametersList.add(options.getUseOfItems().toLowerCase());
        parametersList.add("-cn");
        parametersList.add(psiClass.getQualifiedName());
        InvokeExternalCodeUtil.invokeExternalProcess2((ExternalProcessHandler)new InvokeExternalCodeUtil.JavaExternalProcessHandler("Axis2 Java 2 WSDL", "org.apache.ws.java2wsdl.Java2WSDL", options.getClassPathEntries(), ArrayUtil.toStringArray(parametersList), options.getModule(), false), (Project)options.getModule().getProject(), (Runnable)options.getSuccessRunnable(onSuccessAction, tempFile), onException, options.isParametersStillValidPredicate(), (Runnable)editAgain);
    }

    @Override
    public String[] getWebServicesOperations(String webServiceName, Module module) {
        final ArrayList result = new ArrayList();
        DeployUtils.processTagsInConfigFile(this.pathComponents, false, module, new Processor<XmlTag>(){

            public boolean process(XmlTag xmlTag) {
                if (xmlTag.getAttributeValue("name") != null && "operation".equals(xmlTag.getName())) {
                    result.add(xmlTag.getAttributeValue("name"));
                }
                return true;
            }
        });
        return ArrayUtil.toStringArray(result);
    }

    @Override
    public void deployWebService(DeployWebServiceOptions createOptions, Module module, Runnable onSuccessAction, Consumer<Exception> onExceptionAction, Runnable restartAction) {
        DeployUtils.addToConfigFile(this.pathComponents, false, module, "<service name=\"" + createOptions.getWsName() + "\">\n" + "    <parameter name=\"ServiceClass\" locked=\"false\">" + createOptions.getWsClassName() + "</parameter>\n" + "    <operation name=\"*\">\n" + "    <messageReceiver  class=\"org.apache.axis2.rpc.receivers.RPCMessageReceiver\" />\n" + "    </operation>\n" + "</service>", this);
        onSuccessAction.run();
    }

    @Override
    public void undeployWebService(final String webServiceName, Module module, Runnable onSuccessAction, Consumer<Exception> onExceptionAction, Runnable restartAction) {
        DeployUtils.removeFromConfigFile(this.pathComponents, false, module, new Processor<XmlTag>(){

            public boolean process(XmlTag t) {
                return webServiceName.equals(t.getAttributeValue("name"));
            }
        });
        onSuccessAction.run();
    }

    @Override
    public String[] getAvailableWebServices(Module module) {
        final ArrayList availableWS = new ArrayList(1);
        DeployUtils.processTagsInConfigFile(this.pathComponents, false, module, new Processor<XmlTag>(){

            public boolean process(XmlTag xmlTag) {
                String wsname = xmlTag.getAttributeValue("name");
                if (wsname != null) {
                    availableWS.add(wsname);
                }
                return true;
            }
        });
        return ArrayUtil.toStringArray(availableWS);
    }

    @Override
    public ExternalProcessHandler getGenerateJavaFromWsdlHandler(GenerateJavaFromWsdlOptions options) {
        ArrayList<String> parameters = new ArrayList<String>(3);
        parameters.add("-uri");
        parameters.add(FileUtils.removeFileProtocolPrefixIfPresent((String)options.getWsdlUrl()));
        parameters.add("-o");
        String outputPathForAxis2 = options.getOutputPath();
        if (outputPathForAxis2.endsWith(File.separator + "src")) {
            outputPathForAxis2 = outputPathForAxis2.substring(0, outputPathForAxis2.length() - 4);
        }
        parameters.add(outputPathForAxis2 + File.separator);
        parameters.add("-p");
        parameters.add(options.getPackagePrefix());
        if (options.isToGenerateTestCase()) {
            parameters.add("-t");
        }
        parameters.add("-d");
        parameters.add(options.getBindingType().toLowerCase());
        if (options.isServersideSkeletonGeneration()) {
            parameters.add("-ss");
            parameters.add("-sd");
        }
        return new InvokeExternalCodeUtil.JavaExternalProcessHandler("Axis 2 WSDL2Java", "org.apache.axis2.wsdl.WSDL2Java", LibUtils.getLibsUrlsFromLibInfos(this.getLibraryDescriptors(options.getBindingType(), false), this.getBasePath()), ArrayUtil.toStringArray(parameters), null, true);
    }

    @Override
    public boolean isConfigured() {
        return this.getBasePath() != null;
    }

    @Override
    public String getWebServicesInterfaceTemplateName() {
        return "j2ee1_4.webservice.interface.java";
    }

    @Override
    public String getWebServicesTemplateName() {
        return "j2ee1_4.webservice.java";
    }
}

