/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.engines.wsengine;

import com.intellij.util.ArrayUtil;
import com.intellij.ws.engines.ExternalEngine;
import com.intellij.ws.engines.ExternalEngineThatChangedTheName;
import com.intellij.ws.engines.axis.AxisWSEngine;
import com.intellij.ws.engines.axis2.Axis2WSEngine;
import com.intellij.ws.engines.cxf.CXFWSEngine;
import com.intellij.ws.engines.jaxrpc.JaxRPCWSEngine;
import com.intellij.ws.engines.jbossws.JBossWSEngine;
import com.intellij.ws.engines.jwsdp.JWSDPWSEngine;
import com.intellij.ws.engines.websphere.WebSphereWSEngine;
import com.intellij.ws.engines.wsengine.WSEngine;
import com.intellij.ws.xml.jaxb.JaxbMappingEngine;
import com.intellij.ws.xml.xmlbeans.XmlBeansMappingEngine;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class WSEngineManager {
    private final Map<String, ExternalEngine> myExternalEngines = new HashMap<String, ExternalEngine>();
    private final Map<String, WSEngine> myWSEngines = new HashMap<String, WSEngine>();

    public WSEngineManager() {
        this.registerWSEngine(new AxisWSEngine());
        this.registerWSEngine(new CXFWSEngine());
        this.registerWSEngine(new JWSDPWSEngine());
        this.registerWSEngine(new Axis2WSEngine());
        this.registerWSEngine(new JBossWSEngine());
        this.registerWSEngine(new JaxRPCWSEngine());
        this.registerWSEngine(new WebSphereWSEngine());
        this.registerExternalEngine(new JaxbMappingEngine());
        this.registerExternalEngine(new XmlBeansMappingEngine());
    }

    private void registerWSEngine(WSEngine wsEngine) {
        this.myWSEngines.put(wsEngine.getName(), wsEngine);
    }

    private void registerExternalEngine(ExternalEngine externalEngine) {
        this.myExternalEngines.put(externalEngine.getName(), externalEngine);
    }

    public WSEngine getWSEngineByName(String engineName) {
        WSEngine wsEngine = this.myWSEngines.get(engineName);
        if (wsEngine == null) {
            for (Map.Entry<String, WSEngine> entry : this.myWSEngines.entrySet()) {
                if (!(entry.getValue() instanceof ExternalEngineThatChangedTheName) || !((ExternalEngineThatChangedTheName)((Object)entry.getValue())).isYourOldName(engineName)) continue;
                return entry.getValue();
            }
        }
        return wsEngine;
    }

    public ExternalEngine getExternalEngineByName(String engineName) {
        return this.myExternalEngines.get(engineName);
    }

    public String[] getAvailableWSEngineNames() {
        Object[] strings = this.myWSEngines.keySet().toArray(new String[this.myWSEngines.size()]);
        Arrays.sort(strings);
        return strings;
    }

    public String[] getAvailableWSEngineNamesWithSupportedDeployment() {
        ArrayList<String> engineNamesThatSupportDeployment = new ArrayList<String>();
        for (WSEngine engine : this.myWSEngines.values()) {
            if (!engine.deploymentSupported()) continue;
            engineNamesThatSupportDeployment.add(engine.getName());
        }
        Object[] engineNamesArrayThatSupportDeployment = ArrayUtil.toStringArray(engineNamesThatSupportDeployment);
        Arrays.sort(engineNamesArrayThatSupportDeployment);
        return engineNamesArrayThatSupportDeployment;
    }

    public String[] getConfiguredWSEngines() {
        ArrayList<String> configuredEngineNames = new ArrayList<String>();
        for (WSEngine engine : this.myWSEngines.values()) {
            if (!engine.isConfigured()) continue;
            configuredEngineNames.add(engine.getName());
        }
        Object[] sortedConfiguredEngineNames = ArrayUtil.toStringArray(configuredEngineNames);
        Arrays.sort(sortedConfiguredEngineNames);
        return sortedConfiguredEngineNames;
    }
}

