/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.utils.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.ws.utils.DeploymentTimeCheckProcessor;
import com.intellij.ws.utils.ui.MethodDeploymentTableModel;
import com.intellij.ws.utils.ui.MethodTableCellRenderer;
import com.intellij.ws.utils.ui.MyDialogWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;

public abstract class GenerateFromJavaCodeDialogBase
extends MyDialogWrapper {
    private HashMap<PsiMethod, String> myMethod2DeploymentProblemsMap;
    private boolean requestedOnce;

    public GenerateFromJavaCodeDialogBase(Project _project, PsiClass clazz) {
        super(_project);
        this.setCurrentClass(clazz);
    }

    @Override
    protected void init() {
        super.init();
        this.initRenderers();
    }

    private void initRenderers() {
        this.getMethodsTable().setDefaultRenderer(PsiMethod.class, new MethodTableCellRenderer(){

            @Override
            protected String getProblemByMethod(PsiMethod method) {
                return (String)GenerateFromJavaCodeDialogBase.this.myMethod2DeploymentProblemsMap.get(method);
            }
        });
    }

    protected abstract JTable getMethodsTable();

    @Override
    public void setCurrentClass(PsiClass aClass) {
        super.setCurrentClass(aClass);
        this.fillMethodsTable();
    }

    protected void fillMethodsTable() {
        if (this.getMethodsTable() == null) {
            if (!this.requestedOnce) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GenerateFromJavaCodeDialogBase.this.fillMethodsTable();
                    }
                });
                this.requestedOnce = true;
            }
            return;
        }
        PsiClass clazz = this.getCurrentClass();
        PsiMethod[] methods = clazz != null ? clazz.getMethods() : PsiMethod.EMPTY_ARRAY;
        this.myMethod2DeploymentProblemsMap = new HashMap(methods.length);
        final ArrayList<PsiMethod> methodsAllowedForDeployment = new ArrayList<PsiMethod>(methods.length);
        final ArrayList<PsiMethod> methodsNotAllowedForDeployment = new ArrayList<PsiMethod>(methods.length);
        new DeploymentTimeCheckProcessor(){

            @Override
            public void processMethod(PsiMethod method, String problem, List<String> nonelementaryTypes) {
                GenerateFromJavaCodeDialogBase.this.myMethod2DeploymentProblemsMap.put(method, problem);
                if (problem == null) {
                    methodsAllowedForDeployment.add(method);
                } else {
                    methodsNotAllowedForDeployment.add(method);
                }
            }
        }.processClassMethods(methods);
        MethodDeploymentTableModel dataModel = this.createMethodDeploymentTable(methodsAllowedForDeployment, methodsNotAllowedForDeployment);
        this.getMethodsTable().setModel(dataModel);
    }

    protected MethodDeploymentTableModel createMethodDeploymentTable(List<PsiMethod> methodsAllowedForDeployment, List<PsiMethod> methodsNotAllowedForDeployment) {
        return new MethodDeploymentTableModel(methodsAllowedForDeployment, methodsNotAllowedForDeployment);
    }

    @Override
    protected ValidationInfo doValidate(MyDialogWrapper.ValidationData _data) {
        String s;
        PsiClass clazz = this.getCurrentClass();
        String string = s = clazz != null ? DeploymentTimeCheckProcessor.checkAccessibleClassPrerequisites(this.myProject, clazz) : NO_CLASS_IN_SELECTED_TEXT_EDITOR;
        if (s != null) {
            return new ValidationInfo(s, null);
        }
        return null;
    }

    public PsiMethod[] getSelectedMethods() {
        TableModel tableModel = this.getMethodsTable().getModel();
        if (!(tableModel instanceof MethodDeploymentTableModel)) {
            return PsiMethod.EMPTY_ARRAY;
        }
        return ((MethodDeploymentTableModel)tableModel).getSelectedMethods();
    }

    @Override
    protected MyValidationData createValidationData() {
        return new MyValidationData();
    }

    protected class MyValidationData
    extends MyDialogWrapper.ValidationData {
        public PsiMethod[] selectedMethods;

        protected MyValidationData() {
        }

        @Override
        protected void doAcquire() {
            this.selectedMethods = GenerateFromJavaCodeDialogBase.this.getSelectedMethods();
        }
    }
}

