/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css;

import com.intellij.codeInsight.preview.ColorPreviewComponent;
import com.intellij.codeInsight.preview.ImagePreviewComponent;
import com.intellij.codeInsight.preview.PreviewHintProvider;
import com.intellij.css.util.CssImageUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssElement;
import com.intellij.psi.css.CssFile;
import com.intellij.psi.css.CssString;
import com.intellij.psi.css.CssUri;
import com.intellij.psi.css.impl.util.CssPsiColorUtil;
import com.intellij.psi.css.impl.util.CssReferenceProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.URLUtil;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Collection;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class CssPreviewHintProvider
implements PreviewHintProvider {
    public boolean isSupportedFile(PsiFile file) {
        return file instanceof CssFile;
    }

    public JComponent getPreviewComponent(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/CssPreviewHintProvider", "getPreviewComponent"));
        }
        Color color = CssPsiColorUtil.getColor(element);
        if (color != null) {
            try {
                return new ColorPreviewComponent(color);
            }
            catch (NumberFormatException ignored) {
                return null;
            }
        }
        Pair<BufferedImage, Long> imageAndSize = CssPreviewHintProvider.getImageAndSizeForElement(element);
        if (imageAndSize != null) {
            return ImagePreviewComponent.getPreviewComponent((BufferedImage)((BufferedImage)imageAndSize.first), (long)((Long)imageAndSize.second));
        }
        return null;
    }

    private static Pair<BufferedImage, Long> getImageAndSizeForElement(PsiElement element) {
        try {
            CssUri cssUri = (CssUri)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{CssUri.class});
            if (cssUri != null) {
                String cssUriValue = cssUri.getValue();
                if (URLUtil.isDataUri((String)cssUriValue)) {
                    byte[] imageBytes = URLUtil.getBytesFromDataUri((String)cssUriValue);
                    if (imageBytes != null) {
                        return Pair.create((Object)ImagePreviewComponent.readImageFromBytes((byte[])imageBytes), (Object)imageBytes.length);
                    }
                } else {
                    VirtualFile imageFile = (VirtualFile)ContainerUtil.getFirstItem((Collection)CssImageUtil.getImageFiles((CssElement)cssUri));
                    if (imageFile != null) {
                        byte[] imageBytes = imageFile.contentsToByteArray();
                        return Pair.create((Object)ImagePreviewComponent.readImageFromBytes((byte[])imageBytes), (Object)imageBytes.length);
                    }
                }
            } else {
                VirtualFile imageFile;
                CssString cssString = (CssString)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{CssString.class});
                if (CssReferenceProvider.isInsideImageFunction((PsiElement)cssString) && (imageFile = (VirtualFile)ContainerUtil.getFirstItem((Collection)CssImageUtil.getImageFiles((CssElement)cssString))) != null) {
                    byte[] imageBytes = imageFile.contentsToByteArray();
                    return Pair.create((Object)ImagePreviewComponent.readImageFromBytes((byte[])imageBytes), (Object)imageBytes.length);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }
}

