/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.css.util.CssPsiUtil;
import com.intellij.lang.Language;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;

public class CssTypedHandler
extends TypedHandlerDelegate {
    public TypedHandlerDelegate.Result checkAutoPopup(char charTyped, Project project, Editor editor, PsiFile file) {
        char prevChar;
        int offset;
        Language languageAtOffset;
        if (!(file instanceof CssFile) && !(languageAtOffset = PsiUtilCore.getLanguageAtOffset((PsiFile)file, (int)editor.getCaretModel().getOffset())).isKindOf((Language)CSSLanguage.INSTANCE)) {
            return super.checkAutoPopup(charTyped, project, editor, file);
        }
        AutoPopupController autoPopupController = AutoPopupController.getInstance((Project)project);
        if (charTyped == '#') {
            autoPopupController.autoPopupMemberLookup(editor, null);
            return TypedHandlerDelegate.Result.STOP;
        }
        if (charTyped == '-' || charTyped == '!') {
            if (PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(editor.getCaretModel().getOffset()), CssBlock.class) != null) {
                autoPopupController.autoPopupMemberLookup(editor, null);
                return TypedHandlerDelegate.Result.STOP;
            }
        } else if (charTyped == ' ' && file instanceof CssFile && (offset = editor.getCaretModel().getOffset()) > 0 && ('{' == (prevChar = editor.getDocument().getCharsSequence().charAt(offset - 1)) || ';' == prevChar || ':' == prevChar)) {
            autoPopupController.autoPopupMemberLookup(editor, null);
            return TypedHandlerDelegate.Result.STOP;
        }
        return super.checkAutoPopup(charTyped, project, editor, file);
    }

    public TypedHandlerDelegate.Result beforeCharTyped(char c, Project project, Editor editor, PsiFile file, FileType fileType) {
        Document document;
        int offset;
        String terminator;
        if (file instanceof CssFile && (terminator = CssPsiUtil.getDeclarationsTerminatorFromContext((PsiElement)file)).length() == 1 && c == terminator.charAt(0) && (offset = editor.getCaretModel().getOffset()) < (document = editor.getDocument()).getTextLength() && document.getCharsSequence().charAt(offset) == c) {
            editor.getCaretModel().moveToOffset(offset + 1);
            return TypedHandlerDelegate.Result.STOP;
        }
        return super.beforeCharTyped(c, project, editor, file, fileType);
    }
}

