/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.actions.ruleset;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssFile;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.actions.ruleset.CreateStyleCallback;
import com.intellij.psi.css.actions.ruleset.InputSelectorDialog;
import com.intellij.psi.css.actions.ruleset.StyleCreator;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.css.resolve.CssResolveManager;
import com.intellij.psi.css.resolve.CssResolver;
import com.intellij.psi.css.util.AbstractTagUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExistingFileStyleCreator
extends StyleCreator {
    private static final String HREF_ATTRIBUTE_NAME = "href";
    private final CssFile myTargetFile;

    public ExistingFileStyleCreator(@NotNull PsiFile contextFile, @NotNull CssFile targetFile) {
        if (contextFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextFile", "com/intellij/psi/css/actions/ruleset/ExistingFileStyleCreator", "<init>"));
        }
        if (targetFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetFile", "com/intellij/psi/css/actions/ruleset/ExistingFileStyleCreator", "<init>"));
        }
        super(targetFile.getName(), contextFile);
        this.myTargetFile = targetFile;
    }

    @Override
    @Nullable
    public CssRuleset createStyleDeclaration(final @NotNull String selector, final CssDeclaration ... declarations) {
        if (selector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "com/intellij/psi/css/actions/ruleset/ExistingFileStyleCreator", "createStyleDeclaration"));
        }
        if (declarations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarations", "com/intellij/psi/css/actions/ruleset/ExistingFileStyleCreator", "createStyleDeclaration"));
        }
        return (CssRuleset)WriteCommandAction.runWriteCommandAction((Project)this.myContextFile.getProject(), (Computable)new Computable<CssRuleset>(){

            @Nullable
            public CssRuleset compute() {
                CssRuleset createdRuleset = StyleCreator.createStyleInCssFile(ExistingFileStyleCreator.this.myTargetFile, selector, declarations);
                if (createdRuleset != null) {
                    ExistingFileStyleCreator.this.addCssLinkToContextFileIfNeeded();
                }
                return createdRuleset;
            }
        });
    }

    @Override
    public void createStyleDeclarationInteractively(@NotNull Editor editor, @NotNull String defaultSelector, @NotNull Collection<String> selectorVariants, @Nullable CreateStyleCallback callback, CssDeclaration ... declarations) {
        String selectorName;
        boolean done;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/psi/css/actions/ruleset/ExistingFileStyleCreator", "createStyleDeclarationInteractively"));
        }
        if (defaultSelector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultSelector", "com/intellij/psi/css/actions/ruleset/ExistingFileStyleCreator", "createStyleDeclarationInteractively"));
        }
        if (selectorVariants == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectorVariants", "com/intellij/psi/css/actions/ruleset/ExistingFileStyleCreator", "createStyleDeclarationInteractively"));
        }
        if (declarations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarations", "com/intellij/psi/css/actions/ruleset/ExistingFileStyleCreator", "createStyleDeclarationInteractively"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            done = true;
            selectorName = defaultSelector;
        } else {
            InputSelectorDialog inputSelectorDialog = new InputSelectorDialog(this.myContextFile.getProject(), (LanguageFileType)this.myTargetFile.getFileType(), ArrayUtil.toStringArray(selectorVariants));
            done = inputSelectorDialog.showAndGet();
            selectorName = StringUtil.notNullize((String)StringUtil.nullize((String)inputSelectorDialog.getValue(), (boolean)true), (String)defaultSelector);
        }
        if (done) {
            CssRuleset ruleset = this.createStyleDeclaration(selectorName, declarations);
            if (callback != null) {
                callback.after(selectorName, ruleset);
            }
        }
    }

    private void addCssLinkToContextFileIfNeeded() {
        if (this.myContextFile instanceof XmlFile && !ExistingFileStyleCreator.fileAlreadyHasLinkToGivenFile((XmlFile)this.myContextFile, this.myTargetFile)) {
            ApplicationManager.getApplication().assertWriteAccessAllowed();
            if (!FileModificationService.getInstance().prepareFileForWrite(this.myContextFile)) {
                return;
            }
            Project project = this.myContextFile.getProject();
            XmlTag parentTagForLink = ExistingFileStyleCreator.findParentTagForLink((XmlFile)this.myContextFile);
            if (parentTagForLink != null) {
                XmlElementFactory elementFactory = XmlElementFactory.getInstance((Project)project);
                VirtualFile targetVirtualFile = this.myTargetFile.getVirtualFile();
                if (targetVirtualFile != null) {
                    XmlAttributeValue hrefAttributeValue;
                    String relativePath = VfsUtilCore.getRelativePath((VirtualFile)targetVirtualFile, (VirtualFile)project.getBaseDir(), (char)'/');
                    String path = relativePath != null ? relativePath : targetVirtualFile.getPath();
                    XmlTag linkTag = elementFactory.createTagFromText((CharSequence)("<link rel=\"stylesheet\" type=\"text/css\" href=\"" + path + "\"/>"));
                    if ((linkTag = parentTagForLink.addSubTag(linkTag, true)) != null && (hrefAttributeValue = ExistingFileStyleCreator.getHrefAttributeValue(linkTag)) != null) {
                        CssUtil.rebindFileReference((PsiElement)linkTag, (PsiFile)this.myTargetFile);
                    }
                }
            }
        }
    }

    private static boolean fileAlreadyHasLinkToGivenFile(@NotNull XmlFile contextFile, @NotNull CssFile fileToLink) {
        if (contextFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextFile", "com/intellij/psi/css/actions/ruleset/ExistingFileStyleCreator", "fileAlreadyHasLinkToGivenFile"));
        }
        if (fileToLink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileToLink", "com/intellij/psi/css/actions/ruleset/ExistingFileStyleCreator", "fileAlreadyHasLinkToGivenFile"));
        }
        CssResolver resolver = CssResolveManager.getInstance().getNewResolver();
        resolver.setStrictResolveMode(true);
        Object[] cssFiles = resolver.resolveStyleSheets(contextFile, null);
        return ArrayUtil.contains((Object)fileToLink, (Object[])cssFiles);
    }

    @Nullable
    private static XmlAttributeValue getHrefAttributeValue(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/psi/css/actions/ruleset/ExistingFileStyleCreator", "getHrefAttributeValue"));
        }
        XmlAttribute hrefAttribute = tag.getAttribute(HREF_ATTRIBUTE_NAME);
        return hrefAttribute != null ? hrefAttribute.getValueElement() : null;
    }

    @Nullable
    private static XmlTag findParentTagForLink(XmlFile file) {
        XmlDocument document = file.getDocument();
        if (document == null) {
            return null;
        }
        XmlTag headTag = AbstractTagUtil.findGenericHeadTag(document);
        if (headTag != null) {
            return headTag;
        }
        XmlTag htmlTag = AbstractTagUtil.findGenericHtmlTag(document);
        if (htmlTag != null) {
            XmlTag newHeadTag = XmlElementFactory.getInstance((Project)file.getProject()).createTagFromText((CharSequence)"<head></head>");
            return htmlTag.addSubTag(newHeadTag, true);
        }
        return null;
    }
}

