/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.actions.ruleset;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssFile;
import com.intellij.psi.css.actions.ruleset.StyleCreatorWithFileChooser;
import com.intellij.psi.css.index.CssSupportedFileTypesProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExistingFileStyleCreatorWithChooser
extends StyleCreatorWithFileChooser {
    public ExistingFileStyleCreatorWithChooser(@NotNull PsiFile contextFile) {
        if (contextFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextFile", "com/intellij/psi/css/actions/ruleset/ExistingFileStyleCreatorWithChooser", "<init>"));
        }
        super(CssBundle.message((String)"css.inspections.create.style.existing.file", (Object[])new Object[0]), contextFile);
    }

    @Override
    @Nullable
    protected CssFile chooseFile() {
        final FileChooserDescriptor descriptor = this.createCssFileChooserDescriptor();
        final Project project = this.myContextFile.getProject();
        final Ref result = new Ref();
        ApplicationManager.getApplication().invokeAndWait(new Runnable(){

            @Override
            public void run() {
                FileChooserDialog chooser = FileChooserFactory.getInstance().createFileChooser(descriptor, project, null);
                VirtualFile[] cssFiles = chooser.choose(project, new VirtualFile[0]);
                if (cssFiles.length > 0) {
                    VirtualFile cssFile = cssFiles[0];
                    PsiFile psiCssFile = PsiManager.getInstance((Project)project).findFile(cssFile);
                    if (psiCssFile instanceof CssFile) {
                        result.set((Object)((CssFile)psiCssFile));
                    }
                }
            }
        }, ModalityState.any());
        return (CssFile)result.get();
    }

    @NotNull
    private FileChooserDescriptor createCssFileChooserDescriptor() {
        CssFileChooserDescriptor descriptor = new CssFileChooserDescriptor();
        Project project = this.myContextFile.getProject();
        descriptor.setRoots(ProjectRootManager.getInstance((Project)project).getContentRoots());
        descriptor.withTreeRootVisible(true);
        CssFileChooserDescriptor cssFileChooserDescriptor = descriptor;
        if (cssFileChooserDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/actions/ruleset/ExistingFileStyleCreatorWithChooser", "createCssFileChooserDescriptor"));
        }
        return cssFileChooserDescriptor;
    }

    private static class CssFileChooserDescriptor
    extends FileChooserDescriptor {
        public CssFileChooserDescriptor() {
            super(true, false, false, false, false, false);
        }

        public boolean isFileVisible(@NotNull VirtualFile file, boolean showHiddenFiles) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/css/actions/ruleset/ExistingFileStyleCreatorWithChooser$CssFileChooserDescriptor", "isFileVisible"));
            }
            return super.isFileVisible(file, showHiddenFiles) || CssSupportedFileTypesProvider.isSupportedFileType(file.getFileType());
        }

        public boolean isFileSelectable(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/css/actions/ruleset/ExistingFileStyleCreatorWithChooser$CssFileChooserDescriptor", "isFileSelectable"));
            }
            return super.isFileSelectable(file) && CssSupportedFileTypesProvider.isSupportedFileType(file.getFileType());
        }
    }
}

