/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.actions.smartenter.fixers;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssOneLineStatement;
import com.intellij.psi.css.actions.smartenter.fixers.CssFixer;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssMissingSemicolonFixer
implements CssFixer {
    @Override
    public boolean isApplicable(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/psi/css/actions/smartenter/fixers/CssMissingSemicolonFixer", "isApplicable"));
        }
        return CssMissingSemicolonFixer.getClosestOneLineStatement(psiElement) != null;
    }

    @Nullable
    private static PsiElement getClosestOneLineStatement(@Nullable PsiElement psiElement) {
        CssOneLineStatement element = CssUtil.findOneLineStatement(psiElement);
        if (element == null) {
            element = PsiTreeUtil.getChildOfType((PsiElement)psiElement, CssOneLineStatement.class);
        }
        return element;
    }

    @Override
    public boolean apply(@NotNull Editor editor, @NotNull PsiElement psiElement) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/psi/css/actions/smartenter/fixers/CssMissingSemicolonFixer", "apply"));
        }
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/psi/css/actions/smartenter/fixers/CssMissingSemicolonFixer", "apply"));
        }
        CssOneLineStatement editedElement = CssUtil.appendStatementWithSemicolonIfNeeded(psiElement.getProject(), psiElement);
        if (editedElement != null) {
            if (editedElement instanceof CssDeclaration) {
                editor.getCaretModel().moveToOffset(editedElement.getTextRange().getEndOffset() + 1);
            } else {
                editor.getCaretModel().moveToOffset(editedElement.getTextRange().getEndOffset());
            }
        }
        return editedElement != null;
    }

    @Override
    @Nullable
    public PsiElement getElementToReformat(@Nullable PsiElement currentElement) {
        return CssUtil.findOneLineStatement(currentElement);
    }
}

