/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.browse;

import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithActions;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssFileType;
import com.intellij.psi.css.browse.BreadcrumbsHtmlItem;
import com.intellij.psi.css.browse.BrowseCssStylesManager;
import com.intellij.psi.css.browse.BrowseCssStylesUtil;
import com.intellij.psi.css.browse.CssSourcePreview;
import com.intellij.psi.css.browse.CssStyles;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.css.resolve.CssResolver;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.content.Content;
import com.intellij.xml.breadcrumbs.BreadcrumbsComponent;
import com.intellij.xml.breadcrumbs.BreadcrumbsItemListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.LinkedList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class BrowseCssStylesPanel
extends JPanel
implements Disposable,
BreadcrumbsItemListener<BreadcrumbsHtmlItem>,
ListSelectionListener {
    private XmlTag myTag;
    private XmlTag myCurrentTag;
    private CssStyles myStylesComponent;
    private CssSourcePreview myPreview;
    private final CssResolver myResolver;
    @NonNls
    private static final String PREVIEW_CONTENT = "css.preview";
    @NonNls
    private static final String STYLES_CONTENT = "css.styles";
    private final RunnerLayoutUi myLayoutUi;
    private Project myProject;

    public BrowseCssStylesPanel(@NotNull XmlTag tag, @NotNull CssResolver resolver) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/psi/css/browse/BrowseCssStylesPanel", "<init>"));
        }
        if (resolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "com/intellij/psi/css/browse/BrowseCssStylesPanel", "<init>"));
        }
        this.setLayout(new BorderLayout());
        this.myResolver = resolver;
        this.myTag = tag;
        this.myCurrentTag = tag;
        this.myProject = this.myTag.getProject();
        this.myLayoutUi = RunnerLayoutUi.Factory.getInstance((Project)tag.getProject()).create("CSS.Styles2", CssBundle.message((String)"css.browser.title", (Object[])new Object[0]), tag.getName(), (Disposable)this);
        this.myLayoutUi.getDefaults().initTabDefaults(0, CssBundle.message((String)"css.browser.title", (Object[])new Object[0]), CssFileType.INSTANCE.getIcon());
        this.myLayoutUi.getOptions().setLeftToolbar(this.createToolbarComponent(), "unknown");
        this.myStylesComponent = this.initStylesComponent(this.myLayoutUi);
        this.myPreview = BrowseCssStylesPanel.initPreviewComponent(this.myLayoutUi);
        this.add((Component)this.createBreadcrumbsComponent(), "South");
        this.add((Component)this.myLayoutUi.getComponent(), "Center");
        this.refresh();
    }

    private static CssSourcePreview initPreviewComponent(RunnerLayoutUi layoutUi) {
        CssSourcePreview result = new CssSourcePreview();
        Content preview = layoutUi.createContent(PREVIEW_CONTENT, (ComponentWithActions)result, CssBundle.message((String)"css.browser.preview.title.default", (Object[])new Object[0]), CssSourcePreview.getIcon(), null);
        preview.setCloseable(false);
        Disposer.register((Disposable)preview, (Disposable)result);
        layoutUi.addContent(preview, 0, PlaceInGrid.right, false);
        return result;
    }

    private CssStyles initStylesComponent(RunnerLayoutUi layoutUi) {
        CssStyles result = new CssStyles(this.myResolver){};
        Content styles = layoutUi.createContent(STYLES_CONTENT, (ComponentWithActions)result, CssBundle.message((String)"css.browser.styles.title", (Object[])new Object[]{BrowseCssStylesUtil.getFormattedName(this.myTag)}), null, null);
        styles.setCloseable(false);
        Disposer.register((Disposable)styles, (Disposable)result);
        layoutUi.addContent(styles, 0, PlaceInGrid.left, false);
        return result;
    }

    public void refresh() {
        this.myStylesComponent.removeListSelectionListener(this);
        this.myStylesComponent.setTag(this.myCurrentTag);
        this.myStylesComponent.addListSelectionListener(this);
    }

    public XmlTag getTag() {
        return this.myTag;
    }

    private JComponent createBreadcrumbsComponent() {
        BreadcrumbsComponent breadcrumbs = new BreadcrumbsComponent();
        breadcrumbs.addBreadcrumbsItemListener((BreadcrumbsItemListener)this);
        Disposer.register((Disposable)this, (Disposable)breadcrumbs);
        XmlTag parent = this.getTag();
        LinkedList<BreadcrumbsHtmlItem> items = new LinkedList<BreadcrumbsHtmlItem>();
        do {
            if (!(parent instanceof XmlTag)) continue;
            items.addFirst(new BreadcrumbsHtmlItem(parent));
        } while ((parent = parent.getParent()) != null);
        breadcrumbs.setItems(items);
        return breadcrumbs;
    }

    private ActionGroup createToolbarComponent() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add(new AnAction(CssBundle.message((String)"css.browser.actions.refresh", (Object[])new Object[0]), CssBundle.message((String)"css.browser.actions.refresh.description", (Object[])new Object[0]), AllIcons.Actions.Refresh){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/psi/css/browse/BrowseCssStylesPanel$2", "actionPerformed"));
                }
                if (BrowseCssStylesPanel.this.myCurrentTag != null && BrowseCssStylesPanel.this.myCurrentTag.isValid()) {
                    BrowseCssStylesPanel.this.refresh();
                }
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/psi/css/browse/BrowseCssStylesPanel$2", "update"));
                }
                e.getPresentation().setEnabled(BrowseCssStylesPanel.this.myCurrentTag != null && BrowseCssStylesPanel.this.myCurrentTag.isValid());
            }
        });
        group.addSeparator();
        group.add(this.myLayoutUi.getOptions().getLayoutActions());
        group.addSeparator();
        group.add(new AnAction(CssBundle.message((String)"css.browser.actions.closetab", (Object[])new Object[0]), CssBundle.message((String)"css.browser.actions.closetab.description", (Object[])new Object[0]), AllIcons.Actions.Cancel){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/psi/css/browse/BrowseCssStylesPanel$3", "actionPerformed"));
                }
                BrowseCssStylesManager.getInstance(BrowseCssStylesPanel.this.myProject).removeStylesTab(BrowseCssStylesPanel.this);
            }
        });
        return group;
    }

    public void dispose() {
        if (this.myPreview != null) {
            Disposer.dispose((Disposable)this.myPreview);
        }
        this.myPreview = null;
        this.myStylesComponent = null;
        this.myCurrentTag = null;
        this.myTag = null;
        this.myProject = null;
    }

    public void itemSelected(@NotNull BreadcrumbsHtmlItem item, int modifiers) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/psi/css/browse/BrowseCssStylesPanel", "itemSelected"));
        }
        this.myCurrentTag = item.getTag();
        this.updateContentTitle(STYLES_CONTENT, CssBundle.message((String)"css.browser.styles.title", (Object[])new Object[]{BrowseCssStylesUtil.getFormattedName(this.myCurrentTag)}));
        this.refresh();
    }

    public void itemHovered(BreadcrumbsHtmlItem item) {
    }

    private void updateContentTitle(@NotNull String contentId, @NotNull String title) {
        if (contentId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentId", "com/intellij/psi/css/browse/BrowseCssStylesPanel", "updateContentTitle"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/psi/css/browse/BrowseCssStylesPanel", "updateContentTitle"));
        }
        Content content = this.myLayoutUi.findContent(contentId);
        if (content != null) {
            content.setDisplayName(title);
        }
    }

    @Override
    public void valueChanged(@NotNull ListSelectionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/psi/css/browse/BrowseCssStylesPanel", "valueChanged"));
        }
        CssDeclaration selected = this.myStylesComponent.getSelectedItem();
        if (selected != null && selected.isValid()) {
            this.updateContentTitle(PREVIEW_CONTENT, CssBundle.message((String)"css.browser.preview.title", (Object[])new Object[]{CssDescriptorsUtil.getCanonicalPropertyName((CssDeclaration)selected)}));
            this.myPreview.setDeclaration(selected);
        }
    }
}

