/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssAtRule;
import com.intellij.psi.css.CssCharset;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssFile;
import com.intellij.psi.css.CssImport;
import com.intellij.psi.css.CssImportList;
import com.intellij.psi.css.CssNamespace;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssRulesetList;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.impl.CssCharsetImpl;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssRulesetWrappingElement;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.LazyParseablePsiElement;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CssStylesheetImpl
extends LazyParseablePsiElement
implements CssStylesheet,
XmlTagChild {
    CssStylesheetImpl(CharSequence text) {
        this(text, (IElementType)CssElementTypes.CSS_STYLESHEET);
    }

    public CssStylesheetImpl(CharSequence text, IElementType nodeType) {
        super(nodeType, text);
    }

    @NotNull
    public CssRulesetList getRulesetList() {
        CssRulesetList cssRulesetList = (CssRulesetList)CachedValuesManager.getCachedValue((PsiElement)this, (CachedValueProvider)new CachedValueProvider<CssRulesetList>(){

            @Nullable
            public CachedValueProvider.Result<CssRulesetList> compute() {
                return CachedValueProvider.Result.create((Object)PsiTreeUtil.getChildOfType((PsiElement)CssStylesheetImpl.this, CssRulesetList.class), (Object[])new Object[]{CssStylesheetImpl.this});
            }
        });
        if (cssRulesetList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssStylesheetImpl", "getRulesetList"));
        }
        return cssRulesetList;
    }

    @Nullable
    public CssImportList getImportList() {
        return (CssImportList)CachedValuesManager.getCachedValue((PsiElement)this, (CachedValueProvider)new CachedValueProvider<CssImportList>(){

            @Nullable
            public CachedValueProvider.Result<CssImportList> compute() {
                return CachedValueProvider.Result.create((Object)PsiTreeUtil.getChildOfType((PsiElement)CssStylesheetImpl.this, CssImportList.class), (Object[])new Object[]{CssStylesheetImpl.this});
            }
        });
    }

    @NotNull
    public CssAtRule[] getAtRules() {
        CssAtRule[] cssAtRuleArray = (CssAtRule[])CachedValuesManager.getCachedValue((PsiElement)this, (CachedValueProvider)new CachedValueProvider<CssAtRule[]>(){

            @Nullable
            public CachedValueProvider.Result<CssAtRule[]> compute() {
                HashSet dependentStylesheets = ContainerUtil.newHashSet();
                return CachedValueProvider.Result.create((Object)CssStylesheetImpl.this.getAtRules(dependentStylesheets), (Object[])ArrayUtil.toObjectArray((Collection)dependentStylesheets, CssStylesheet.class));
            }
        });
        if (cssAtRuleArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssStylesheetImpl", "getAtRules"));
        }
        return cssAtRuleArray;
    }

    @NotNull
    public CssRuleset[] getRulesets() {
        CssRuleset[] cssRulesetArray = this.getRulesets(false);
        if (cssRulesetArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssStylesheetImpl", "getRulesets"));
        }
        return cssRulesetArray;
    }

    @NotNull
    public CssNamespace[] getNamespaces() {
        CssNamespace[] cssNamespaceArray = (CssNamespace[])CachedValuesManager.getCachedValue((PsiElement)this, (CachedValueProvider)new CachedValueProvider<CssNamespace[]>(){

            @Nullable
            public CachedValueProvider.Result<CssNamespace[]> compute() {
                for (PsiElement child = CssStylesheetImpl.this.getFirstChild(); child != null && !(child instanceof CssRulesetList); child = child.getNextSibling()) {
                    if (!(child instanceof CompositePsiElement) || ((CompositePsiElement)child).getElementType() != CssElementTypes.CSS_NAMESPACE_LIST) continue;
                    return CachedValueProvider.Result.create((Object)PsiTreeUtil.getChildrenOfType((PsiElement)child, CssNamespace.class), (Object[])new Object[]{CssStylesheetImpl.this});
                }
                return CachedValueProvider.Result.create((Object)CssNamespace.EMPTY_ARRAY, (Object[])new Object[]{CssStylesheetImpl.this});
            }
        });
        if (cssNamespaceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssStylesheetImpl", "getNamespaces"));
        }
        return cssNamespaceArray;
    }

    @NotNull
    public CssRuleset[] getRulesets(boolean allMedias) {
        if (allMedias) {
            CssRuleset[] cssRulesetArray = (CssRuleset[])CachedValuesManager.getCachedValue((PsiElement)this, (CachedValueProvider)new CachedValueProvider<CssRuleset[]>(){

                @Nullable
                public CachedValueProvider.Result<CssRuleset[]> compute() {
                    HashSet dependentStylesheets = ContainerUtil.newHashSet();
                    return CachedValueProvider.Result.create((Object)CssStylesheetImpl.this.getRulesets(dependentStylesheets, true), (Object[])ArrayUtil.toObjectArray((Collection)dependentStylesheets, CssStylesheet.class));
                }
            });
            if (cssRulesetArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssStylesheetImpl", "getRulesets"));
            }
            return cssRulesetArray;
        }
        CssRuleset[] cssRulesetArray = (CssRuleset[])CachedValuesManager.getCachedValue((PsiElement)this, (CachedValueProvider)new CachedValueProvider<CssRuleset[]>(){

            @Nullable
            public CachedValueProvider.Result<CssRuleset[]> compute() {
                HashSet dependentStylesheets = ContainerUtil.newHashSet();
                return CachedValueProvider.Result.create((Object)CssStylesheetImpl.this.getRulesets(dependentStylesheets, false), (Object[])ArrayUtil.toObjectArray((Collection)dependentStylesheets, CssStylesheet.class));
            }
        });
        if (cssRulesetArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssStylesheetImpl", "getRulesets"));
        }
        return cssRulesetArray;
    }

    @Nullable
    public CssNamespace getNamespace(@Nullable String prefix) {
        for (CssNamespace namespace : this.getNamespaces()) {
            if (!(prefix == null ? namespace.getPrefix() == null : prefix.equals(namespace.getPrefix()))) continue;
            return namespace;
        }
        return null;
    }

    private CssRuleset[] getRulesets(@NotNull Set<CssStylesheet> includedFiles, boolean allMedias) {
        if (includedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "includedFiles", "com/intellij/psi/css/impl/CssStylesheetImpl", "getRulesets"));
        }
        if (includedFiles.contains((Object)this)) {
            return CssRuleset.EMPTY_ARRAY;
        }
        includedFiles.add(this);
        ArrayList collection = new ArrayList();
        for (CssImport cssImport : this.getImports()) {
            PsiFile[] cssFiles;
            if (!allMedias && !cssImport.isScreen()) continue;
            for (PsiFile cssFile : cssFiles = cssImport.resolve()) {
                CssStylesheetImpl stylesheet;
                if (!(cssFile instanceof CssFile) || (stylesheet = (CssStylesheetImpl)((CssFile)cssFile).getStylesheet()) == null) continue;
                Object[] rulesets = stylesheet.getRulesets(includedFiles, allMedias);
                ContainerUtil.addAll(collection, (Object[])rulesets);
            }
        }
        ContainerUtil.addAll(collection, (Object[])this.getRulesetList().getRulesets(allMedias));
        return (CssRuleset[])ArrayUtil.toObjectArray(collection, CssRuleset.class);
    }

    private CssAtRule[] getAtRules(@NotNull Set<CssStylesheet> includedFiles) {
        if (includedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "includedFiles", "com/intellij/psi/css/impl/CssStylesheetImpl", "getAtRules"));
        }
        if (includedFiles.contains((Object)this)) {
            return CssAtRule.EMPTY_ARRAY;
        }
        includedFiles.add(this);
        ArrayList atRules = ContainerUtil.newArrayList();
        for (CssImport cssImport : this.getImports()) {
            PsiFile[] cssFiles;
            if (!cssImport.isScreen()) continue;
            for (PsiFile cssFile : cssFiles = cssImport.resolve()) {
                CssStylesheetImpl stylesheet;
                if (!(cssFile instanceof CssFile) || (stylesheet = (CssStylesheetImpl)((CssFile)cssFile).getStylesheet()) == null) continue;
                CssAtRule[] importedAtRules = stylesheet.getAtRules(includedFiles);
                Collections.addAll(atRules, importedAtRules);
            }
        }
        Collections.addAll(atRules, this.getRulesetList().getAtRules());
        return (CssAtRule[])ArrayUtil.toObjectArray((Collection)atRules, CssAtRule.class);
    }

    @NotNull
    public List<CssImport> getImports() {
        List<CssImport> list = this.getImports(true);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssStylesheetImpl", "getImports"));
        }
        return list;
    }

    @NotNull
    public List<CssImport> getImports(boolean fromImportListOnly) {
        if (fromImportListOnly) {
            CssImportList importList = this.getImportList();
            List list = importList == null ? Collections.emptyList() : importList.getImports();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssStylesheetImpl", "getImports"));
            }
            return list;
        }
        List list = (List)CachedValuesManager.getCachedValue((PsiElement)this, (CachedValueProvider)new CachedValueProvider<List<CssImport>>(){

            public CachedValueProvider.Result<List<CssImport>> compute() {
                return CachedValueProvider.Result.create((Object)CssStylesheetImpl.this.collectAllImports(), (Object[])new Object[]{CssStylesheetImpl.this});
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssStylesheetImpl", "getImports"));
        }
        return list;
    }

    private List<CssImport> collectAllImports() {
        final ArrayList<CssImport> result = new ArrayList<CssImport>();
        this.accept((PsiElementVisitor)new CssElementVisitor(){

            public void visitCssImport(CssImport _import) {
                result.add(_import);
            }

            public void visitElement(PsiElement element) {
                element.acceptChildren((PsiElementVisitor)this);
            }
        });
        return result;
    }

    public CssRuleset addRuleset(@NotNull CssRuleset ruleset) throws IncorrectOperationException {
        PsiElement psiElement;
        if (ruleset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ruleset", "com/intellij/psi/css/impl/CssStylesheetImpl", "addRuleset"));
        }
        PsiElement wrapper = ruleset.getParent();
        if (wrapper != null && wrapper instanceof CssRulesetWrappingElement && ((CssRulesetWrappingElement)wrapper).getRulesets().length == 1) {
            CssRulesetWrappingElement newWrapper = (CssRulesetWrappingElement)this.getRulesetList().add(wrapper);
            psiElement = (PsiElement)ArrayUtil.getFirstElement((Object[])newWrapper.getRulesets());
        } else {
            psiElement = this.getRulesetList().add((PsiElement)ruleset);
        }
        return (CssRuleset)psiElement;
    }

    @Nullable
    public CssCharset getCharset() {
        return (CssCharset)PsiTreeUtil.getChildOfType((PsiElement)this, CssCharsetImpl.class);
    }

    public XmlTag getParentTag() {
        PsiElement parent = this.getParent();
        if (parent instanceof XmlTag) {
            return (XmlTag)parent;
        }
        return null;
    }

    public XmlTagChild getNextSiblingInTag() {
        PsiElement nextSibling = this.getNextSibling();
        if (nextSibling instanceof XmlTagChild) {
            return (XmlTagChild)nextSibling;
        }
        return null;
    }

    public XmlTagChild getPrevSiblingInTag() {
        PsiElement prevSibling = this.getPrevSibling();
        if (prevSibling instanceof XmlTagChild) {
            return (XmlTagChild)prevSibling;
        }
        return null;
    }

    public boolean processElements(PsiElementProcessor processor, PsiElement place) {
        return XmlUtil.processXmlElements((XmlElement)this, (PsiElementProcessor)processor, (boolean)false);
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/css/impl/CssStylesheetImpl", "accept"));
        }
        if (visitor instanceof CssElementVisitor) {
            ((CssElementVisitor)visitor).visitCssStylesheet((CssStylesheet)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }
}

