/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.descriptor;

import com.intellij.psi.css.descriptor.BrowserVersion;
import com.intellij.psi.css.descriptor.CssContextType;
import com.intellij.psi.css.descriptor.CssElementDescriptor;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssCommonDescriptorData {
    @NotNull
    final String id;
    @NotNull
    final String presentableName;
    @NotNull
    final CssContextType[] allowedInRules;
    @NotNull
    final BrowserVersion[] browsers;
    @NotNull
    final CssElementDescriptor.CssVersion cssVersion;
    @NotNull
    final String description;
    @Nullable
    final String specificationUrl;

    public CssCommonDescriptorData(@NotNull String id, @NotNull String presentableName, @NotNull CssContextType[] rules, @NotNull BrowserVersion[] browsers, @NotNull CssElementDescriptor.CssVersion version, @Nullable String specificationUrl, @NotNull String description) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/psi/css/impl/descriptor/CssCommonDescriptorData", "<init>"));
        }
        if (presentableName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentableName", "com/intellij/psi/css/impl/descriptor/CssCommonDescriptorData", "<init>"));
        }
        if (rules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rules", "com/intellij/psi/css/impl/descriptor/CssCommonDescriptorData", "<init>"));
        }
        if (browsers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browsers", "com/intellij/psi/css/impl/descriptor/CssCommonDescriptorData", "<init>"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/psi/css/impl/descriptor/CssCommonDescriptorData", "<init>"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/psi/css/impl/descriptor/CssCommonDescriptorData", "<init>"));
        }
        this.id = id;
        this.presentableName = presentableName;
        this.allowedInRules = rules;
        this.browsers = browsers;
        this.cssVersion = version;
        this.specificationUrl = specificationUrl;
        this.description = description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CssCommonDescriptorData)) {
            return false;
        }
        CssCommonDescriptorData that = (CssCommonDescriptorData)o;
        if (!Arrays.equals(this.allowedInRules, that.allowedInRules)) {
            return false;
        }
        if (!Arrays.equals(this.browsers, that.browsers)) {
            return false;
        }
        if (this.cssVersion != that.cssVersion) {
            return false;
        }
        if (!this.description.equals(that.description)) {
            return false;
        }
        if (!this.id.equals(that.id)) {
            return false;
        }
        if (!this.presentableName.equals(that.presentableName)) {
            return false;
        }
        return !(this.specificationUrl != null ? !this.specificationUrl.equals(that.specificationUrl) : that.specificationUrl != null);
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + this.presentableName.hashCode();
        result = 31 * result + Arrays.hashCode(this.allowedInRules);
        result = 31 * result + Arrays.hashCode(this.browsers);
        result = 31 * result + this.cssVersion.hashCode();
        result = 31 * result + this.description.hashCode();
        result = 31 * result + (this.specificationUrl != null ? this.specificationUrl.hashCode() : 0);
        return result;
    }

    @NotNull
    public CssCommonDescriptorData cloneWithPrefix(@NotNull String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/psi/css/impl/descriptor/CssCommonDescriptorData", "cloneWithPrefix"));
        }
        CssCommonDescriptorData cssCommonDescriptorData = new CssCommonDescriptorData(prefix + this.id, prefix + this.presentableName, this.allowedInRules, this.browsers, this.cssVersion, this.specificationUrl, this.description);
        if (cssCommonDescriptorData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/descriptor/CssCommonDescriptorData", "cloneWithPrefix"));
        }
        return cssCommonDescriptorData;
    }
}

